/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.net;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.net.BaseTcpProtocol;
import com.JRcServer.commons.net.ConnectAddress;
import com.JRcServer.commons.net.ConnectTimeoutException;
import com.JRcServer.commons.net.NotBindException;
import com.JRcServer.commons.net.NotConnectException;
import com.JRcServer.commons.net.UndefineBindException;
import com.JRcServer.commons.thread.Synchronized;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;

public class TcpProtocol
implements BaseTcpProtocol {
    private static final int RECV_BUFLEN = 4096;
    private int m_bufLen = 0;
    private long m_lastTime = 0L;
    private Socket m_net = null;
    private BufferedOutputStream m_send = null;
    private BufferedInputStream m_recv = null;
    protected final Synchronized m_sync = new Synchronized();

    public TcpProtocol() {
    }

    public TcpProtocol(Socket conn) throws InputException {
        this(conn, 65535);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TcpProtocol(Socket conn, int bufLen) throws InputException {
        if (conn == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.disconnect();
        this.m_sync.create();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_net = conn;
                this.connectTo(bufLen <= 65535 ? 65535 : bufLen);
            }
        }
        catch (Exception t) {
            this.disconnect();
            throw new InputException(t);
        }
    }

    protected final void finalize() throws Exception {
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void connect(InetAddress addr, int port) throws InputException, NotConnectException {
        this.connect(addr, port, 65535);
    }

    public final void connect(InetAddress addr, int port, InetAddress loAddr, int loPort) throws InputException, NotBindException, NotConnectException {
        this.connect(addr, port, loAddr, loPort, 65535);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connect(InetAddress addr, int port, int bufLen) throws InputException, NotConnectException {
        if (addr == null || port < 0 || port > 65535) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.disconnect();
        this.m_sync.create();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_net = new Socket(addr, port);
                this.connectTo(bufLen <= 65535 ? 65535 : bufLen);
            }
        }
        catch (NullPointerException nul) {
            this.disconnect();
        }
        catch (IOException io) {
            this.disconnect();
            throw new NotConnectException(io);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void connect(InetAddress addr, int port, InetAddress loAddr, int loPort, int bufLen) throws InputException, NotBindException, NotConnectException {
        if (addr == null || port < 0 || port > 65535 || loAddr == null || loPort < 0 || loPort > 65535) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.disconnect();
        this.m_sync.create();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_net = new Socket(addr, port, loAddr, loPort);
                this.connectTo(bufLen <= 65535 ? 65535 : bufLen);
            }
        }
        catch (NullPointerException nul) {
            this.disconnect();
        }
        catch (SocketException so) {
            this.disconnect();
            throw new NotConnectException(so);
        }
        catch (IOException io) {
            this.disconnect();
            throw new NotBindException(io);
        }
    }

    public final void disconnect() {
        this.m_sync.clear();
        try {
            this.m_send.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_recv.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_net.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_send = null;
        this.m_recv = null;
        this.m_net = null;
        this.m_bufLen = 0;
        this.m_lastTime = 0L;
    }

    public final void send(byte[] message) throws InputException, UndefineBindException {
        this.send(message, 0, 0);
    }

    public final void send(byte[] message, int length) throws InputException, UndefineBindException {
        this.send(message, 0, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void send(byte[] message, int offset, int length) throws InputException, UndefineBindException {
        if (message == null || message.length <= 0) {
            if (message == null) {
                throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            }
            return;
        }
        if (length == 0) {
            length = message.length;
        }
        try {
            this.m_send.write(message, offset, length);
            this.m_send.flush();
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_lastTime = System.currentTimeMillis();
            }
        }
        catch (NullPointerException nul) {
            this.disconnect();
            throw new UndefineBindException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u51e6\u7406\u306f\u884c\u308f\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        catch (IOException io) {
            this.disconnect();
            throw new UndefineBindException(io);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final byte[] receive(int timeout) throws UndefineBindException, ConnectTimeoutException {
        block11: {
            ret = null;
            out = null;
            out = new ByteArrayOutputStream();
            try {
                try {
                    this.receive(out, timeout);
                    ret = out.toByteArray();
                }
                catch (InputException in) {
                    this.disconnect();
                    ret = null;
                }
                catch (UndefineBindException ub) {
                    this.disconnect();
                    throw ub;
                }
                catch (ConnectTimeoutException ct) {
                    throw ct;
                }
            }
            catch (Throwable var6_7) {
                var5_8 = null;
                try {
                    out.close();
                }
                catch (Exception var7_10) {
                    // empty catch block
                }
                out = null;
                throw var6_7;
            }
            {
                var5_9 = null;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 67->74)] { 
lbl31:
            // 1 sources

            out.close();
            break block11;
lbl33:
            // 1 sources

            catch (Exception var7_11) {
                // empty catch block
            }
        }
        out = null;
        return ret;
    }

    /*
     * Exception decompiling
     */
    public final void receive(ByteArrayOutputStream out, int timeout) throws InputException, UndefineBindException, ConnectTimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [7 : 261->265)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getLocal(ConnectAddress addr) {
        block7: {
            try {
                if (addr == null) break block7;
                Object object = this.m_sync.get();
                synchronized (object) {
                    addr.create(this.m_net.getLocalAddress(), this.m_net.getLocalPort());
                }
            }
            catch (Exception t) {
                if (addr == null) break block7;
                try {
                    addr.clear();
                    addr.create("0.0.0.0", 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getConnect(ConnectAddress addr) {
        block7: {
            try {
                if (addr == null) break block7;
                Object object = this.m_sync.get();
                synchronized (object) {
                    addr.create(this.m_net.getInetAddress(), this.m_net.getPort());
                }
            }
            catch (Exception t) {
                if (addr == null) break block7;
                try {
                    addr.clear();
                    addr.create("0.0.0.0", 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ConnectAddress getLocal() {
        ConnectAddress ret = new ConnectAddress();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = new ConnectAddress(this.m_net.getInetAddress(), this.m_net.getPort());
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getBuffer() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_bufLen;
            }
        }
        catch (Exception t) {
            this.disconnect();
            ret = 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getLastTime() {
        long ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_lastTime;
            }
        }
        catch (Exception t) {
            ret = 0L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnect() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_net.getSoTimeout();
                ret = true;
            }
        }
        catch (Exception t) {
            this.disconnect();
            ret = false;
        }
        return ret;
    }

    private final void connectTo(int bufLen) throws IOException {
        try {
            this.m_net.setKeepAlive(true);
            this.m_net.setSoLinger(false, 0);
            this.m_net.setTcpNoDelay(true);
            this.m_net.setReceiveBufferSize(bufLen);
            this.m_net.setSendBufferSize(bufLen);
            this.m_net.setSoTimeout(0);
            this.m_send = new BufferedOutputStream(this.m_net.getOutputStream());
            this.m_recv = new BufferedInputStream(this.m_net.getInputStream());
            this.m_bufLen = bufLen;
            this.m_lastTime = System.currentTimeMillis();
        }
        catch (IOException io) {
            this.disconnect();
            throw io;
        }
    }
}

