/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.net;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.net.TelegramResourceValue;
import com.JRcServer.commons.net.TelegramValue;
import com.JRcServer.commons.resource.BinResource;
import com.JRcServer.commons.resource.Resource;
import com.JRcServer.commons.resource.ResourceType;
import com.JRcServer.commons.util.Roll;
import java.net.InetAddress;

public class TelegramResourceRoll
implements Roll {
    private static final int DEF_SIZE = 32;
    private TelegramResourceValue[] m_roll = null;
    private ResourceType m_resType = null;
    private int m_max = 0;
    private int m_now = 0;
    private int m_nowLen = 0;
    private boolean m_mode = false;
    private int m_addResCnt = 0;

    private TelegramResourceRoll() {
    }

    public TelegramResourceRoll(ResourceType resType, int max) throws InputException {
        this(false, resType, max);
    }

    public TelegramResourceRoll(boolean mode, ResourceType resType, int max) throws InputException {
        TelegramResourceValue[] roll = null;
        if (resType == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.m_mode = mode;
        max = max <= 32 ? 32 : max;
        roll = new TelegramResourceValue[max];
        if (mode) {
            int i = 0;
            while (i < max) {
                roll[i] = new TelegramResourceValue();
                roll[i].RES = null;
                roll[i].ADDR = null;
                roll[i].PORT = -1;
                ++i;
            }
        } else {
            int i = 0;
            while (i < max) {
                roll[i] = new TelegramResourceValue();
                roll[i].RES = Resource.createBinResource(resType, 1);
                roll[i].ADDR = null;
                roll[i].PORT = -1;
                ++i;
            }
        }
        this.m_roll = roll;
        this.m_resType = resType;
        this.m_max = max;
        this.m_now = 0;
        this.m_nowLen = 0;
        this.m_addResCnt = 0;
    }

    protected final void finalize() throws Exception {
        this.destroy();
    }

    public final void destroy() {
        TelegramResourceValue[] roll = null;
        int len = this.m_max;
        if (len > 0) {
            roll = this.m_roll;
            int i = 0;
            while (i < len) {
                if (roll[i] != null) {
                    roll[i].clear();
                }
                roll[i] = null;
                ++i;
            }
        }
        this.m_roll = null;
        this.m_resType = null;
        this.m_max = 0;
        this.m_now = 0;
        this.m_nowLen = 0;
        this.m_addResCnt = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addReservationByON() {
        TelegramResourceRoll telegramResourceRoll = this;
        synchronized (telegramResourceRoll) {
            ++this.m_addResCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addReservationByOFF() {
        TelegramResourceRoll telegramResourceRoll = this;
        synchronized (telegramResourceRoll) {
            this.m_addResCnt = this.m_addResCnt <= 0 ? 0 : this.m_addResCnt - 1;
        }
    }

    public final boolean add(byte[] value, InetAddress addr, int port) throws InputException {
        return this.addTo(false, -1, value, addr, port, 0);
    }

    public final boolean add(byte[] value, InetAddress addr, int port, int resendCnt) throws InputException {
        return this.addTo(false, -1, value, addr, port, resendCnt);
    }

    public final boolean add(int id, byte[] value, InetAddress addr, int port) throws InputException {
        return this.addTo(false, id, value, addr, port, 0);
    }

    public final boolean add(int id, byte[] value, InetAddress addr, int port, int resendCnt) throws InputException {
        return this.addTo(false, id, value, addr, port, resendCnt);
    }

    public final boolean add(BinResource value, InetAddress addr, int port) throws InputException {
        return this.addTo(false, -1, value, addr, port, 0);
    }

    public final boolean add(BinResource value, InetAddress addr, int port, int resendCnt) throws InputException {
        return this.addTo(false, -1, value, addr, port, resendCnt);
    }

    public final boolean add(int id, BinResource value, InetAddress addr, int port) throws InputException {
        return this.addTo(false, id, value, addr, port, 0);
    }

    public final boolean add(int id, BinResource value, InetAddress addr, int port, int resendCnt) throws InputException {
        return this.addTo(false, id, value, addr, port, resendCnt);
    }

    public final boolean addHead(byte[] value, InetAddress addr, int port) throws InputException {
        return this.addTo(true, -1, value, addr, port, 0);
    }

    public final boolean addHead(byte[] value, InetAddress addr, int port, int resendCnt) throws InputException {
        return this.addTo(true, -1, value, addr, port, resendCnt);
    }

    public final boolean addHead(int id, byte[] value, InetAddress addr, int port) throws InputException {
        return this.addTo(true, id, value, addr, port, 0);
    }

    public final boolean addHead(int id, byte[] value, InetAddress addr, int port, int resendCnt) throws InputException {
        return this.addTo(true, id, value, addr, port, resendCnt);
    }

    public final boolean addHead(BinResource value, InetAddress addr, int port) throws InputException {
        return this.addTo(true, -1, value, addr, port, 0);
    }

    public final boolean addHead(BinResource value, InetAddress addr, int port, int resendCnt) throws InputException {
        return this.addTo(true, -1, value, addr, port, resendCnt);
    }

    public final boolean addHead(int id, BinResource value, InetAddress addr, int port) throws InputException {
        return this.addTo(true, id, value, addr, port, 0);
    }

    public final boolean addHead(int id, BinResource value, InetAddress addr, int port, int resendCnt) throws InputException {
        return this.addTo(true, id, value, addr, port, resendCnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean get(TelegramValue out) {
        TelegramResourceValue[] roll = null;
        boolean ret = false;
        TelegramResourceRoll telegramResourceRoll = this;
        synchronized (telegramResourceRoll) {
            if (this.m_nowLen <= 0 || out == null) {
                ret = false;
            } else {
                roll = this.m_roll;
                int pnt = this.m_now - this.m_nowLen;
                if (pnt < 0) {
                    pnt = this.m_max + pnt;
                }
                out.clear();
                if (this.m_mode) {
                    out.setBinary(roll[pnt].RES);
                    roll[pnt].RES = null;
                } else {
                    out.setBinary(roll[pnt].RES.getBinary());
                    roll[pnt].RES.reset();
                }
                out.setAddress(roll[pnt].ADDR);
                out.setPort(roll[pnt].PORT);
                out.setID(roll[pnt].ID);
                out.setResendCount(roll[pnt].RESEND_CNT);
                out.setUse();
                roll[pnt].ADDR = null;
                roll[pnt].PORT = -1;
                roll[pnt].ID = -1;
                --this.m_nowLen;
                ret = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getMax() {
        int ret;
        TelegramResourceRoll telegramResourceRoll = this;
        synchronized (telegramResourceRoll) {
            ret = this.m_max;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getSize() {
        int ret;
        TelegramResourceRoll telegramResourceRoll = this;
        synchronized (telegramResourceRoll) {
            ret = this.m_nowLen;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isMode() {
        boolean ret;
        TelegramResourceRoll telegramResourceRoll = this;
        synchronized (telegramResourceRoll) {
            ret = this.m_mode;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAdd() {
        boolean ret;
        TelegramResourceRoll telegramResourceRoll = this;
        synchronized (telegramResourceRoll) {
            if (this.m_nowLen + this.m_addResCnt >= this.m_max) {
                boolean bl = false;
            }
            ret = true;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAddReservation() {
        boolean ret;
        TelegramResourceRoll telegramResourceRoll = this;
        synchronized (telegramResourceRoll) {
            ret = this.m_addResCnt > 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean addTo(boolean hlMode, int id, byte[] value, InetAddress addr, int port, int resendCnt) throws InputException {
        TelegramResourceValue[] roll = null;
        if (value == null || value.length <= 0 || addr == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        boolean ret = false;
        TelegramResourceRoll telegramResourceRoll = this;
        synchronized (telegramResourceRoll) {
            if (this.m_nowLen + this.m_addResCnt >= this.m_max) {
                ret = false;
            } else {
                int next = this.getAddPoint(hlMode);
                roll = this.m_roll;
                if (this.m_mode) {
                    if (roll[next].RES != null) {
                        roll[next].RES.clear();
                        roll[next].RES = null;
                    }
                    roll[next].RES = Resource.createBinResource(this.m_resType, value);
                } else if (roll[next].RES == null || roll[next].RES.getAllSize() > Resource.getRenewRollValueCode(value.length)) {
                    if (roll[next].RES != null) {
                        roll[next].RES.clear();
                        roll[next].RES = null;
                    }
                    roll[next].RES = Resource.createBinResource(this.m_resType, value);
                } else {
                    roll[next].RES.reset();
                    roll[next].RES.setBinary(0, value);
                }
                roll[next].ADDR = addr;
                roll[next].PORT = port;
                roll[next].ID = id;
                roll[next].RESEND_CNT = resendCnt <= 0 ? 0 : resendCnt;
                ret = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean addTo(boolean hlMode, int id, BinResource value, InetAddress addr, int port, int resendCnt) throws InputException {
        TelegramResourceValue[] roll = null;
        if (value == null || !value.isUse() || value.size() <= 0 || addr == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        boolean ret = false;
        TelegramResourceRoll telegramResourceRoll = this;
        synchronized (telegramResourceRoll) {
            if (!this.m_mode && this.m_nowLen + this.m_addResCnt >= this.m_max) {
                ret = false;
            } else {
                int next = this.getAddPoint(hlMode);
                roll = this.m_roll;
                if (roll[next].RES != null) {
                    roll[next].RES.clear();
                    roll[next].RES = null;
                }
                roll[next].RES = value;
                roll[next].ADDR = addr;
                roll[next].PORT = port;
                roll[next].ID = id;
                roll[next].RESEND_CNT = resendCnt <= 0 ? 0 : resendCnt;
                ret = true;
            }
        }
        return ret;
    }

    private final int getAddPoint(boolean hlMode) {
        int ret = this.m_now;
        if (hlMode) {
            if (this.m_nowLen > 0) {
                ret = this.m_now - this.m_nowLen;
                if (ret < 0) {
                    ret = this.m_max + ret;
                }
                if (--ret < 0) {
                    ret = this.m_max - 1;
                }
            } else {
                if (ret >= this.m_max) {
                    ret = 0;
                }
                this.m_now = ret + 1;
            }
            ++this.m_nowLen;
        } else {
            if (ret >= this.m_max) {
                ret = 0;
            }
            ++this.m_nowLen;
            this.m_now = ret + 1;
        }
        return ret;
    }
}

