/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.net;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.net.BaseUdpProtocol;
import com.JRcServer.commons.net.ConnectAddress;
import com.JRcServer.commons.net.ConnectTimeoutException;
import com.JRcServer.commons.net.NotBindException;
import com.JRcServer.commons.net.UndefineBindException;
import com.JRcServer.commons.thread.Synchronized;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;

public class UdpProtocol
implements BaseUdpProtocol {
    private DatagramSocket m_udp = null;
    private final byte[] m_binary = new byte[65535];
    private long m_lastTime = 0L;
    private final Synchronized m_sync = new Synchronized();
    private final Synchronized m_sendSync = new Synchronized();
    private final Synchronized m_recvSync = new Synchronized();

    protected final void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void open(int bufLen) throws NotBindException {
        this.openTo(3, bufLen);
    }

    public final void open(int bufLen, int port) throws InputException, NotBindException {
        this.openTo(3, bufLen, port);
    }

    public final void open(int bufLen, int port, InetAddress addr) throws InputException, NotBindException {
        this.openTo(3, bufLen, port, addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void openTo(int bufMode, int bufLen) throws NotBindException {
        this.close();
        this.m_sync.create();
        this.m_sendSync.create();
        this.m_recvSync.create();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_udp = new DatagramSocket();
                if (!this.createUDP(bufMode, bufLen)) {
                    this.close();
                }
            }
        }
        catch (NullPointerException nul) {
            this.close();
        }
        catch (SocketException so) {
            this.close();
            throw new NotBindException(so);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void openTo(int bufMode, int bufLen, int port) throws InputException, NotBindException {
        if (port <= 0 || port >= 65535) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.close();
        this.m_sync.create();
        this.m_sendSync.create();
        this.m_recvSync.create();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_udp = new DatagramSocket(port);
                if (!this.createUDP(bufMode, bufLen)) {
                    this.close();
                }
            }
        }
        catch (NullPointerException nul) {
            this.close();
        }
        catch (SocketException so) {
            this.close();
            throw new NotBindException(so);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void openTo(int bufMode, int bufLen, int port, InetAddress addr) throws InputException, NotBindException {
        if (addr == null || port <= 0 || port >= 65535) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.close();
        this.m_sync.create();
        this.m_sendSync.create();
        this.m_recvSync.create();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_udp = new DatagramSocket(port, addr);
                if (!this.createUDP(bufMode, bufLen)) {
                    this.close();
                }
            }
        }
        catch (NullPointerException nul) {
            this.close();
        }
        catch (SocketException so) {
            this.close();
            throw new NotBindException(so);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void close() {
        this.m_sync.clear();
        this.m_sendSync.clear();
        this.m_recvSync.clear();
        this.m_lastTime = 0L;
        try {
            try {
                this.m_udp.close();
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.m_udp = null;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.m_udp = null;
            return;
        }
    }

    public final void send(byte[] binary, ConnectAddress addr) throws InputException, UndefineBindException {
        if (addr == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.send(binary, addr.getAddress(), addr.getPort());
    }

    /*
     * Exception decompiling
     */
    public final void send(byte[] binary, InetAddress addr, int port) throws InputException, UndefineBindException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [6 : 137->141)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final byte[] receive(ConnectAddress addr) throws UndefineBindException, ConnectTimeoutException {
        return this.receive(addr, 0);
    }

    /*
     * Exception decompiling
     */
    public final byte[] receive(ConnectAddress addr, int timeout) throws UndefineBindException, ConnectTimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [7 : 188->191)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final int receive(byte[] out, ConnectAddress addr) throws InputException, UndefineBindException, ConnectTimeoutException {
        return this.receive(out, addr, 0);
    }

    /*
     * Exception decompiling
     */
    public final int receive(byte[] out, ConnectAddress addr, int timeout) throws InputException, UndefineBindException, ConnectTimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [6 : 200->203)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void getLocal(ConnectAddress addr) {
        block7: {
            try {
                if (addr == null) break block7;
                Object object = this.m_sync.get();
                synchronized (object) {
                    addr.create(this.m_udp.getLocalAddress(), this.m_udp.getLocalPort());
                }
            }
            catch (Exception t) {
                if (addr == null) break block7;
                try {
                    addr.clear();
                    addr.create("0.0.0.0", 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ConnectAddress getLocal() {
        ConnectAddress ret = new ConnectAddress();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = new ConnectAddress(this.m_udp.getLocalAddress(), this.m_udp.getLocalPort());
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InetAddress getLocalAddress() {
        InetAddress ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_udp.getLocalAddress();
            }
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getLocalPort() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_udp.getLocalPort();
            }
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getBuffer() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_udp.getSendBufferSize();
            }
        }
        catch (Exception t) {
            ret = 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isOpen() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_udp.getSendBufferSize();
                ret = this.m_udp != null;
            }
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }

    private final boolean createUDP(int bufMode, int bufLen) {
        boolean ret;
        bufLen = bufLen <= 65535 ? 65535 : bufLen;
        try {
            if ((bufMode & 1) != 0) {
                this.m_udp.setSendBufferSize((int)((double)bufLen * 0.75));
            } else {
                this.m_udp.setSendBufferSize(49151);
            }
            if ((bufMode & 2) != 0) {
                this.m_udp.setReceiveBufferSize((int)((double)bufLen * 1.25));
            } else {
                this.m_udp.setReceiveBufferSize(81918);
            }
            this.m_udp.setSoTimeout(0);
            ret = true;
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }
}

