/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.net.ftp;

import com.JRcServer.commons.def.BaseDef;
import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.net.NotLoginException;
import com.JRcServer.commons.net.ftp.FTPDef;
import com.JRcServer.commons.net.ftp.FTPPause;
import com.JRcServer.commons.thread.Synchronized;
import com.JRcServer.commons.util.CharTable;
import com.JRcServer.commons.util.DateTimeFormat;
import com.JRcServer.commons.util.UtilCom;
import com.JRcServer.commons.util.array.ObjectArray;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;

public class FTPClient {
    private static final int BO_BUFFER_SIZE = 524288;
    private Socket m_socket = null;
    private PrintWriter m_writer = null;
    private BufferedReader m_reader = null;
    private String m_system = null;
    private String m_userName = null;
    private String m_passwd = null;
    private String m_consoleCharset = null;
    private String m_commandCharset = null;
    private String m_beforeDir = null;
    private int m_timeout = 0;
    private boolean m_mode = false;
    private boolean m_pasv = false;
    private boolean m_isDebug = false;
    private boolean m_isGetLoginList = true;
    private PrintStream m_debugWriter = System.out;
    private final CharTable m_table = new CharTable();
    private final ObjectArray m_readBuf = new ObjectArray();
    private final ObjectArray m_tmp = new ObjectArray();
    private final DateTimeFormat m_format = new DateTimeFormat("YYYYMMDDhhmmss");
    private final Synchronized m_sync = new Synchronized();
    private final Synchronized m_readSync = new Synchronized();

    public FTPClient() {
    }

    public FTPClient(boolean mode) {
        this.setDebugMode(mode, null);
    }

    public FTPClient(boolean mode, PrintStream stream) {
        this.setDebugMode(mode, stream);
    }

    public FTPClient(String host) throws InputException, AccessException {
        this.open(false, host, 21, "anonymous", "", null, null);
    }

    public FTPClient(String host, int port) throws InputException, AccessException {
        this.open(false, host, port, "anonymous", "", null, null);
    }

    public FTPClient(String host, String user, String passwd) throws InputException, AccessException {
        this.open(false, host, 21, user, passwd, null, null);
    }

    public FTPClient(String host, int port, String user, String passwd) throws InputException, AccessException {
        this.open(false, host, port, user, passwd, null, null);
    }

    public FTPClient(boolean pasv, String host) throws InputException, AccessException {
        this.open(pasv, host, 21, "anonymous", "", null, null);
    }

    public FTPClient(boolean pasv, String host, int port) throws InputException, AccessException {
        this.open(pasv, host, port, "anonymous", "", null, null);
    }

    public FTPClient(boolean pasv, String host, String user, String passwd) throws InputException, AccessException {
        this.open(pasv, host, 21, user, passwd, null, null);
    }

    public FTPClient(boolean pasv, String host, int port, String user, String passwd) throws InputException, AccessException {
        this.open(pasv, host, port, user, passwd, null, null);
    }

    public FTPClient(String host, String user, String passwd, String cons, String cmd) throws InputException, AccessException {
        this.open(false, host, 21, user, passwd, cons, cmd);
    }

    public FTPClient(String host, int port, String user, String passwd, String cons, String cmd) throws InputException, AccessException {
        this.open(false, host, port, user, passwd, cons, cmd);
    }

    public FTPClient(boolean pasv, String host, String user, String passwd, String cons, String cmd) throws InputException, AccessException {
        this.open(pasv, host, 21, user, passwd, cons, cmd);
    }

    public FTPClient(boolean pasv, String host, int port, String user, String passwd, String cons, String cmd) throws InputException, AccessException {
        this.open(pasv, host, port, user, passwd, cons, cmd);
    }

    protected final void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void open(String host) throws InputException, AccessException {
        this.open(false, host, 21, "anonymous", "", null, null);
    }

    public final void open(String host, int port) throws InputException, AccessException {
        this.open(false, host, port, "anonymous", "", null, null);
    }

    public final void open(String host, String user, String passwd) throws InputException, AccessException {
        this.open(false, host, 21, user, passwd, null, null);
    }

    public final void open(String host, int port, String user, String passwd) throws InputException, AccessException {
        this.open(false, host, port, user, passwd, null, null);
    }

    public final void open(boolean pasv, String host) throws InputException, AccessException {
        this.open(pasv, host, 21, "anonymous", "", null, null);
    }

    public final void open(boolean pasv, String host, int port) throws InputException, AccessException {
        this.open(pasv, host, port, "anonymous", "", null, null);
    }

    public final void open(boolean pasv, String host, String user, String passwd) throws InputException, AccessException {
        this.open(pasv, host, 21, user, passwd, null, null);
    }

    public final void open(boolean pasv, String host, int port, String user, String passwd) throws InputException, AccessException {
        this.open(pasv, host, port, user, passwd, null, null);
    }

    public final void open(String host, String user, String passwd, String cons, String cmd) throws InputException, AccessException {
        this.open(false, host, 21, user, passwd, cons, cmd);
    }

    public final void open(String host, int port, String user, String passwd, String cons, String cmd) throws InputException, AccessException {
        this.open(false, host, port, user, passwd, cons, cmd);
    }

    public final void open(boolean pasv, String host, String user, String passwd, String cons, String cmd) throws InputException, AccessException {
        this.open(pasv, host, 21, user, passwd, cons, cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open(boolean pasv, String host, int port, String user, String passwd, String cons, String cmd) throws InputException, AccessException {
        if (host == null || port < 0 || port > 65535 || user == null || user.length() <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.close();
        this.m_sync.create();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_pasv = pasv;
                this.createConnect(host, port, cmd, cons);
                this.doLogin(user, passwd);
                this.setMode(false);
            }
        }
        catch (InputException in) {
            this.close();
            throw in;
        }
        catch (AccessException ac) {
            this.close();
            throw ac;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.doQuit();
                this.clearConnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_sync.clear();
        try {
            this.doQuit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.clearConnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_table.clear();
        this.m_readBuf.clear();
        this.m_tmp.clear();
        this.m_system = null;
        this.m_userName = null;
        this.m_passwd = null;
        this.m_consoleCharset = null;
        this.m_commandCharset = null;
        this.m_beforeDir = null;
        this.m_timeout = 0;
        this.m_mode = false;
        this.m_pasv = false;
    }

    /*
     * Exception decompiling
     */
    public final void send(String name, InputStream reader) throws InputException, AccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [5 : 301->305)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final void receive(String name, OutputStream writer) throws InputException, AccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [5 : 301->305)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final boolean moveList(String name) throws InputException {
        boolean ret;
        if (name == null || name.length() < 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.doCd(name);
            this.getList(null);
            ret = true;
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }

    public final boolean downList() {
        boolean ret;
        try {
            this.doCd("..");
            this.getList(null);
            ret = true;
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMode(boolean mode) {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.doMode(mode);
                this.m_mode = mode;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean changeName(String src, String dest) {
        boolean ret = false;
        if (src != null && dest != null && src.indexOf("/") == -1 && dest.indexOf("/") == -1) {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    this.doRename(src, dest);
                    ret = true;
                }
            }
            catch (Exception t) {
                ret = false;
            }
        }
        return ret;
    }

    public final boolean mkdir(String name) {
        boolean ret = false;
        if (name != null) {
            try {
                this.doMkDir(name);
                ret = true;
            }
            catch (Exception t) {
                ret = false;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean delete(String name) {
        block21: {
            file = null;
            pause = null;
            ret = false;
            if (name == null) return ret;
            try {
                try {
                    var5_5 = this.m_sync.get();
                    synchronized (var5_5) {
                        if (name.indexOf("/") == -1) {
                            pause = (FTPPause)this.m_table.get(name = UtilCom.trimPlus(name));
                            if (pause != null) {
                                if (pause.getMode()) {
                                    this.doRmDir(name);
                                    this.getList(null);
                                    ret = true;
                                } else {
                                    this.doDel(name);
                                    this.getList(null);
                                    ret = true;
                                }
                            }
                        } else {
                            file = this.changeDirectory(name);
                            if (file == null) {
                                if (this.m_table.size() == 0 && (name = this.getLastName(name)) != null) {
                                    this.doCd("..");
                                    this.doRmDir(name);
                                    ret = true;
                                }
                            } else {
                                this.doDel(file);
                                ret = true;
                            }
                        }
                    }
                }
                catch (Exception t) {
                    ret = false;
                }
            }
            catch (Throwable var7_7) {
                var6_8 = null;
                try {
                    this.beforeDirectory();
                }
                catch (Exception var8_10) {
                    // empty catch block
                }
                file = null;
                throw var7_7;
            }
            {
                var6_9 = null;
            }
            ** try [egrp 3[TRYBLOCK] [5 : 176->183)] { 
lbl51:
            // 1 sources

            this.beforeDirectory();
            break block21;
lbl53:
            // 1 sources

            catch (Exception var8_11) {
                // empty catch block
            }
        }
        file = null;
        return ret;
    }

    public final boolean setOwner(String name, int own) {
        boolean ret = false;
        if (name != null && name.length() > 0) {
            try {
                this.doOwner(name, own);
                this.getList(null);
                ret = true;
            }
            catch (Exception t) {
                ret = false;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTimeout(int time) {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                if ((long)time > 0L) {
                    this.m_timeout = time;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLoginList(boolean flg) {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_isGetLoginList = flg;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void setDebugMode(boolean mode) {
        this.setDebugMode(mode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDebugMode(boolean mode, PrintStream stream) {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_isDebug = mode;
                if (stream != null) {
                    this.m_debugWriter = stream;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getPwd() {
        String ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.doPwd();
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getListDirs() {
        String[] ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.getNowList(true);
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getListFiles() {
        String[] ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.getNowList(false);
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getMode() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_mode;
            }
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    public final int getOwner(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 224->227)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final long getSize(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 118->121)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final long getDate(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 118->121)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getSystem() {
        String ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                if (this.m_system == null) {
                    this.m_system = this.doSystem();
                }
                ret = this.m_system;
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getTimeout() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_timeout;
            }
        }
        catch (Exception t) {
            ret = -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getCommandCharset() {
        String ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_commandCharset == null ? BaseDef.THIS_CHARSET : this.m_commandCharset;
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getConsoleCharset() {
        String ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_consoleCharset == null ? BaseDef.THIS_CHARSET : this.m_consoleCharset;
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PrintStream getDebugStream() {
        PrintStream ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_debugWriter;
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean isDir(String name) {
        block16: {
            pause = null;
            ret = false;
            if (name == null) return ret;
            try {
                try {
                    var4_4 = this.m_sync.get();
                    synchronized (var4_4) {
                        name = UtilCom.trimPlus(name);
                        if (name.indexOf("/") == -1) {
                            pause = (FTPPause)this.m_table.get(name);
                            if (pause != null) {
                                ret = pause.getMode();
                            }
                        } else if (this.changeDirectory(name) == null) {
                            ret = true;
                        }
                    }
                }
                catch (Exception t) {
                    ret = false;
                }
            }
            catch (Throwable var6_6) {
                var5_7 = null;
                try {
                    this.beforeDirectory();
                }
                catch (Exception var7_9) {
                    // empty catch block
                }
                pause = null;
                throw var6_6;
            }
            {
                var5_8 = null;
            }
            ** try [egrp 3[TRYBLOCK] [5 : 98->105)] { 
lbl36:
            // 1 sources

            this.beforeDirectory();
            break block16;
lbl38:
            // 1 sources

            catch (Exception var7_10) {
                // empty catch block
            }
        }
        pause = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isLoginList() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_isGetLoginList;
            }
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isPasv() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_pasv;
            }
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDebug() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_isDebug;
            }
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isOpen() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = true;
            }
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    private final void createConnect(String host, int port, String cmd, String cons) throws InputException, AccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 282->286)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void clearConnect() {
        try {
            this.m_writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_socket = null;
        this.m_writer = null;
        this.m_reader = null;
        this.m_readSync.clear();
    }

    /*
     * Exception decompiling
     */
    private final void doLogin(String user, String passwd) throws InputException, NotLoginException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 155->159)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void doQuit() throws AccessException {
        String quitCmd = "QUIT ";
        try {
            this.outDebug(false, quitCmd);
            this.m_writer.println(quitCmd);
            this.m_writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final String doSystem() throws AccessException {
        String ret;
        try {
            this.doMode(true);
            ret = this.execCmd("SYST ");
            this.checkTelegram();
            ret = UtilCom.trimPlus(ret);
            this.doMode(this.m_mode);
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    private final String doPwd() throws AccessException {
        StringBuffer buf = null;
        String pwd = null;
        String ret = null;
        pwd = this.execCmd("PWD ");
        if (pwd == null) {
            throw new AccessException("[PWD]\u30b3\u30de\u30f3\u30c9\u306e\u5b9f\u65bd\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        this.checkTelegram();
        if (pwd != null) {
            int len = pwd.length();
            int i = 0;
            int pnt = -1;
            while (i < len) {
                if (pwd.charAt(i) == '\"') {
                    if (pnt == -1) {
                        pnt = i + 1;
                    } else {
                        ret = pwd.substring(pnt, i);
                        if (ret.charAt((len = ret.length()) - 1) == '/') break;
                        buf = new StringBuffer();
                        buf.append(ret);
                        buf.append("/");
                        ret = buf.toString();
                        buf = null;
                        break;
                    }
                }
                ++i;
            }
        }
        return ret;
    }

    private final void doMode(boolean mode) throws AccessException {
        if (mode) {
            this.execCmd("TYPE A ");
            this.checkTelegram();
        } else {
            this.execCmd("TYPE I ");
            this.checkTelegram();
        }
    }

    private final void doCd(String name) throws AccessException {
        StringBuffer buf = null;
        if (name != null) {
            buf = new StringBuffer();
            buf.append("CWD ");
            buf.append(name);
            this.execCmd(buf.toString());
            buf = null;
            this.checkTelegram();
        }
    }

    private final void doMkDir(String name) throws AccessException {
        StringBuffer buf = null;
        if (name != null) {
            buf = new StringBuffer();
            buf.append("MKD ");
            buf.append(name);
            this.execCmd(buf.toString());
            buf = null;
            this.checkTelegram();
        }
    }

    private final void doRmDir(String name) throws AccessException {
        StringBuffer buf = null;
        if (name != null) {
            buf = new StringBuffer();
            buf.append("RMD ");
            buf.append(name);
            this.execCmd(buf.toString());
            buf = null;
            this.checkTelegram();
        }
    }

    private final void doDel(String name) throws AccessException {
        StringBuffer buf = null;
        if (name != null) {
            buf = new StringBuffer();
            buf.append("DELE ");
            buf.append(name);
            this.execCmd(buf.toString());
            buf = null;
            this.checkTelegram();
        }
    }

    private final void doRename(String src, String dest) throws AccessException {
        StringBuffer buf = null;
        if (src != null && dest != null) {
            buf = new StringBuffer();
            buf.append("RNFR ");
            buf.append(src);
            this.execCmd(buf.toString());
            buf = null;
            this.checkTelegram();
            buf = new StringBuffer();
            buf.append("RNTO ");
            buf.append(dest);
            this.execCmd(buf.toString());
            buf = null;
        }
    }

    private final long doDateTime(String name) throws AccessException {
        long ret;
        String tmp = null;
        DateTimeFormat dt = null;
        StringBuffer buf = null;
        if (name != null) {
            buf = new StringBuffer();
            buf.append("MDTM ");
            buf.append(name);
            tmp = this.execCmd(buf.toString());
            buf = null;
            if (tmp == null) {
                throw new AccessException("[MDTM]\u30b3\u30de\u30f3\u30c9\u306e\u5b9f\u65bd\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
            this.checkTelegram();
            dt = this.m_format;
            try {
                dt.set(tmp);
                ret = dt.getTime();
            }
            catch (Exception t) {
                throw new AccessException(t);
            }
        } else {
            ret = 0L;
        }
        return ret;
    }

    private final long doFileSize(String name) throws AccessException {
        long ret;
        String tmp = null;
        StringBuffer buf = null;
        if (name != null) {
            buf = new StringBuffer();
            buf.append("SIZE ");
            buf.append(name);
            tmp = this.execCmd(buf.toString());
            buf = null;
            if (tmp == null) {
                throw new AccessException("[SIZE]\u30b3\u30de\u30f3\u30c9\u306e\u5b9f\u65bd\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
            this.checkTelegram();
            try {
                ret = Long.parseLong(tmp);
            }
            catch (Exception t) {
                throw new AccessException(t);
            }
        } else {
            ret = -1L;
        }
        return ret;
    }

    private final void doOwner(String name, int own) throws AccessException {
        StringBuffer buf = null;
        if (name != null && own > 0) {
            buf = new StringBuffer();
            buf.append("SITE CHMOD ");
            buf.append(Integer.toHexString(own));
            buf.append(" ");
            buf.append(name);
            this.execCmd(buf.toString());
            buf = null;
            this.checkTelegram();
        }
    }

    /*
     * Exception decompiling
     */
    private final ArrayList doLs(String cmd) throws AccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [4 : 291->294)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final boolean doGet(OutputStream out, String name) throws InputException, AccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [4 : 305->308)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final boolean doPut(InputStream input, String name) throws InputException, AccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [4 : 326->329)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final Socket defCommand(String cmd, int timeout) throws InputException, AccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 273->276)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final Socket pasvCommand(String cmd, int timeout) throws InputException, AccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [5 : 475->478)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final String execCmd(String cmd) throws AccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [8 : 201->204)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final String execReturn() throws AccessException {
        String ret = null;
        try {
            UtilCom.cpuCreate();
            int rCd = this.getReceiveCode();
            if (rCd != -1) {
                ret = (String)this.m_tmp.remove(0);
                if (FTPDef.getErrorLevel(rCd) >= 2) {
                    throw new AccessException("ERROR : CD:" + rCd + " MSG:" + ret);
                }
            } else {
                ret = null;
            }
        }
        catch (AccessException ac) {
            throw ac;
        }
        catch (Exception t) {
            throw new AccessException(t);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String waitReturn() throws AccessException {
        String ret = null;
        try {
            int len;
            Object object = this.m_readSync.get();
            synchronized (object) {
                len = this.m_readBuf.size();
            }
            int i = 0;
            while (i < 499) {
                UtilCom.cpuCreate();
                object = this.m_readSync.get();
                synchronized (object) {
                    if (len < this.m_readBuf.size()) {
                        break;
                    }
                }
                ++i;
            }
            UtilCom.cpuCreate();
            int rCd = this.getReceiveCode();
            if (rCd != -1) {
                ret = (String)this.m_tmp.remove(0);
                if (FTPDef.getErrorLevel(rCd) >= 2) {
                    throw new AccessException("ERROR : CD:" + rCd + " MSG:" + ret);
                }
            } else {
                ret = null;
            }
        }
        catch (AccessException ac) {
            throw ac;
        }
        catch (Exception t) {
            throw new AccessException(t);
        }
        return ret;
    }

    private final void checkTelegram() throws AccessException {
        AccessException out = null;
        while (true) {
            try {
                if (this.execReturn() != null) continue;
            }
            catch (AccessException ac) {
                out = ac;
                continue;
            }
            break;
        }
        if (out != null) {
            throw out;
        }
    }

    /*
     * Exception decompiling
     */
    private final int getReceiveCode() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 181->184)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ArrayList recvTelegram(InputStream in, String charset) {
        block16: {
            block15: {
                ret = null;
                bufAry = null;
                try {
                    try {
                        block14: {
                            bufAry = new ByteArrayOutputStream();
                            if (this.ioTelegram(in, bufAry) <= 0L) break block14;
                            ret = charset == null ? UtilCom.pauseEnter(new String(bufAry.toByteArray())) : UtilCom.pauseEnter(new String(bufAry.toByteArray(), charset));
                            ** GOTO lbl-1000
                        }
                        ret = null;
                    }
                    catch (Exception t) {
                        if (ret != null) {
                            ret.clear();
                        }
                        ret = null;
                    }
                }
                catch (Throwable var7_6) {
                    var6_7 = null;
                    try {
                        in.close();
                    }
                    catch (Exception var8_9) {
                        // empty catch block
                    }
                    try {
                        bufAry.close();
                    }
                    catch (Exception var8_9) {
                        // empty catch block
                    }
                    bufAry = null;
                    throw var7_6;
                }
lbl-1000:
                // 3 sources

                {
                    var6_8 = null;
                }
                ** try [egrp 2[TRYBLOCK] [3 : 99->106)] { 
lbl36:
                // 1 sources

                in.close();
                break block15;
lbl38:
                // 1 sources

                catch (Exception var8_10) {
                    // empty catch block
                }
            }
            ** try [egrp 3[TRYBLOCK] [4 : 108->116)] { 
lbl42:
            // 1 sources

            bufAry.close();
            break block16;
lbl44:
            // 1 sources

            catch (Exception var8_10) {
                // empty catch block
            }
        }
        bufAry = null;
        return ret;
    }

    /*
     * Exception decompiling
     */
    private final long ioTelegram(InputStream in, OutputStream out) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [2 : 108->111)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final void getList(String cmd) throws AccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 507->511)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final String changeDirectory(String change) throws AccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 325->328)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void beforeDirectory() throws AccessException {
        if (this.m_beforeDir != null) {
            this.doCd(this.m_beforeDir);
            this.getList(null);
            this.m_beforeDir = null;
        }
    }

    /*
     * Exception decompiling
     */
    private final String getLastName(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 73->76)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private final String[] getNowList(boolean mode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 180->183)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void outDebug(boolean mode, String cmd) {
        if (this.m_isDebug) {
            StringBuffer buf = null;
            buf = new StringBuffer();
            buf.append(FTPClient.getNowDate());
            if (mode) {
                buf.append(" FTP-OUT(");
            } else {
                buf.append(" FTP-IN (");
            }
            buf.append(this.m_socket.getInetAddress());
            buf.append(":");
            buf.append(this.m_socket.getPort());
            buf.append(") [");
            buf.append(cmd);
            buf.append("] ");
            this.m_debugWriter.println(buf.toString());
            Object var3_3 = null;
        }
    }

    private static final String getNowDate() {
        String[] days = null;
        StringBuffer buf = null;
        String ret = null;
        int len = 9;
        days = new String[len];
        UtilCom.getNowTimestampByString(days);
        buf = new StringBuffer();
        buf.append(days[0]);
        buf.append("/");
        buf.append("00".substring(days[1].length()));
        buf.append(days[1]);
        buf.append("/");
        buf.append("00".substring(days[2].length()));
        buf.append(days[2]);
        buf.append(" ");
        buf.append("00".substring(days[3].length()));
        buf.append(days[3]);
        buf.append(":");
        buf.append("00".substring(days[4].length()));
        buf.append(days[4]);
        buf.append(":");
        buf.append("00".substring(days[5].length()));
        buf.append(days[5]);
        buf.append(".");
        buf.append("000".substring(days[6].length()));
        buf.append(days[6]);
        ret = buf.toString();
        int i = 0;
        while (i < len) {
            days[i] = null;
            ++i;
        }
        days = null;
        buf = null;
        return ret;
    }
}

