/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.net.mgc;

import com.JRcServer.commons.exception.ExecutionException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.net.BaseMultiCast;
import com.JRcServer.commons.net.ConnectAddress;
import com.JRcServer.commons.net.ConnectTimeoutException;
import com.JRcServer.commons.net.mgc.MgcCommon;
import com.JRcServer.commons.net.mgc.MgcTable;
import com.JRcServer.commons.thread.ExecutionThread;
import com.JRcServer.commons.thread.LoopThread;
import com.JRcServer.commons.thread.Synchronized;
import com.JRcServer.commons.util.UtilCom;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class MgcCLRcvThread
extends ExecutionThread {
    private static final Log LOG;
    private static final int DEF_RCVTIME = 250;
    private static final int MAX_SEND = 3;
    private BaseMultiCast m_mcast = null;
    private ConnectAddress m_addr = null;
    private MgcTable m_clTable = null;
    private final LoopThread m_thread = new LoopThread();
    private final Synchronized m_sync = new Synchronized();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.JRcServer.commons.net.mgc.MgcCLRcvThread");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    private MgcCLRcvThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MgcCLRcvThread(BaseMultiCast mcast, MgcTable clTbl) throws InputException {
        if (mcast == null || !mcast.isOpen() || !mcast.isGroup() || clTbl == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.m_sync.create();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_mcast = mcast;
                this.m_clTable = clTbl;
                this.m_addr = new ConnectAddress();
                this.m_thread.create(this);
                this.m_thread.startThread();
            }
        }
        catch (Exception e) {
            this.destroy();
            throw new InputException(e);
        }
    }

    protected final void finalize() throws Exception {
        try {
            this.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_thread.clear();
                this.m_mcast = null;
                this.m_clTable = null;
                this.m_addr = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_sync.clear();
        this.m_mcast = null;
        this.m_clTable = null;
        this.m_addr = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isUse() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_thread.isThread();
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected final void init(Object obj) throws ExecutionException {
    }

    protected final void exit(Object obj) throws ExecutionException {
    }

    protected final void stop(Object obj) throws ExecutionException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void execution(Object obj) throws ExecutionException {
        BaseMultiCast mcast = null;
        MgcTable clTbl = null;
        ConnectAddress addr = null;
        byte[] rcv = null;
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    mcast = this.m_mcast;
                    clTbl = this.m_clTable;
                    addr = this.m_addr;
                }
                try {
                    rcv = mcast.receive(addr, 250);
                }
                catch (ConnectTimeoutException ct) {
                    rcv = null;
                }
                if (rcv != null) {
                    if (MgcCommon.isMgcServer(rcv)) {
                        clTbl.set(rcv);
                    }
                    rcv = null;
                } else {
                    UtilCom.idleTime();
                }
            }
            catch (NullPointerException nul) {
                throw new ExecutionException(nul, 254);
            }
            catch (ExecutionException ee) {
                throw ee;
            }
            catch (InputException in) {
                LOG.error((Object)"\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", (Throwable)in);
            }
            catch (Exception exception) {
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            mcast = null;
            clTbl = null;
            addr = null;
            rcv = null;
            throw throwable;
        }
        {
            Object var11_14 = null;
            mcast = null;
            clTbl = null;
            addr = null;
        }
        rcv = null;
    }
}

