/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.net.mgc;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.net.BaseMultiCast;
import com.JRcServer.commons.net.MultiCastV4;
import com.JRcServer.commons.net.mgc.MgcCLRcvThread;
import com.JRcServer.commons.net.mgc.MgcCLThread;
import com.JRcServer.commons.net.mgc.MgcCommon;
import com.JRcServer.commons.net.mgc.MgcManager;
import com.JRcServer.commons.net.mgc.MgcManagerImple;
import com.JRcServer.commons.net.mgc.MgcTable;
import com.JRcServer.commons.thread.Synchronized;

public class MgcClient {
    private BaseMultiCast m_mcast = null;
    private int m_groupID = -1;
    private final MgcManagerImple m_man = new MgcManagerImple();
    private MgcCLRcvThread m_rcvThread = null;
    private MgcCLThread m_thread = null;
    private final MgcTable m_connTable = new MgcTable();
    private final Synchronized m_sync = new Synchronized();

    public MgcClient() {
        this.m_sync.clear();
    }

    protected final void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void open(BaseMultiCast mcast, int id) throws InputException {
        this.open(mcast, id, null, -1);
    }

    public final void open(BaseMultiCast mcast, int id, int time) throws InputException {
        this.open(mcast, id, null, time);
    }

    public final void open(BaseMultiCast mcast, int id, byte[] table) throws InputException {
        this.open(mcast, id, table, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void open(BaseMultiCast mcast, int id, byte[] table, int time) throws InputException {
        if (mcast == null || !mcast.isOpen() || id < 0 || id > 0xEFFFFFF || table != null && table.length != 256) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.close();
        this.m_sync.create();
        try {
            this.m_groupID = id;
            ((MultiCastV4)mcast).joinGroup(this.m_groupID);
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_mcast = mcast;
                this.m_thread = new MgcCLThread(id, this.m_man, this.m_connTable, table, time);
                this.m_rcvThread = new MgcCLRcvThread(mcast, this.m_connTable);
            }
        }
        catch (InputException in) {
            this.close();
            throw in;
        }
        catch (Exception e) {
            this.close();
            throw new InputException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                try {
                    this.m_rcvThread.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.m_thread.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.m_mcast.leaveGroup();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_man.clear();
                this.m_connTable.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_sync.clear();
        this.m_mcast = null;
        this.m_groupID = -1;
        this.m_rcvThread = null;
        this.m_thread = null;
    }

    public final void sendNotice() {
        this.sendNotice(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void sendNotice(int cnt) {
        byte[] snd = null;
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    snd = MgcCommon.createMgcClient(cnt);
                    this.m_mcast.send(snd);
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            snd = null;
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        snd = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getGroupID() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_groupID;
            }
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MgcManager getManager() {
        MgcManagerImple ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_man;
            }
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] getCodeTable() {
        byte[] ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_thread.getCodeTable();
            }
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getCheckConnectTime() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_thread.getCheckConnectTime();
            }
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isOpen() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_thread.isUse() && this.m_rcvThread.isUse();
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }
}

