/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.net.mgc;

import com.JRcServer.commons.conv.ScIO;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.net.NetDef;
import com.JRcServer.commons.net.mgc.MgcServerValue;
import com.JRcServer.commons.net.mgc.MgcValue;
import com.JRcServer.commons.util.ConvertParam;
import com.JRcServer.commons.util.UtilCom;
import java.net.InetAddress;

class MgcCommon {
    public static final int SEND_MGC_SERVER_END_COUNT = 3;
    public static final int HEADER_TYPE_DEFAULT = 0;
    public static final int HEADER_TYPE_RETURN = 1;
    public static final int HEADER_TYPE_END = 2;
    public static final int MAX_RAND_CODE = 256;
    private static final String DEF_CHARSET = "UTF8";
    private static final int MIN_MGCCL_RETCNT = 0;
    private static final int MAX_MGCCL_RETCNT = 3;
    private static final int MGC_HEADER_LENGTH = 6;
    private static final byte[] MGC_COMMON_HEADER = new byte[]{109, 103, 99, 64};
    private static final byte[] MGC_SERVER_CH_HEADER = new byte[]{109, 103, 99, 64, 83};
    private static final byte[] MGC_SERVER_HEADER = new byte[]{109, 103, 99, 64, 83, 86};
    private static final byte[] MGC_SERVER_RET_HEADER = new byte[]{109, 103, 99, 64, 83, 82};
    private static final byte[] MGC_SERVER_END_HEADER = new byte[]{109, 103, 99, 64, 83, 69};
    private static final byte[] MGC_CLIENT_HEADER = new byte[]{109, 103, 99, 64, 67, 76};

    MgcCommon() {
    }

    public static final byte[] createMgcServer(MgcValue value, byte[] table) throws InputException {
        return MgcCommon.createMgcServer(0, value, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final byte[] createMgcServer(int mode, MgcValue value, byte[] table) throws InputException {
        serverName = null;
        addr = null;
        nameBin = null;
        addrBin = null;
        ret = null;
        if (value == null) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        if (value.isUse() == false) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        if (table != null && table.length != 256) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        rndCd = UtilCom.random(256);
        try {
            try {
                var19_9 = value;
                synchronized (var19_9) {
                    serverName = value.getServerName();
                    serverID = value.getServerID();
                    protocolType = value.getProtocolType();
                    addr = value.getBindAddress();
                    port = value.getBindPort();
                    count = value.getConnectCount();
                }
                nameBin = serverName.getBytes("UTF8");
                serverName = null;
                addrBin = addr.getAddress();
                addr = null;
                nameLen = nameBin.length;
                if (nameLen <= 0 || (addrLen = addrBin.length) <= 0) ** GOTO lbl-1000
                len = 6;
                ret = new byte[len + 1 + 4 + 2 + nameLen + 1 + 2 + addrLen + 2 + 4 + 8];
                if (mode == 0) {
                    i = 0;
                    while (i < len) {
                        ret[i] = MgcCommon.MGC_SERVER_HEADER[i];
                        ++i;
                    }
                } else if (mode == 1) {
                    i = 0;
                    while (i < len) {
                        ret[i] = MgcCommon.MGC_SERVER_RET_HEADER[i];
                        ++i;
                    }
                } else if (mode == 2) {
                    i = 0;
                    while (i < len) {
                        ret[i] = MgcCommon.MGC_SERVER_END_HEADER[i];
                        ++i;
                    }
                }
                pnt = len;
                ret[pnt] = (byte)rndCd;
                off = ++pnt;
                ConvertParam.convertInt(ret, pnt, serverID);
                ConvertParam.convertShort(ret, pnt += 4, (short)nameLen);
                System.arraycopy(nameBin, 0, ret, pnt += 2, nameLen);
                ret[pnt += nameLen] = (byte)(protocolType & 255);
                ConvertParam.convertShort(ret, ++pnt, (short)addrLen);
                System.arraycopy(addrBin, 0, ret, pnt += 2, addrLen);
                ConvertParam.convertShort(ret, pnt += addrLen, (short)port);
                ConvertParam.convertInt(ret, pnt += 2, count);
                ConvertParam.convertLong(ret, pnt += 4, System.currentTimeMillis());
                if (table != null) {
                    ScIO.input(ret, serverID, table, rndCd, off, ret.length - off);
                } else {
                    ScIO.input(ret, serverID, rndCd, off, ret.length - off);
                }
            }
            catch (Exception e) {
                ret = null;
                throw new InputException(e);
            }
        }
        catch (Throwable var21_23) {
            var20_24 = null;
            serverName = null;
            addr = null;
            nameBin = null;
            addrBin = null;
            throw var21_23;
        }
lbl-1000:
        // 3 sources

        {
            var20_25 = null;
            serverName = null;
            addr = null;
        }
        nameBin = null;
        addrBin = null;
        return ret;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void getMgcServer(MgcServerValue out, byte[] bin, byte[] table, int thisServerID) throws InputException {
        String name = null;
        InetAddress addr = null;
        byte[] tmp = null;
        if (out == null) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        if (bin == null) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        if (bin.length <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            try {
                int pnt = MGC_SERVER_HEADER.length;
                int rndCd = bin[pnt] & 0xFF;
                int off = ++pnt;
                if (table != null) {
                    ScIO.output(bin, thisServerID, table, rndCd, off, bin.length - off);
                } else {
                    ScIO.output(bin, thisServerID, rndCd, off, bin.length - off);
                }
                int id = ConvertParam.convertInt(pnt, bin);
                pnt += 4;
                if (id != thisServerID) {
                    throw new InputException("\u53d7\u4fe1\u3055\u308c\u305f\u30b5\u30fc\u30d0ID(" + id + ")\u306f\u3053\u306e\u30de\u30b7\u30f3\u306e\u30b5\u30fc\u30d0ID(" + thisServerID + ")\u3068\u4e00\u81f4\u3057\u306a\u3044\u305f\u3081\u3001\u4e0d\u6b63\u306a\u96fb\u6587\u3067\u3059");
                }
                short len = ConvertParam.convertShort(pnt, bin);
                pnt += 2;
                if (len <= 0) {
                    throw new InputException("\u30b5\u30fc\u30d0\u96fb\u6587:\u30b5\u30fc\u30d0\u540d\u9577(" + len + ")\u304c\u4e0d\u6b63\u3067\u3059");
                }
                tmp = new byte[len];
                System.arraycopy(bin, pnt, tmp, 0, len);
                name = new String(tmp, DEF_CHARSET);
                tmp = null;
                int protocolType = bin[pnt += len] & 0xFF;
                ++pnt;
                if (protocolType != 1 && protocolType != 2 && protocolType != 3) {
                    throw new InputException("\u30b5\u30fc\u30d0\u96fb\u6587:\u30d7\u30ed\u30c8\u30b3\u30eb\u30bf\u30a4\u30d7(" + protocolType + ")\u304c\u4e0d\u6b63\u3067\u3059");
                }
                len = ConvertParam.convertShort(pnt, bin);
                pnt += 2;
                if (len <= 0) {
                    throw new InputException("\u30b5\u30fc\u30d0\u96fb\u6587:\u30a2\u30c9\u30ec\u30b9\u9577(" + len + ")\u304c\u4e0d\u6b63\u3067\u3059");
                }
                tmp = new byte[len];
                System.arraycopy(bin, pnt, tmp, 0, len);
                addr = NetDef.getByAddress(tmp);
                tmp = null;
                short port = ConvertParam.convertShort(pnt += len, bin);
                int connCnt = ConvertParam.convertInt(pnt += 2, bin);
                long time = ConvertParam.convertLong(pnt += 4, bin);
                out.create(name, id, protocolType, addr, (int)port, connCnt, time);
            }
            catch (InputException in) {
                if (out == null) throw in;
                out.clear();
                throw in;
            }
            catch (Exception e) {
                if (out == null) throw new InputException(e);
                out.clear();
                throw new InputException(e);
            }
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            name = null;
            addr = null;
            tmp = null;
            throw throwable;
        }
        {
            Object var18_20 = null;
            name = null;
            addr = null;
        }
        tmp = null;
    }

    public static final long getMgcServerByTime(byte[] bin) {
        long ret;
        int len;
        if (bin == null || (len = bin.length) <= 0) {
            return -1L;
        }
        try {
            ret = ConvertParam.convertLong(len - 8, bin);
        }
        catch (Exception e) {
            ret = -1L;
        }
        return ret;
    }

    public static final byte[] createMgcClient(int retCnt) throws InputException {
        byte[] ret = null;
        retCnt = retCnt < 0 ? 0 : retCnt;
        retCnt = retCnt > 3 ? 3 : retCnt;
        try {
            int len = MGC_CLIENT_HEADER.length;
            ret = new byte[len + 1];
            int i = 0;
            while (i < len) {
                ret[i] = MGC_CLIENT_HEADER[i];
                ++i;
            }
            ret[len] = (byte)(retCnt & 0xFF);
        }
        catch (Exception e) {
            ret = null;
            throw new InputException(e);
        }
        return ret;
    }

    public static final int getMgcClient(byte[] bin) throws InputException {
        int ret;
        if (bin == null || bin.length < 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            ret = bin[MGC_CLIENT_HEADER.length] & 0xFF;
        }
        catch (Exception e) {
            throw new InputException(e);
        }
        return ret;
    }

    public static final boolean isMgc(byte[] bin) {
        boolean ret;
        if (bin == null || bin.length <= 0) {
            return false;
        }
        try {
            int len = MGC_COMMON_HEADER.length;
            int i = 0;
            ret = true;
            while (i < len) {
                if (bin[i] != MGC_COMMON_HEADER[i]) {
                    ret = false;
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public static final boolean isMgcServer(byte[] bin) {
        boolean ret;
        if (bin == null || bin.length <= 0) {
            return false;
        }
        try {
            int len = MGC_SERVER_CH_HEADER.length;
            int i = 0;
            ret = true;
            while (i < len) {
                if (bin[i] != MGC_SERVER_CH_HEADER[i]) {
                    ret = false;
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public static final boolean isMgcServerReturn(byte[] bin) {
        boolean ret;
        if (bin == null || bin.length <= 0) {
            return false;
        }
        try {
            int len = MGC_SERVER_RET_HEADER.length;
            int i = 0;
            ret = true;
            while (i < len) {
                if (bin[i] != MGC_SERVER_RET_HEADER[i]) {
                    ret = false;
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public static final boolean isMgcServerEnd(byte[] bin) {
        boolean ret;
        if (bin == null || bin.length <= 0) {
            return false;
        }
        try {
            int len = MGC_SERVER_END_HEADER.length;
            int i = 0;
            ret = true;
            while (i < len) {
                if (bin[i] != MGC_SERVER_END_HEADER[i]) {
                    ret = false;
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public static final boolean isMgcClient(byte[] bin) {
        boolean ret;
        if (bin == null || bin.length <= 0) {
            return false;
        }
        try {
            int len = MGC_CLIENT_HEADER.length;
            int i = 0;
            ret = true;
            while (i < len) {
                if (bin[i] != MGC_CLIENT_HEADER[i]) {
                    ret = false;
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }
}

