/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.net.mgc;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.net.ConnectAddress;
import com.JRcServer.commons.serialize.SerializeUtil;
import java.io.Serializable;
import java.net.InetAddress;

class MgcServerValue
implements Serializable {
    private static final long serialVersionUID;
    private String m_serverName = null;
    private int m_serverID = -1;
    private int m_protocolType = -1;
    private InetAddress m_addr = null;
    private int m_port = -1;
    private int m_nowConnectCnt = -1;
    private long m_serverTime = -1L;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.JRcServer.commons.net.mgc.MgcServerValue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        serialVersionUID = SerializeUtil.serialVersionUID(clazz.getName());
    }

    public MgcServerValue() {
    }

    public MgcServerValue(String name, int id, int ptype, InetAddress addr, int port, int connCnt, long time) throws InputException {
        try {
            this.create(name, id, ptype, addr.getHostAddress(), port, connCnt, time);
        }
        catch (Exception e) {
            throw new InputException(e);
        }
    }

    public MgcServerValue(String name, int id, int ptype, String addr, int port, int connCnt, long time) throws InputException {
        this.create(name, id, ptype, addr, port, connCnt, time);
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void create(String name, int id, int ptype, InetAddress addr, int port, int connCnt, long time) throws InputException {
        try {
            this.create(name, id, ptype, addr.getHostAddress(), port, connCnt, time);
        }
        catch (Exception e) {
            throw new InputException(e);
        }
    }

    public final void create(String name, int id, int ptype, String addr, int port, int connCnt, long time) throws InputException {
        if (name == null || name.length() <= 0 || id < 0 || port <= 0 || port >= 65535 || ptype != 1 && ptype != 2 && ptype != 3) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.m_serverName = name;
            this.m_serverID = id;
            this.m_protocolType = ptype;
            this.m_addr = InetAddress.getByName(addr);
            this.m_port = port;
            this.m_nowConnectCnt = connCnt;
            this.m_serverTime = time;
        }
        catch (Exception e) {
            this.clear();
            throw new InputException(e);
        }
    }

    public final void clear() {
        this.m_serverName = null;
        this.m_serverID = -1;
        this.m_protocolType = -1;
        this.m_addr = null;
        this.m_port = -1;
        this.m_nowConnectCnt = -1;
        this.m_serverTime = -1L;
    }

    public final String getServerName() {
        return this.m_serverName;
    }

    public final int getServerID() {
        return this.m_serverID;
    }

    public final int getProtocolType() {
        return this.m_protocolType;
    }

    public final InetAddress getBindAddress() {
        return this.m_addr;
    }

    public final int getBindPort() {
        return this.m_port;
    }

    public final boolean getBind(ConnectAddress out) {
        boolean ret = false;
        if (out != null) {
            try {
                if (this.m_serverName != null) {
                    out.create(this.m_addr, this.m_port);
                    ret = true;
                } else {
                    out.clear();
                }
            }
            catch (Exception e) {
                out.clear();
                ret = false;
            }
        }
        return ret;
    }

    public final int getConnectCount() {
        return this.m_nowConnectCnt;
    }

    public final long getTime() {
        return this.m_serverTime;
    }

    public final boolean isUse() {
        return this.m_serverName != null;
    }
}

