/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.net.mgc;

import com.JRcServer.commons.exception.ExecutionException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.net.BaseMultiCast;
import com.JRcServer.commons.net.ConnectAddress;
import com.JRcServer.commons.net.ConnectTimeoutException;
import com.JRcServer.commons.net.mgc.MgcCommon;
import com.JRcServer.commons.net.mgc.MgcTable;
import com.JRcServer.commons.net.mgc.MgcValueImple;
import com.JRcServer.commons.thread.ExecutionThread;
import com.JRcServer.commons.thread.LoopThread;
import com.JRcServer.commons.thread.Synchronized;
import com.JRcServer.commons.util.UtilCom;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class MgcSvRcvThread
extends ExecutionThread {
    private static final Log LOG;
    private static final int DEF_RESEND = 150000;
    private static final int MIN_RESEND = 30000;
    private static final int DEF_RCVTIME = 250;
    private static final int MAX_SEND = 3;
    private MgcValueImple m_thisValue = null;
    private BaseMultiCast m_mcast = null;
    private MgcTable m_svTable = null;
    private int m_resend = -1;
    private byte[] m_codeTable = null;
    private ConnectAddress m_addr = null;
    private long m_befTime = 0L;
    private InetAddress m_bindAddr = null;
    private final LoopThread m_thread = new LoopThread();
    private final Synchronized m_sync = new Synchronized();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.JRcServer.commons.net.mgc.MgcSvRcvThread");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    private MgcSvRcvThread() {
    }

    public MgcSvRcvThread(MgcValueImple thisValue, BaseMultiCast mcast, MgcTable sv, byte[] table) throws InputException {
        this(thisValue, mcast, sv, table, 150000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MgcSvRcvThread(MgcValueImple thisValue, BaseMultiCast mcast, MgcTable sv, byte[] table, int resend) throws InputException {
        if (!(thisValue != null && thisValue.isUse() && mcast != null && mcast.isOpen() && mcast.isGroup() && sv != null)) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        resend = resend <= 30000 ? 30000 : resend;
        table = table == null || table.length != 256 ? null : table;
        this.m_sync.create();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_thisValue = thisValue;
                this.m_mcast = mcast;
                this.m_svTable = sv;
                this.m_codeTable = table;
                this.m_resend = resend;
                this.m_befTime = 0L;
                this.m_addr = new ConnectAddress();
                this.m_bindAddr = mcast.getInterface();
                if (this.m_bindAddr == null || this.m_bindAddr.getHostAddress().equals("0.0.0.0") || this.m_bindAddr.getHostAddress().equals("127.0.0.1")) {
                    this.m_bindAddr = InetAddress.getLocalHost();
                }
                this.m_thread.create(this);
                this.m_thread.startThread();
            }
        }
        catch (Exception e) {
            this.destroy();
            throw new InputException(e);
        }
    }

    protected final void finalize() throws Exception {
        try {
            this.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_thread.clear();
                this.m_thisValue = null;
                this.m_mcast = null;
                this.m_svTable = null;
                this.m_befTime = 0L;
                this.m_addr = null;
                this.m_bindAddr = null;
                this.m_codeTable = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_sync.clear();
        this.m_thisValue = null;
        this.m_mcast = null;
        this.m_svTable = null;
        this.m_befTime = 0L;
        this.m_addr = null;
        this.m_bindAddr = null;
        this.m_codeTable = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendMgcServerEnd(int count) {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.send(false, count, 2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isUse() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_thread.isThread();
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    protected final void init(Object obj) throws ExecutionException {
    }

    protected final void exit(Object obj) throws ExecutionException {
    }

    protected final void stop(Object obj) throws ExecutionException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void execution(Object obj) throws ExecutionException {
        MgcValueImple thisValue = null;
        BaseMultiCast mcast = null;
        MgcTable svTable = null;
        ConnectAddress addr = null;
        InetAddress bindAddr = null;
        byte[] rcv = null;
        try {
            block21: {
                try {
                    long befTime;
                    Object object = this.m_sync.get();
                    synchronized (object) {
                        thisValue = this.m_thisValue;
                        mcast = this.m_mcast;
                        svTable = this.m_svTable;
                        befTime = (long)this.m_resend + this.m_befTime;
                        addr = this.m_addr;
                        bindAddr = this.m_bindAddr;
                    }
                    try {
                        rcv = mcast.receive(addr, 250);
                    }
                    catch (ConnectTimeoutException ct) {
                        rcv = null;
                    }
                    if (rcv != null) {
                        if (MgcCommon.isMgcClient(rcv)) {
                            int cnt = MgcCommon.getMgcClient(rcv);
                            if (cnt > 0) {
                                this.send(true, cnt, 0);
                            }
                        } else if (!bindAddr.equals(addr.getAddress()) && MgcCommon.isMgcServer(rcv)) {
                            if (MgcCommon.isMgcServerReturn(rcv)) {
                                this.send(false, 1, 0);
                            }
                            svTable.set(rcv);
                        }
                        rcv = null;
                        break block21;
                    }
                    if (befTime <= System.currentTimeMillis()) {
                        this.send(true, 1, 1);
                    } else {
                        UtilCom.idleTime();
                    }
                }
                catch (NullPointerException nul) {
                    throw new ExecutionException(nul, 254);
                }
                catch (ExecutionException ee) {
                    throw ee;
                }
                catch (InputException in) {
                    LOG.error((Object)"\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", (Throwable)in);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Object var13_18 = null;
            thisValue = null;
            mcast = null;
            svTable = null;
            addr = null;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            thisValue = null;
            mcast = null;
            svTable = null;
            addr = null;
            rcv = null;
            throw throwable;
        }
        rcv = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void send(boolean update, int cnt, int mode) {
        BaseMultiCast mcast = null;
        MgcValueImple val = null;
        byte[] table = null;
        byte[] bin = null;
        cnt = cnt <= 0 ? 1 : cnt;
        cnt = cnt >= 3 ? 3 : cnt;
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    mcast = this.m_mcast;
                    val = this.m_thisValue;
                    table = this.m_codeTable;
                }
                object = val;
                synchronized (object) {
                    bin = MgcCommon.createMgcServer(mode, val, table);
                }
                int i = 0;
                while (true) {
                    block15: {
                        if (i < cnt) break block15;
                        if (!update) break;
                        object = this.m_sync.get();
                        synchronized (object) {
                            this.m_befTime = System.currentTimeMillis();
                            break;
                        }
                    }
                    mcast.send(bin);
                    ++i;
                }
            }
            catch (Exception e) {
                LOG.error((Object)"\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            mcast = null;
            val = null;
            table = null;
            bin = null;
            throw throwable;
        }
        {
            Object var10_13 = null;
            mcast = null;
            val = null;
        }
        table = null;
        bin = null;
    }
}

