/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.net.mgc;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.net.ConnectAddress;
import com.JRcServer.commons.net.mgc.MgcValue;
import com.JRcServer.commons.net.mgc.MgcWriteValue;
import com.JRcServer.commons.serialize.SerializeUtil;
import java.net.InetAddress;

class MgcValueImple
implements MgcValue,
MgcWriteValue {
    private static final long serialVersionUID;
    private String m_serverName = null;
    private int m_serverID = -1;
    private int m_protocolType = -1;
    private InetAddress m_addr = null;
    private int m_port = -1;
    private int m_nowConnectCnt = -1;
    private long m_defTime = 0L;
    private transient int m_beforeResponse = Integer.MIN_VALUE;
    private transient long m_updateTime = Long.MIN_VALUE;
    private int m_noResponseCount = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.JRcServer.commons.net.mgc.MgcValueImple");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        serialVersionUID = SerializeUtil.serialVersionUID(clazz.getName());
    }

    private MgcValueImple() {
    }

    protected MgcValueImple(String name, int id, int ptype, InetAddress addr, int port) throws InputException {
        if (name == null || name.length() <= 0 || id < 0 || port <= 0 || port >= 65535 || ptype != 1 && ptype != 2 && ptype != 3) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            addr = addr == null ? InetAddress.getLocalHost() : addr;
            this.m_serverName = name;
            this.m_serverID = id;
            this.m_protocolType = ptype;
            this.m_addr = addr;
            this.m_port = port;
            this.m_nowConnectCnt = 0;
            this.m_defTime = 0L;
            this.m_beforeResponse = 0;
            this.m_updateTime = System.currentTimeMillis();
            this.m_noResponseCount = 0;
        }
        catch (Exception e) {
            this.destroy();
            throw new InputException(e);
        }
    }

    protected final void finalize() throws Exception {
        try {
            this.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final void destroy() {
        this.m_serverName = null;
        this.m_serverID = -1;
        this.m_protocolType = -1;
        this.m_addr = null;
        this.m_port = -1;
        this.m_nowConnectCnt = -1;
        this.m_defTime = 0L;
        this.m_beforeResponse = Integer.MIN_VALUE;
        this.m_updateTime = Long.MIN_VALUE;
        this.m_noResponseCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void update() {
        MgcValueImple mgcValueImple = this;
        synchronized (mgcValueImple) {
            if (this.m_serverName != null) {
                this.m_updateTime = System.currentTimeMillis();
                this.m_noResponseCount = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setConnectCount(int cnt) {
        MgcValueImple mgcValueImple = this;
        synchronized (mgcValueImple) {
            if (this.m_serverName != null) {
                this.m_nowConnectCnt = cnt <= 0 ? 0 : cnt;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResponseTime(int time) {
        if (time >= 0) {
            MgcValueImple mgcValueImple = this;
            synchronized (mgcValueImple) {
                if (this.m_serverName != null) {
                    this.m_beforeResponse = time;
                    this.m_noResponseCount = 0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDefaultTime(long time) {
        if (time > 0L) {
            long tmp = System.currentTimeMillis() - time;
            MgcValueImple mgcValueImple = this;
            synchronized (mgcValueImple) {
                if (this.m_serverName != null) {
                    this.m_defTime = this.m_defTime <= tmp ? tmp : this.m_defTime;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addNoResponseCount() {
        MgcValueImple mgcValueImple = this;
        synchronized (mgcValueImple) {
            this.m_updateTime = System.currentTimeMillis();
            ++this.m_noResponseCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getServerName() {
        String ret = null;
        MgcValueImple mgcValueImple = this;
        synchronized (mgcValueImple) {
            ret = this.m_serverName;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getServerID() {
        int ret;
        MgcValueImple mgcValueImple = this;
        synchronized (mgcValueImple) {
            ret = this.m_serverID;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getProtocolType() {
        int ret;
        MgcValueImple mgcValueImple = this;
        synchronized (mgcValueImple) {
            ret = this.m_protocolType;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final InetAddress getBindAddress() {
        InetAddress ret = null;
        MgcValueImple mgcValueImple = this;
        synchronized (mgcValueImple) {
            ret = this.m_addr;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getBindPort() {
        int ret;
        MgcValueImple mgcValueImple = this;
        synchronized (mgcValueImple) {
            ret = this.m_port;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean getBind(ConnectAddress out) {
        boolean ret = false;
        if (out != null) {
            try {
                MgcValueImple mgcValueImple = this;
                synchronized (mgcValueImple) {
                    if (this.m_serverName != null) {
                        out.create(this.m_addr, this.m_port);
                        ret = true;
                    } else {
                        out.clear();
                    }
                }
            }
            catch (Exception e) {
                out.clear();
                ret = false;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getUpdateTime() {
        long ret;
        MgcValueImple mgcValueImple = this;
        synchronized (mgcValueImple) {
            ret = this.m_serverName != null ? this.m_updateTime : -1L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getConnectCount() {
        int ret;
        MgcValueImple mgcValueImple = this;
        synchronized (mgcValueImple) {
            ret = this.m_serverName != null ? this.m_nowConnectCnt : -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getDefaultTime() {
        long ret;
        MgcValueImple mgcValueImple = this;
        synchronized (mgcValueImple) {
            ret = this.m_serverName != null ? System.currentTimeMillis() - this.m_defTime : -1L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getBeforeResponse() {
        int ret;
        MgcValueImple mgcValueImple = this;
        synchronized (mgcValueImple) {
            ret = this.m_serverName != null ? this.m_beforeResponse : -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getNoResponseCount() {
        int ret;
        MgcValueImple mgcValueImple = this;
        synchronized (mgcValueImple) {
            ret = this.m_noResponseCount;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int compareTo(Object o) {
        int tbef;
        int tcnt;
        int cnt = ((MgcValueImple)o).getConnectCount();
        int bef = ((MgcValueImple)o).getBeforeResponse();
        MgcValueImple mgcValueImple = this;
        synchronized (mgcValueImple) {
            tcnt = this.m_nowConnectCnt;
            tbef = this.m_beforeResponse;
        }
        if (tcnt == cnt) {
            return tbef - bef;
        }
        return tcnt - cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isUse() {
        boolean ret;
        MgcValueImple mgcValueImple = this;
        synchronized (mgcValueImple) {
            ret = this.m_serverName != null;
        }
        return ret;
    }
}

