/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.net.uio;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.net.uio.UdpIODef;
import com.JRcServer.commons.resource.BinResource;
import com.JRcServer.commons.util.ByteUtil;
import com.JRcServer.commons.util.ConvertParam;
import com.JRcServer.commons.util.UtilCom;
import com.JRcServer.commons.util.array.IntArray;

class UdpIOCommon {
    private static final int RND_ID = 256;

    UdpIOCommon() {
    }

    public static final int getRandomID() {
        return UtilCom.random(256) & 0xFF | (UtilCom.random(256) & 0xFF) << 8 | (UtilCom.random(256) & 0xFF) << 16 | (UtilCom.random(256) & 0xFF) << 24;
    }

    public static final void createCommonData(ByteUtil out, int id, int subID, int randID) throws InputException {
        out.clear();
        out.add(UdpIODef.PACKET_HEADER);
        out.put(ConvertParam.convertInt(id));
        out.put(ConvertParam.convertInt(subID));
        out.put(ConvertParam.convertInt(randID));
    }

    public static final void createPacketHeader(ByteUtil out, int id, int max, int randID, int all, int packetLen, int code) throws InputException {
        UdpIOCommon.createCommonData(out, id, -1, randID);
        out.put(ConvertParam.convertInt(max));
        out.put(ConvertParam.convertInt(all));
        out.put(ConvertParam.convertInt(packetLen));
        out.put(ConvertParam.convertInt(code));
    }

    public static final void createTelegram(ByteUtil out, int id, int subID, int randID, int plen, BinResource data) throws InputException {
        byte[] packet = null;
        int dlen = data.size();
        int len = plen - 14;
        int pnt = len * subID;
        dlen = (dlen -= pnt) >= len ? len : dlen;
        UdpIOCommon.createCommonData(out, id, subID, randID);
        packet = data.getBinary(pnt, dlen);
        out.put(packet);
        packet = null;
    }

    public static final void createLostPacket(ByteUtil out, int id, int subID, int randID, int plen, IntArray subIDs) throws InputException {
        int sLen;
        if (subIDs == null || (sLen = subIDs.size()) <= 0 || plen <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int len = plen - 14;
        int one = (len - 2) / 4;
        int pnt = one * subID;
        if (sLen <= pnt) {
            throw new InputException("\u30b5\u30d6ID\u4f4d\u7f6e(" + pnt + ")\u304c\u3001\u6761\u4ef6(" + sLen + ")\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        UdpIOCommon.createCommonData(out, id, subID, randID);
        len = sLen - pnt;
        len = len >= one ? one : len;
        out.add(ConvertParam.convertShort((short)len));
        int i = 0;
        int j = pnt;
        while (i < len) {
            out.add(ConvertParam.convertInt(subIDs.get(j)));
            ++i;
            ++j;
        }
    }

    public static final int getMaxPacket(int packetLength, BinResource data) {
        int len = packetLength - 14;
        int bLen = data.size();
        int ret = bLen / len;
        return bLen % len != 0 ? ret + 1 : ret;
    }

    public static final int getMaxLostPacket(int packetLength, IntArray subIDs) {
        int sLen;
        if (subIDs == null || (sLen = subIDs.size()) <= 0 || packetLength <= 0) {
            return -1;
        }
        int len = packetLength - 14;
        int one = (len - 2) / 4;
        int ret = sLen / one;
        return ret += sLen % one != 0 ? 1 : 0;
    }

    public static final int getMaxLostTelegramLength(int packetLength, IntArray subIDs) {
        int sLen;
        if (subIDs == null || (sLen = subIDs.size()) <= 0 || packetLength <= 0) {
            return -1;
        }
        int len = packetLength - 14;
        int one = (len - 2) / 4;
        int packet = sLen / one;
        int etc = sLen % one;
        int ret = packetLength * packet;
        return ret += etc != 0 ? etc * 4 + 14 + 2 : 0;
    }

    public static final int getPacketToID(byte[] data) {
        int ret;
        try {
            ret = ConvertParam.convertInt(2, data);
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    public static final int getPacketToSubID(byte[] data) {
        int ret;
        try {
            ret = ConvertParam.convertInt(6, data);
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    public static final int getPacketToRandID(byte[] data) {
        int ret;
        try {
            ret = ConvertParam.convertInt(10, data);
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    public static final int getPacketHeaderToMaxPacket(byte[] data) {
        int ret;
        try {
            ret = ConvertParam.convertInt(14, data);
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    public static final int getPacketHeaderToTelegramLength(byte[] data) {
        int ret;
        try {
            ret = ConvertParam.convertInt(18, data);
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    public static final int getPacketHeaderToOnePacket(byte[] data) {
        int ret;
        try {
            ret = ConvertParam.convertInt(22, data);
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    public static final int getPacketHeaderToCode(byte[] data) {
        int ret;
        try {
            ret = ConvertParam.convertInt(26, data);
        }
        catch (Exception e) {
            ret = -1572864;
        }
        return ret;
    }

    public static final boolean isPacket(byte[] data) {
        return data != null && data.length >= 14 && data[0] == UdpIODef.PACKET_HEADER[0] && data[1] == UdpIODef.PACKET_HEADER[1];
    }

    public static final boolean isPacketHeader(int id, int max, int randID, byte[] data) {
        boolean ret;
        try {
            ret = data[0] == UdpIODef.PACKET_HEADER[0] && data[1] == UdpIODef.PACKET_HEADER[1] && ConvertParam.convertInt(2, data) == id && ConvertParam.convertInt(6, data) == -1 && ConvertParam.convertInt(10, data) == randID && ConvertParam.convertInt(14, data) == max;
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public static final int getReceiveID(long rcvst) {
        if (rcvst == -1L) {
            return -1;
        }
        return (int)(rcvst & 0xFFFFFFFFL);
    }

    public static final int getReceiveRandomID(long rcvst) {
        if (rcvst == -1L) {
            return -1;
        }
        return (int)((rcvst & 0xFFFFFFFF00000000L) >> 32);
    }

    public static final String getErrorCodeByString(int code) {
        String ret = null;
        switch (code) {
            case -1179137: {
                ret = "\u30a8\u30e9\u30fc(0x" + Integer.toHexString(code) + ")";
                break;
            }
            case -261888: {
                ret = "\u958b\u59cb\u96fb\u6587(0x" + Integer.toHexString(code) + ")";
                break;
            }
            case -130815: {
                ret = "\u958b\u59cb\u96fb\u6587\u30a8\u30e9\u30fc(0x" + Integer.toHexString(code) + ")";
                break;
            }
            case -261886: {
                ret = "\u958b\u59cb\u96fb\u6587\u5b8c\u4e86(0x" + Integer.toHexString(code) + ")";
                break;
            }
            case -1310461: {
                ret = "\u9001\u4fe1\u5b8c\u4e86(0x" + Integer.toHexString(code) + ")";
                break;
            }
            case -1244924: {
                ret = "\u30ed\u30b9\u30c8\u30d1\u30c3\u30b1\u30fc\u30b8\u8981\u6c42(0x" + Integer.toHexString(code) + ")";
                break;
            }
            case -1179387: {
                ret = "\u30ed\u30fc\u30eb\u30d5\u30eb(0x" + Integer.toHexString(code) + ")";
                break;
            }
            case -261882: {
                ret = "\u901a\u77e5\u78ba\u8a8dOK(0x" + Integer.toHexString(code) + ")";
                break;
            }
            default: {
                ret = "\u4e0d\u660e(0x" + Integer.toHexString(code) + ")";
            }
        }
        return ret;
    }
}

