/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.net.uio;

import com.JRcServer.commons.exception.ExistException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.net.ConnectAddress;
import com.JRcServer.commons.net.uio.UdpIODef;
import com.JRcServer.commons.resource.BinResource;
import com.JRcServer.commons.resource.Resource;
import com.JRcServer.commons.resource.ResourceType;
import com.JRcServer.commons.util.SearchInt;
import com.JRcServer.commons.util.array.IntArray;
import java.net.InetAddress;
import java.util.Arrays;

class UdpRcvConnectChild {
    private SearchInt m_subIds = null;
    private BinResource m_packets = null;
    private final ConnectAddress m_conn = new ConnectAddress();
    private int m_maxPacket = -1;
    private int m_length = -1;
    private int m_packetLen = -1;
    private long m_lastUpdate = -1L;
    private byte[] m_headerPacket = null;
    private ResourceType m_resType = null;

    public UdpRcvConnectChild() {
        this.clear();
    }

    public final void create(int max, int packetLen, int length, InetAddress addr, int port, ResourceType resType) throws InputException {
        if (max <= 0 || addr == null || port < 0 || port > 65535) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.clear();
        this.m_resType = resType == null ? UdpIODef.DEF_RESOURCE_TYPE : resType;
        this.m_subIds = new SearchInt();
        this.m_packets = Resource.createBinResource(this.m_resType, packetLen * max);
        this.m_conn.create(addr, port);
        this.m_maxPacket = max;
        this.m_length = length;
        this.m_packetLen = packetLen;
        this.m_lastUpdate = System.currentTimeMillis();
    }

    public final void clear() {
        if (this.m_subIds != null) {
            this.m_subIds.clear();
        }
        if (this.m_packets != null) {
            this.m_packets.clear();
        }
        this.m_subIds = null;
        this.m_packets = null;
        this.m_headerPacket = null;
        this.m_resType = null;
        this.m_conn.clear();
        this.m_maxPacket = -1;
        this.m_length = -1;
        this.m_packetLen = -1;
        this.m_lastUpdate = -1L;
    }

    public final void put(InetAddress addr, int port, int subID, byte[] packet) throws InputException, ExistException {
        if (this.m_subIds == null) {
            return;
        }
        if (!this.m_conn.getAddress().equals(addr) || this.m_conn.getPort() != port || packet == null || packet.length <= 0 || packet.length > this.m_packetLen) {
            if (packet == null || packet.length <= 0 || packet.length > this.m_packetLen) {
                throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            }
            throw new ExistException("\u5bfe\u8c61\u306e\u53d7\u4fe1\u6761\u4ef6(addr:" + addr + " port:" + port + ")\u306f\u4e0d\u6b63\u306a\u6761\u4ef6\u3067\u3059");
        }
        if (subID == -1) {
            this.m_headerPacket = packet;
        } else {
            Resource.arraycopy(packet, 0, this.m_packets, subID * this.m_packetLen, packet.length);
        }
        if (!this.m_subIds.isData(subID)) {
            this.m_subIds.add(subID);
        }
        this.m_lastUpdate = System.currentTimeMillis();
    }

    public final byte[] getHeader() {
        if (this.m_subIds == null) {
            return null;
        }
        return this.m_headerPacket;
    }

    public final byte[] removeHeader() {
        byte[] ret = null;
        if (this.m_subIds == null) {
            return null;
        }
        ret = this.m_headerPacket;
        this.m_headerPacket = null;
        this.m_subIds.remove(-1);
        return ret;
    }

    /*
     * Exception decompiling
     */
    public final byte[] getTelegram() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 162->165)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public final BinResource getTelegramByResource() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 186->189)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final int[] subIDs() {
        if (this.m_subIds == null) {
            return null;
        }
        return this.m_subIds.getAll();
    }

    public final int size() {
        if (this.m_subIds == null) {
            return 0;
        }
        return this.m_subIds.size();
    }

    public final InetAddress getAddress() {
        if (this.m_subIds == null) {
            return null;
        }
        return this.m_conn.getAddress();
    }

    public final int getPort() {
        if (this.m_subIds == null) {
            return -1;
        }
        return this.m_conn.getPort();
    }

    public final ConnectAddress getConnect() {
        if (this.m_subIds == null) {
            return null;
        }
        return this.m_conn;
    }

    public final int getOnePakcet() {
        if (this.m_subIds == null) {
            return 0;
        }
        return this.m_packetLen;
    }

    public final int getMaxPacket() {
        if (this.m_subIds == null) {
            return 0;
        }
        return this.m_maxPacket;
    }

    public final int getMaxLength() {
        if (this.m_subIds == null) {
            return 0;
        }
        return this.m_length;
    }

    public final long getLastUpdate() {
        if (this.m_subIds == null) {
            return -1L;
        }
        return this.m_lastUpdate;
    }

    public final IntArray getLostPacketID() {
        int len;
        int[] now = null;
        IntArray ret = null;
        if (this.m_subIds == null) {
            return null;
        }
        ret = new IntArray();
        now = this.m_subIds.getAll();
        if (now != null && (len = now.length) > 0) {
            int k;
            int j;
            int lenJ;
            Arrays.sort(now);
            int i = 0;
            int before = -1;
            while (i < len) {
                if (now[i] >= 0) {
                    if (now[i] != before + 1) {
                        lenJ = now[i] - before - 1;
                        j = 0;
                        k = before + 1;
                        while (j < lenJ) {
                            ret.add(k);
                            ++j;
                            ++k;
                        }
                    }
                    before = now[i];
                }
                ++i;
            }
            if (this.m_maxPacket != before + 1) {
                lenJ = this.m_maxPacket - before - 1;
                j = 0;
                k = before + 1;
                while (j < lenJ) {
                    ret.add(k);
                    ++j;
                    ++k;
                }
            }
            now = null;
            len = ret.size();
            if (len == 0) {
                ret = null;
            }
        } else {
            len = this.m_maxPacket;
            int i = 0;
            while (i < len) {
                ret.add(i);
                ++i;
            }
        }
        return ret;
    }

    public final boolean isLost() {
        int len = this.m_subIds.isData(-1) ? this.m_subIds.size() - 1 : this.m_subIds.size();
        return this.m_maxPacket != len;
    }

    public final boolean isData(int subID) {
        if (this.m_subIds == null) {
            return false;
        }
        return this.m_subIds.isData(subID);
    }
}

