/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.resource;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.resource.BinResource;
import com.JRcServer.commons.resource.cache.Cache;
import com.JRcServer.commons.resource.cache.CacheIO;
import com.JRcServer.commons.resource.cache.CacheManager;
import com.JRcServer.commons.thread.Synchronized;

public class BinCacheResource
implements BinResource {
    private static final int BINARY_LENGTH = 512;
    private Cache m_fp = null;
    private final Synchronized m_sync = new Synchronized();

    public BinCacheResource() {
    }

    public BinCacheResource(int size, long cacheID) throws InputException, AccessException {
        this.create(size, cacheID);
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void create(int size, long cacheID) throws InputException, AccessException {
        CacheIO io = null;
        if (size <= 0 || cacheID < 0L || (io = CacheManager.get(cacheID)) == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.clear();
        this.m_sync.create();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_fp = io.newCacheObject(size);
            }
        }
        catch (AccessException ac) {
            this.clear();
            throw ac;
        }
        catch (Exception e) {
            this.clear();
            throw new AccessException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                if (this.m_fp != null) {
                    this.m_fp.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_sync.clear();
        this.m_fp = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_fp.reset();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void set(int no, int b) {
        byte[] bin = null;
        try {
            try {
                block9: {
                    Object object = this.m_sync.get();
                    // MONITORENTER : object
                    if (this.m_fp != null) break block9;
                    // MONITOREXIT : object
                    Object var5_6 = null;
                    bin = null;
                    return;
                }
                bin[0] = (byte)(b & 0xFF);
                this.m_fp.write(bin, no);
                // MONITOREXIT : object
            }
            catch (Exception exception) {}
            Object var5_8 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            bin = null;
            throw throwable;
        }
        bin = null;
    }

    public final int setBinary(int no, byte[] bin) throws ArrayIndexOutOfBoundsException {
        if (bin == null || no < 0) {
            if (bin == null) {
                throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            }
            throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        if (bin.length <= 0) {
            return 0;
        }
        return this.setBinary(no, bin, 0, bin.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int setBinary(int no, byte[] bin, int off, int len) throws ArrayIndexOutOfBoundsException {
        int ret;
        if (bin == null || off < 0 || len <= 0 || no < 0) {
            if (bin == null) {
                throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (no < 0) {
                throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
            }
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u6761\u4ef6(off:" + off + " len:" + len + ")\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = bin.length;
        if (inputLen <= 0) {
            return 0;
        }
        if (off >= inputLen) {
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u6761\u4ef6(off:" + off + ")\u306f\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u9577(" + inputLen + ")\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                block12: {
                    if (this.m_fp != null) break block12;
                    return -1;
                }
                inputLen = off + len > inputLen ? inputLen - off : len;
                ret = this.m_fp.write(bin, no, off, inputLen);
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw ai;
        }
        catch (Exception in) {
            ret = 0;
        }
        return ret;
    }

    public final int setBinary(int no, BinResource bin) throws ArrayIndexOutOfBoundsException {
        if (bin == null || !bin.isUse() || no < 0) {
            if (bin == null || !bin.isUse()) {
                throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            }
            throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        if (bin.size() <= 0) {
            return 0;
        }
        return this.setBinary(no, bin, 0, bin.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final int setBinary(int no, BinResource bin, int off, int len) throws ArrayIndexOutOfBoundsException {
        int ret;
        byte[] buf = null;
        if (bin == null || !bin.isUse() || off < 0 || len <= 0 || no < 0) {
            if (bin == null) throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            if (!bin.isUse()) {
                throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (no >= 0) throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u6761\u4ef6(off:" + off + " len:" + len + ")\u306f\u4e0d\u6b63\u3067\u3059");
            throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        int inputLen = bin.size();
        if (inputLen <= 0) {
            return 0;
        }
        if (off >= inputLen) {
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u6761\u4ef6(off:" + off + ")\u306f\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u9577(" + inputLen + ")\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        try {
            try {
                block17: {
                    Object object = this.m_sync.get();
                    // MONITORENTER : object
                    if (this.m_fp != null) break block17;
                    // MONITOREXIT : object
                    Object var15_10 = null;
                    buf = null;
                    return -1;
                }
                inputLen = off + len > inputLen ? inputLen - off : len;
                int lenI = inputLen / 512;
                int etc = inputLen % 512;
                buf = new byte[512];
                int i = 0;
                int pnt = no;
                int bpnt = off;
                ret = 0;
                while (true) {
                    int wlen;
                    if (i >= lenI) {
                        if (etc != 0) {
                            wlen = bin.getBinary(buf, bpnt, 0, etc);
                            this.m_fp.write(buf, pnt, 0, wlen);
                            ret += wlen;
                        }
                        // MONITOREXIT : object
                        break;
                    }
                    wlen = bin.getBinary(buf, bpnt);
                    this.m_fp.write(buf, pnt, 0, wlen);
                    pnt += wlen;
                    bpnt += wlen;
                    ret += wlen;
                    ++i;
                }
            }
            catch (ArrayIndexOutOfBoundsException ai) {
                throw ai;
            }
            catch (Exception in) {
                ret = 0;
            }
            Object var15_12 = null;
        }
        catch (Throwable throwable) {
            Object var15_11 = null;
            buf = null;
            throw throwable;
        }
        buf = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final int get(int no) throws ArrayIndexOutOfBoundsException {
        int ret;
        byte[] tmp = null;
        if (no < 0) {
            throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        try {
            try {
                block11: {
                    tmp = new byte[1];
                    Object object = this.m_sync.get();
                    // MONITORENTER : object
                    if (this.m_fp != null) break block11;
                    // MONITOREXIT : object
                    Object var5_6 = null;
                    tmp = null;
                    return -1;
                }
                this.m_fp.read(tmp, no, 0, 1);
                ret = tmp[0] & 0xFF;
                // MONITOREXIT : object
            }
            catch (NullPointerException nul) {
                ret = -1;
            }
            catch (Exception e) {
                throw new ArrayIndexOutOfBoundsException(e.getMessage());
            }
            Object var5_8 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            tmp = null;
            throw throwable;
        }
        tmp = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] getBinary() {
        byte[] ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                if (this.m_fp == null) {
                    return null;
                }
                ret = this.m_fp.read(0);
            }
        }
        catch (Exception in) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] getBinary(int no) throws ArrayIndexOutOfBoundsException {
        byte[] ret = null;
        if (no < 0) {
            throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                if (this.m_fp == null) {
                    return null;
                }
                int useLen = this.m_fp.getLength();
                if (useLen > 0) {
                    ret = new byte[useLen - no];
                    this.m_fp.read(ret, no, 0, useLen - no);
                } else {
                    if (useLen <= no) {
                        throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + ")\u306f\u6709\u52b9\u30c7\u30fc\u30bf\u9577(" + useLen + ")\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
                    }
                    ret = null;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw ai;
        }
        catch (Exception in) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] getBinary(int no, int len) throws ArrayIndexOutOfBoundsException {
        byte[] ret = null;
        if (no < 0) {
            throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        if (len <= 0) {
            return null;
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                if (this.m_fp == null) {
                    return null;
                }
                int useLen = this.m_fp.getLength();
                if (useLen > 0) {
                    len = useLen < no + len ? useLen - no : len;
                    ret = new byte[len];
                    this.m_fp.read(ret, no, 0, len);
                } else {
                    if (useLen <= no) {
                        throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + ")\u306f\u6709\u52b9\u30c7\u30fc\u30bf\u9577(" + useLen + ")\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
                    }
                    ret = null;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw ai;
        }
        catch (Exception in) {
            ret = null;
        }
        return ret;
    }

    public final int getBinary(byte[] out) {
        if (out == null) {
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = out.length;
        if (inputLen <= 0) {
            return 0;
        }
        return this.getBinary(out, 0, 0, inputLen);
    }

    public final int getBinary(byte[] out, int no) throws ArrayIndexOutOfBoundsException {
        if (out == null) {
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = out.length;
        if (inputLen <= 0) {
            return 0;
        }
        return this.getBinary(out, no, 0, inputLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getBinary(byte[] out, int no, int off, int len) throws ArrayIndexOutOfBoundsException {
        int ret;
        if (out == null || off < 0 || len <= 0 || no < 0) {
            if (out == null) {
                throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (no < 0) {
                throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
            }
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u6761\u4ef6(off:" + off + " len:" + len + ")\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = out.length;
        if (inputLen <= 0) {
            return 0;
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                block11: {
                    if (this.m_fp != null) break block11;
                    return -1;
                }
                int useLen = this.m_fp.getLength();
                inputLen = off + len > inputLen ? inputLen - off : len;
                inputLen = useLen < no + inputLen ? useLen - no : inputLen;
                ret = this.m_fp.read(out, no, off, inputLen);
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw ai;
        }
        catch (Exception in) {
            ret = 0;
        }
        return ret;
    }

    public final int getBinary(BinResource out) {
        if (out == null || !out.isUse()) {
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = out.getAllSize();
        if (inputLen <= 0) {
            return 0;
        }
        return this.getBinary(out, 0, 0, inputLen);
    }

    public final int getBinary(BinResource out, int no) throws ArrayIndexOutOfBoundsException {
        if (out == null || !out.isUse()) {
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = out.getAllSize();
        if (inputLen <= 0) {
            return 0;
        }
        return this.getBinary(out, no, 0, inputLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getBinary(BinResource out, int no, int off, int len) throws ArrayIndexOutOfBoundsException {
        int ret;
        if (out == null || !out.isUse() || off < 0 || len <= 0 || no < 0) {
            if (out == null || !out.isUse()) {
                throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (no < 0) {
                throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
            }
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u6761\u4ef6(off:" + off + " len:" + len + ")\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = out.getAllSize();
        if (inputLen <= 0) {
            return 0;
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                block11: {
                    if (this.m_fp != null) break block11;
                    return -1;
                }
                int useLen = this.m_fp.getLength();
                inputLen = useLen < no + len ? useLen - no : len;
                ret = out.setBinary(off, this, no, inputLen);
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw ai;
        }
        catch (Exception in) {
            ret = 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                block6: {
                    if (this.m_fp != null) break block6;
                    return -1;
                }
                ret = this.m_fp.getLength();
            }
        }
        catch (Exception e) {
            ret = 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getAllSize() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                block6: {
                    if (this.m_fp != null) break block6;
                    return -1;
                }
                ret = this.m_fp.getSector() * 4096;
            }
        }
        catch (Exception e) {
            ret = 0;
        }
        return ret;
    }

    public final int getType() {
        return 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isUse() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_fp != null;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }
}

