/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.resource;

import com.JRcServer.commons.def.BaseDef;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.io.FileAccessException;
import com.JRcServer.commons.io.IOCom;
import com.JRcServer.commons.io.RandomIO;
import com.JRcServer.commons.resource.BinResource;
import com.JRcServer.commons.resource.Resource;
import com.JRcServer.commons.thread.Synchronized;
import com.JRcServer.commons.util.UtilCom;

public class BinFileResource
implements BinResource {
    private static final int BINARY_LENGTH = 512;
    private final RandomIO m_fp = new RandomIO();
    private int m_allLength = -1;
    private int m_usePoint = 0;
    private String m_randName = null;
    private boolean m_delFlg = false;
    private final Synchronized m_sync = new Synchronized();

    public BinFileResource() {
    }

    public BinFileResource(String dir, int size) throws InputException {
        this.create(dir, size);
    }

    public BinFileResource(String name) throws InputException {
        this.create(name);
    }

    public BinFileResource(boolean mode, String name) throws InputException {
        this.create(mode, name);
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void create(String dir, int size) throws InputException {
        if (dir == null || size <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.clear();
        this.m_sync.create();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                if (!IOCom.isDirExists(dir)) {
                    throw new InputException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u540d(" + dir + ")\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                }
                dir = IOCom.getFullPath(dir);
                this.m_randName = BinFileResource.createRandomFile(dir, this.m_fp);
                this.m_fp.setLength(size);
                this.m_allLength = size;
                this.m_delFlg = true;
            }
        }
        catch (InputException in) {
            this.clear();
            throw in;
        }
        catch (Exception e) {
            this.clear();
            throw new InputException(e);
        }
    }

    public final void create(String name) throws InputException {
        this.create(false, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void create(boolean mode, String name) throws InputException {
        if (name == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.clear();
        this.m_sync.create();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                if (!mode && !IOCom.isFileExists(name)) {
                    throw new InputException("\u30d5\u30a1\u30a4\u30eb\u540d(" + name + ")\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                }
                this.m_fp.open(name, false);
                this.m_randName = this.m_fp.getFileName();
                this.m_allLength = this.m_usePoint = (int)this.m_fp.getLength();
                this.m_delFlg = false;
            }
        }
        catch (InputException in) {
            this.clear();
            throw in;
        }
        catch (Exception e) {
            this.clear();
            throw new InputException(e);
        }
    }

    public final void clear() {
        String name = null;
        name = this.m_fp.getFileName();
        this.m_sync.clear();
        if (this.m_delFlg && name != null) {
            this.m_fp.close();
            try {
                IOCom.deleteFile(name);
            }
            catch (Exception exception) {}
        } else if (!this.m_delFlg && this.m_fp.isOpen()) {
            try {
                this.m_fp.setLength(this.m_usePoint);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_fp.close();
        }
        this.m_fp.close();
        this.m_randName = null;
        this.m_allLength = -1;
        this.m_usePoint = 0;
        this.m_delFlg = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_usePoint = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(int no, int b) {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.newSize(no + 1);
                this.m_fp.write(new byte[]{(byte)(b & 0xFF)}, no);
                this.m_usePoint = this.m_usePoint <= no + 1 ? no + 1 : this.m_usePoint;
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw ai;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final int setBinary(int no, byte[] bin) throws ArrayIndexOutOfBoundsException {
        if (bin == null || no < 0) {
            if (bin == null) {
                throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            }
            throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        if (bin.length <= 0) {
            return 0;
        }
        return this.setBinary(no, bin, 0, bin.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int setBinary(int no, byte[] bin, int off, int len) throws ArrayIndexOutOfBoundsException {
        int ret;
        if (bin == null || off < 0 || len <= 0 || no < 0) {
            if (bin == null) {
                throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (no < 0) {
                throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
            }
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u6761\u4ef6(off:" + off + " len:" + len + ")\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = bin.length;
        if (inputLen <= 0) {
            return 0;
        }
        if (off >= inputLen) {
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u6761\u4ef6(off:" + off + ")\u306f\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u9577(" + inputLen + ")\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                inputLen = off + len > inputLen ? inputLen - off : len;
                this.newSize(inputLen + no);
                this.m_fp.write(bin, no, off, inputLen);
                this.m_usePoint = this.m_usePoint <= no + inputLen ? no + inputLen : this.m_usePoint;
                ret = inputLen;
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw ai;
        }
        catch (Exception in) {
            ret = 0;
        }
        return ret;
    }

    public final int setBinary(int no, BinResource bin) throws ArrayIndexOutOfBoundsException {
        if (bin == null || !bin.isUse() || no < 0) {
            if (bin == null || !bin.isUse()) {
                throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            }
            throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        if (bin.size() <= 0) {
            return 0;
        }
        return this.setBinary(no, bin, 0, bin.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int setBinary(int no, BinResource bin, int off, int len) throws ArrayIndexOutOfBoundsException {
        int ret;
        RandomIO fp = null;
        byte[] buf = null;
        if (bin == null || !bin.isUse() || off < 0 || len <= 0 || no < 0) {
            if (bin == null) throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            if (!bin.isUse()) {
                throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (no >= 0) throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u6761\u4ef6(off:" + off + " len:" + len + ")\u306f\u4e0d\u6b63\u3067\u3059");
            throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        int inputLen = bin.size();
        if (inputLen <= 0) {
            return 0;
        }
        if (off >= inputLen) {
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u6761\u4ef6(off:" + off + ")\u306f\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u9577(" + inputLen + ")\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    fp = this.m_fp;
                    inputLen = off + len > inputLen ? inputLen - off : len;
                    this.newSize(inputLen + no);
                    int lenI = inputLen / 512;
                    int etc = inputLen % 512;
                    buf = new byte[512];
                    int i = 0;
                    int pnt = no;
                    int bpnt = off;
                    ret = 0;
                    while (true) {
                        int wlen;
                        if (i >= lenI) {
                            if (etc == 0) break;
                            wlen = bin.getBinary(buf, bpnt, 0, etc);
                            fp.write(buf, pnt, 0, wlen);
                            ret += wlen;
                        }
                        wlen = bin.getBinary(buf, bpnt);
                        fp.write(buf, pnt, 0, wlen);
                        pnt += wlen;
                        bpnt += wlen;
                        ret += wlen;
                        ++i;
                    }
                    this.m_usePoint = this.m_usePoint <= no + inputLen ? no + inputLen : this.m_usePoint;
                }
            }
            catch (ArrayIndexOutOfBoundsException ai) {
                throw ai;
            }
            catch (Exception in) {
                ret = 0;
            }
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            fp = null;
            buf = null;
            throw throwable;
        }
        {
            Object var16_20 = null;
            fp = null;
        }
        buf = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int get(int no) throws ArrayIndexOutOfBoundsException {
        int ret;
        byte[] tmp = null;
        if (no < 0) {
            throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    if (this.m_usePoint <= no) {
                        throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + ")\u306f\u6709\u52b9\u30c7\u30fc\u30bf\u9577(" + this.m_usePoint + ")\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
                    }
                    tmp = this.m_fp.read(no, 1);
                    ret = tmp[0] & 0xFF;
                }
            }
            catch (ArrayIndexOutOfBoundsException ai) {
                throw ai;
            }
            catch (Exception in) {
                ret = -1;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            tmp = null;
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        tmp = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] getBinary() {
        byte[] ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                if (this.m_usePoint <= 0) {
                    return null;
                }
                ret = this.m_fp.read(0L, this.m_usePoint);
            }
        }
        catch (Exception in) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] getBinary(int no) throws ArrayIndexOutOfBoundsException {
        byte[] ret = null;
        if (no < 0) {
            throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                if (this.m_usePoint <= no) {
                    throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + ")\u306f\u6709\u52b9\u30c7\u30fc\u30bf\u9577(" + this.m_usePoint + ")\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
                }
                int len = this.m_usePoint;
                ret = this.m_fp.read(no, len - no);
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw ai;
        }
        catch (Exception in) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] getBinary(int no, int len) throws ArrayIndexOutOfBoundsException {
        byte[] ret = null;
        if (no < 0) {
            throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        if (len <= 0) {
            return null;
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                if (this.m_usePoint <= no) {
                    throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + ")\u306f\u6709\u52b9\u30c7\u30fc\u30bf\u9577(" + this.m_usePoint + ")\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
                }
                len = this.m_usePoint < no + len ? this.m_usePoint - no : len;
                ret = this.m_fp.read(no, len);
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw ai;
        }
        catch (Exception in) {
            ret = null;
        }
        return ret;
    }

    public final int getBinary(byte[] out) {
        if (out == null) {
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = out.length;
        if (inputLen <= 0) {
            return 0;
        }
        return this.getBinary(out, 0, 0, inputLen);
    }

    public final int getBinary(byte[] out, int no) throws ArrayIndexOutOfBoundsException {
        if (out == null) {
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = out.length;
        if (inputLen <= 0) {
            return 0;
        }
        return this.getBinary(out, no, 0, inputLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getBinary(byte[] out, int no, int off, int len) throws ArrayIndexOutOfBoundsException {
        int ret;
        if (out == null || off < 0 || len <= 0 || no < 0) {
            if (out == null) {
                throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (no < 0) {
                throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
            }
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u6761\u4ef6(off:" + off + " len:" + len + ")\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = out.length;
        if (inputLen <= 0) {
            return 0;
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                inputLen = off + len > inputLen ? inputLen - off : len;
                inputLen = this.m_usePoint < no + inputLen ? this.m_usePoint - no : inputLen;
                ret = this.m_fp.read(out, no, off, inputLen);
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw ai;
        }
        catch (Exception in) {
            ret = 0;
        }
        return ret;
    }

    public final int getBinary(BinResource out) {
        if (out == null || !out.isUse()) {
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = out.getAllSize();
        if (inputLen <= 0) {
            return 0;
        }
        return this.getBinary(out, 0, 0, inputLen);
    }

    public final int getBinary(BinResource out, int no) throws ArrayIndexOutOfBoundsException {
        if (out == null || !out.isUse()) {
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = out.getAllSize();
        if (inputLen <= 0) {
            return 0;
        }
        return this.getBinary(out, no, 0, inputLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getBinary(BinResource out, int no, int off, int len) throws ArrayIndexOutOfBoundsException {
        int ret;
        if (out == null || !out.isUse() || off < 0 || len <= 0 || no < 0) {
            if (out == null || !out.isUse()) {
                throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (no < 0) {
                throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
            }
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u6761\u4ef6(off:" + off + " len:" + len + ")\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = out.getAllSize();
        if (inputLen <= 0) {
            return 0;
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                inputLen = this.m_usePoint < no + len ? this.m_usePoint - no : len;
                ret = out.setBinary(off, this, no, inputLen);
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw ai;
        }
        catch (Exception in) {
            ret = 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_usePoint;
            }
        }
        catch (Exception e) {
            ret = 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getAllSize() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_allLength;
            }
        }
        catch (Exception e) {
            ret = 0;
        }
        return ret;
    }

    public final int getType() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isUse() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_fp.isOpen();
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    private final void newSize(int size) throws InputException {
        if (size <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            if (this.isUse() && this.m_allLength < size) {
                size = size / 512 + size % 512;
                this.m_fp.setLength(size *= 512);
                this.m_allLength = size;
            }
        }
        catch (Exception e) {
            throw new InputException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String createRandomFile(String dir, RandomIO fp) throws InputException, FileAccessException {
        StringBuffer buf = null;
        String randName = null;
        String randFPath = null;
        int i = 0;
        while (i < 9) {
            Object object = Resource.SYNC;
            synchronized (object) {
                randName = UtilCom.randomString(64, true, true, true);
                buf = new StringBuffer();
                buf.append(dir);
                buf.append(BaseDef.FILE_SEPARATOR);
                buf.append(randName);
                randFPath = buf.toString();
                buf = null;
                if (!IOCom.isFileExists(randFPath)) {
                    break;
                }
                randFPath = null;
            }
            ++i;
        }
        if (randFPath == null) {
            throw new FileAccessException("\u30e9\u30f3\u30c0\u30e0\u30d5\u30a1\u30a4\u30eb\u540d\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        fp.open(randFPath, true);
        return randName;
    }
}

