/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.resource;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.resource.BinResource;
import com.JRcServer.commons.thread.Synchronized;

public class BinMemoryResource
implements BinResource {
    private static final int BINARY_LENGTH = 512;
    private byte[] m_binary = null;
    private int m_usePoint = 0;
    private int m_allLength = -1;
    private final Synchronized m_sync = new Synchronized();

    public BinMemoryResource() {
    }

    public BinMemoryResource(int size) throws InputException {
        this.create(size);
    }

    public BinMemoryResource(byte[] binary) throws InputException {
        this.create(binary);
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void create(int size) throws InputException {
        if (size <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.clear();
        this.m_sync.create();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.newSize(size);
            }
        }
        catch (Exception e) {
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void create(byte[] binary) throws InputException {
        if (binary == null || binary.length <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.clear();
        this.m_sync.create();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_binary = binary;
                this.m_allLength = this.m_usePoint = binary.length;
            }
        }
        catch (Exception e) {
            this.clear();
        }
    }

    public final void clear() {
        this.m_sync.clear();
        this.m_binary = null;
        this.m_usePoint = 0;
        this.m_allLength = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_usePoint = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(int no, int b) {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.newSize(no + 1);
                this.m_binary[no] = (byte)(b & 0xFF);
                this.m_usePoint = this.m_usePoint <= no + 1 ? no + 1 : this.m_usePoint;
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw ai;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final int setBinary(int no, byte[] bin) throws ArrayIndexOutOfBoundsException {
        if (bin == null || no < 0) {
            if (bin == null) {
                throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            }
            throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        if (bin.length <= 0) {
            return 0;
        }
        return this.setBinary(no, bin, 0, bin.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int setBinary(int no, byte[] bin, int off, int len) throws ArrayIndexOutOfBoundsException {
        int ret;
        if (bin == null || off < 0 || len <= 0 || no < 0) {
            if (bin == null) {
                throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (no < 0) {
                throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
            }
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u6761\u4ef6(off:" + off + " len:" + len + ")\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = bin.length;
        if (inputLen <= 0) {
            return 0;
        }
        if (off >= inputLen) {
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u6761\u4ef6(off:" + off + ")\u306f\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u9577(" + inputLen + ")\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                inputLen = off + len > inputLen ? inputLen - off : len;
                this.newSize(inputLen + no);
                System.arraycopy(bin, off, this.m_binary, no, inputLen);
                this.m_usePoint = this.m_usePoint <= no + inputLen ? no + inputLen : this.m_usePoint;
                ret = inputLen;
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw ai;
        }
        catch (Exception in) {
            ret = 0;
        }
        return ret;
    }

    public final int setBinary(int no, BinResource bin) throws ArrayIndexOutOfBoundsException {
        if (bin == null || !bin.isUse() || no < 0) {
            if (bin == null || !bin.isUse()) {
                throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            }
            throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        if (bin.size() <= 0) {
            return 0;
        }
        return this.setBinary(no, bin, 0, bin.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int setBinary(int no, BinResource bin, int off, int len) throws ArrayIndexOutOfBoundsException {
        int ret;
        byte[] binary = null;
        byte[] buf = null;
        if (bin == null || !bin.isUse() || off < 0 || len <= 0 || no < 0) {
            if (bin == null) throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            if (!bin.isUse()) {
                throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (no >= 0) throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u6761\u4ef6(off:" + off + " len:" + len + ")\u306f\u4e0d\u6b63\u3067\u3059");
            throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        int inputLen = bin.size();
        if (inputLen <= 0) {
            return 0;
        }
        if (off >= inputLen) {
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u6761\u4ef6(off:" + off + ")\u306f\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u9577(" + inputLen + ")\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
        }
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    inputLen = off + len > inputLen ? inputLen - off : len;
                    this.newSize(inputLen + no);
                    binary = this.m_binary;
                    int lenI = inputLen / 512;
                    int etc = inputLen % 512;
                    buf = new byte[512];
                    int i = 0;
                    int pnt = no;
                    int bpnt = off;
                    ret = 0;
                    while (true) {
                        int wlen;
                        if (i >= lenI) {
                            if (etc == 0) break;
                            wlen = bin.getBinary(buf, bpnt, 0, etc);
                            System.arraycopy(buf, 0, binary, pnt, wlen);
                            ret += wlen;
                        }
                        wlen = bin.getBinary(buf, bpnt);
                        System.arraycopy(buf, 0, binary, pnt, wlen);
                        pnt += wlen;
                        bpnt += wlen;
                        ret += wlen;
                        ++i;
                    }
                    this.m_usePoint = this.m_usePoint <= no + inputLen ? no + inputLen : this.m_usePoint;
                }
            }
            catch (ArrayIndexOutOfBoundsException ai) {
                throw ai;
            }
            catch (Exception in) {
                ret = 0;
            }
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            binary = null;
            buf = null;
            throw throwable;
        }
        {
            Object var16_20 = null;
        }
        binary = null;
        buf = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int get(int no) throws ArrayIndexOutOfBoundsException {
        int ret;
        if (no < 0) {
            throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                if (this.m_usePoint <= no) {
                    throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + ")\u306f\u6709\u52b9\u30c7\u30fc\u30bf\u9577(" + this.m_usePoint + ")\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
                }
                ret = this.m_binary[no] & 0xFF;
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw ai;
        }
        catch (Exception in) {
            ret = -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] getBinary() {
        byte[] ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                if (this.m_usePoint <= 0) {
                    return null;
                }
                ret = new byte[this.m_usePoint];
                System.arraycopy(this.m_binary, 0, ret, 0, this.m_usePoint);
            }
        }
        catch (Exception in) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] getBinary(int no) throws ArrayIndexOutOfBoundsException {
        byte[] ret = null;
        if (no < 0) {
            throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                if (this.m_usePoint <= no) {
                    throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + ")\u306f\u6709\u52b9\u30c7\u30fc\u30bf\u9577(" + this.m_usePoint + ")\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
                }
                int len = this.m_usePoint;
                ret = new byte[len - no];
                System.arraycopy(this.m_binary, no, ret, 0, len - no);
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw ai;
        }
        catch (Exception in) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] getBinary(int no, int len) throws ArrayIndexOutOfBoundsException {
        byte[] ret = null;
        if (no < 0) {
            throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        if (len <= 0) {
            return null;
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                if (this.m_usePoint <= no) {
                    throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + ")\u306f\u6709\u52b9\u30c7\u30fc\u30bf\u9577(" + this.m_usePoint + ")\u3092\u8d8a\u3057\u3066\u3044\u307e\u3059");
                }
                len = this.m_usePoint < no + len ? this.m_usePoint - no : len;
                ret = new byte[len];
                System.arraycopy(this.m_binary, no, ret, 0, len);
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw ai;
        }
        catch (Exception in) {
            ret = null;
        }
        return ret;
    }

    public final int getBinary(byte[] out) {
        if (out == null) {
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = out.length;
        if (inputLen <= 0) {
            return 0;
        }
        return this.getBinary(out, 0, 0, inputLen);
    }

    public final int getBinary(byte[] out, int no) throws ArrayIndexOutOfBoundsException {
        if (out == null) {
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = out.length;
        if (inputLen <= 0) {
            return 0;
        }
        return this.getBinary(out, no, 0, inputLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getBinary(byte[] out, int no, int off, int len) throws ArrayIndexOutOfBoundsException {
        int ret;
        if (out == null || off < 0 || len <= 0 || no < 0) {
            if (out == null) {
                throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (no < 0) {
                throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
            }
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u6761\u4ef6(off:" + off + " len:" + len + ")\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = out.length;
        if (inputLen <= 0) {
            return 0;
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                inputLen = off + len > inputLen ? inputLen - off : len;
                inputLen = this.m_usePoint < no + inputLen ? this.m_usePoint - no : inputLen;
                System.arraycopy(this.m_binary, no, out, off, inputLen);
                ret = inputLen;
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw ai;
        }
        catch (Exception in) {
            ret = 0;
        }
        return ret;
    }

    public final int getBinary(BinResource out) {
        if (out == null || !out.isUse()) {
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = out.getAllSize();
        if (inputLen <= 0) {
            return 0;
        }
        return this.getBinary(out, 0, 0, inputLen);
    }

    public final int getBinary(BinResource out, int no) throws ArrayIndexOutOfBoundsException {
        if (out == null || !out.isUse()) {
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = out.getAllSize();
        if (inputLen <= 0) {
            return 0;
        }
        return this.getBinary(out, no, 0, inputLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getBinary(BinResource out, int no, int off, int len) throws ArrayIndexOutOfBoundsException {
        int ret;
        if (out == null || !out.isUse() || off < 0 || len <= 0 || no < 0) {
            if (out == null || !out.isUse()) {
                throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u30d0\u30a4\u30ca\u30ea\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (no < 0) {
                throw new ArrayIndexOutOfBoundsException("\u6307\u5b9a\u4f4d\u7f6e(" + no + "\u306f\u7bc4\u56f2\u5916\u3067\u3059");
            }
            throw new ArrayIndexOutOfBoundsException("\u8a2d\u5b9a\u6761\u4ef6(off:" + off + " len:" + len + ")\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int inputLen = out.getAllSize();
        if (inputLen <= 0) {
            return 0;
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                inputLen = off + len > inputLen ? inputLen - off : len;
                inputLen = this.m_usePoint < no + inputLen ? this.m_usePoint - no : inputLen;
                ret = out.setBinary(off, this, no, inputLen);
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw ai;
        }
        catch (Exception in) {
            ret = 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_usePoint;
            }
        }
        catch (Exception e) {
            ret = 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getAllSize() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_binary.length;
            }
        }
        catch (Exception e) {
            ret = 0;
        }
        return ret;
    }

    public final int getType() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isUse() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_binary != null;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void newSize(int size) throws InputException {
        byte[] tmp = null;
        if (size <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            try {
                if (this.m_binary != null) {
                    if (this.m_allLength < size) {
                        size = size / 512 + size % 512;
                        tmp = this.m_binary;
                        this.m_binary = new byte[size *= 512];
                        System.arraycopy(tmp, 0, this.m_binary, 0, this.m_allLength);
                        this.m_allLength = size;
                    }
                } else {
                    size = size / 512 + size % 512;
                    this.m_binary = new byte[size *= 512];
                    this.m_allLength = size;
                }
            }
            catch (Exception e) {
                throw new InputException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            tmp = null;
            throw throwable;
        }
        {
            Object var5_6 = null;
        }
        tmp = null;
    }
}

