/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.resource;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.resource.BinResource;
import com.JRcServer.commons.util.array.IntArray;
import java.io.IOException;
import java.io.InputStream;

public class BinResourceInputStream
extends InputStream {
    private BinResource m_resource = null;
    private int m_seek = 0;
    private int m_length = -1;
    private final IntArray m_mark = new IntArray();
    private boolean m_closeMode = false;

    private BinResourceInputStream() {
    }

    public BinResourceInputStream(BinResource resource) throws InputException {
        this(false, resource);
    }

    public BinResourceInputStream(boolean closeMode, BinResource resource) throws InputException {
        this(closeMode, resource, 0);
    }

    public BinResourceInputStream(boolean closeMode, BinResource resource, int offset) throws InputException {
        if (resource == null || !resource.isUse()) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.close();
        this.m_resource = resource;
        this.m_closeMode = closeMode;
        this.m_seek = offset <= 0 ? 0 : offset;
        this.m_length = resource.size();
    }

    public BinResourceInputStream(BinResource resource, int offset, int length) throws InputException {
        this(false, resource, offset, length);
    }

    public BinResourceInputStream(boolean closeMode, BinResource resource, int offset, int length) throws InputException {
        if (resource == null || !resource.isUse() || offset < 0 || length <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.close();
        int resourceLen = resource.size();
        this.m_resource = resource;
        this.m_closeMode = closeMode;
        this.m_seek = offset;
        this.m_length = resourceLen < offset + length ? resourceLen : offset + length;
    }

    protected final void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void close() {
        if (this.m_closeMode && this.m_resource != null) {
            this.m_resource.clear();
        }
        this.m_resource = null;
        this.m_seek = 0;
        this.m_length = -1;
        this.m_mark.clear();
        this.m_closeMode = false;
    }

    public final int read() throws IOException {
        int ret;
        try {
            if (this.m_length <= this.m_seek) {
                ret = -1;
            } else {
                ret = this.m_resource.get(this.m_seek) & 0xFF;
                ++this.m_seek;
            }
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    public final int read(byte[] binary) throws IOException {
        return this.read(binary, 0, binary.length);
    }

    public final int read(byte[] binary, int offset, int length) throws IOException {
        int ret;
        if ((offset | length | offset + length | binary.length - (offset + length)) < 0) {
            throw new IndexOutOfBoundsException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (length == 0) {
            return 0;
        }
        try {
            ret = this.m_length <= this.m_seek + length ? (this.m_length <= this.m_seek ? -1 : this.m_resource.getBinary(binary, this.m_seek, offset, this.m_length - this.m_seek)) : this.m_resource.getBinary(binary, this.m_seek, offset, length);
            this.m_seek += ret <= 0 ? 0 : ret;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return ret;
    }

    public final long skip(long n) throws IOException {
        long ret = 0L;
        try {
            if (n > 0L) {
                int length = this.m_length;
                int seek = this.m_seek;
                if ((long)length <= n + (long)seek) {
                    ret = length - seek;
                    this.m_seek = length;
                } else {
                    ret = n;
                    this.m_seek = (int)((long)this.m_seek + n);
                }
            }
        }
        catch (Exception t) {
            ret = 0L;
        }
        return ret;
    }

    public final int available() throws IOException {
        int ret;
        try {
            ret = this.m_length - this.m_seek;
        }
        catch (Exception t) {
            ret = 0;
        }
        return ret;
    }

    public final void mark(int offset) {
        try {
            int seek = this.m_seek + offset;
            if (seek >= 0 && seek < this.m_length) {
                this.m_mark.add(seek);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void reset() throws IOException {
        try {
            if (this.m_mark.size() == 0) {
                throw new IOException("\u30de\u30fc\u30af\u3057\u305f\u4f4d\u7f6e\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            this.m_seek = this.m_mark.remove(0);
        }
        catch (IOException io) {
            throw io;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final boolean markSupported() {
        return true;
    }

    public final BinResource getBinResource() {
        return this.m_resource;
    }
}

