/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.resource;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.resource.BinResource;
import java.io.IOException;
import java.io.OutputStream;

public class BinResourceOutputStream
extends OutputStream {
    private static final int ADD_SIZE = 1024;
    private BinResource m_resource = null;
    private int m_seek = 0;
    private boolean m_closeMode = false;

    private BinResourceOutputStream() {
    }

    public BinResourceOutputStream(BinResource resource) throws InputException {
        this(false, resource, 0);
    }

    public BinResourceOutputStream(boolean closeMode, BinResource resource) throws InputException {
        this(closeMode, resource, 0);
    }

    public BinResourceOutputStream(boolean closeMode, BinResource resource, int offset) throws InputException {
        if (resource == null || !resource.isUse()) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.m_resource = resource;
        this.m_closeMode = closeMode;
        this.m_seek = offset <= 0 ? 0 : offset;
    }

    protected final void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void close() {
        if (this.m_closeMode && this.m_resource != null) {
            this.m_resource.clear();
        }
        this.m_resource = null;
        this.m_seek = 0;
        this.m_closeMode = false;
    }

    public final void flush() throws IOException {
        super.flush();
    }

    public final void write(int b) throws IOException {
        try {
            this.m_resource.set(this.m_seek, (byte)(b & 0xFF));
            ++this.m_seek;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public final void write(byte[] binary, int offset, int length) throws IOException {
        if ((offset | length | offset + length | binary.length - (offset + length)) < 0) {
            throw new IndexOutOfBoundsException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (length == 0) {
            return;
        }
        try {
            this.m_resource.setBinary(this.m_seek, binary, offset, length);
            this.m_seek += length;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public final BinResource getBinResource() {
        return this.m_resource;
    }
}

