/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.resource;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.resource.CharResource;
import java.util.Arrays;

public class BufferedCharResource {
    private char[] m_buffer = null;
    private int m_bufLen = -1;
    private int m_pos = -1;
    private int m_posLen = -1;
    private CharResource m_resource = null;
    private int m_resourceLen = -1;
    private boolean m_writeFlg = false;

    private BufferedCharResource() {
    }

    public BufferedCharResource(CharResource resource) throws InputException {
        this(resource, 512);
    }

    public BufferedCharResource(CharResource resource, int size) throws InputException {
        if (resource == null || !resource.isUse()) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.m_bufLen = size = size < 512 ? 512 : size;
        this.m_buffer = new char[size];
        this.m_resource = resource;
        this.m_resourceLen = resource.size();
        this.m_writeFlg = false;
    }

    protected void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void clear() {
        try {
            try {
                this.flush();
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable throwable) {
            }
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.m_buffer = null;
            this.m_bufLen = -1;
            this.m_pos = -1;
            this.m_posLen = -1;
            this.m_resource = null;
            this.m_resourceLen = -1;
            this.m_writeFlg = false;
            throw throwable;
        }
        {
            Object var2_5 = null;
            this.m_buffer = null;
            this.m_bufLen = -1;
            this.m_pos = -1;
            this.m_posLen = -1;
            this.m_resource = null;
            this.m_resourceLen = -1;
            this.m_writeFlg = false;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void flush() {
        try {
            try {
                if (this.m_pos != -1 && this.m_posLen > 0 && this.m_resource != null && this.m_resource.isUse() && this.m_writeFlg) {
                    this.m_resource.setChars(this.m_pos, this.m_buffer, 0, this.m_posLen);
                    this.m_resourceLen = this.m_resource.size();
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.m_writeFlg = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.m_writeFlg = false;
            return;
        }
    }

    public final void set(int no, int value) {
        if (no < 0) {
            return;
        }
        no = this.newBuffer(no);
        this.m_buffer[no] = (char)(value & 0xFFFF);
        this.m_posLen = this.m_posLen < no + 1 ? no + 1 : this.m_posLen;
        this.m_writeFlg = true;
    }

    public final int get(int no) {
        if (no < 0) {
            return -1;
        }
        return this.m_posLen <= (no = this.newBuffer(no)) ? -1 : this.m_buffer[no] & 0xFF;
    }

    public final int size() {
        return this.m_resourceLen;
    }

    public final int getBufferLength() {
        return this.m_bufLen;
    }

    public final CharResource getResource() {
        return this.m_resource;
    }

    private final int newBuffer(int no) {
        int pos = this.m_pos;
        int posLen = this.m_posLen;
        if (pos != -1 && no >= pos && no < pos + this.m_bufLen) {
            return no - pos;
        }
        if (pos != -1 && posLen > 0) {
            this.m_resource.setChars(pos, this.m_buffer, 0, posLen);
        }
        Arrays.fill(this.m_buffer, '\u0000');
        try {
            this.m_posLen = this.m_resource.getChars(this.m_buffer, no);
            this.m_pos = no;
        }
        catch (Exception e) {
            this.m_posLen = 0;
            this.m_pos = no;
        }
        this.m_resourceLen = this.m_resource.size();
        return 0;
    }
}

