/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.resource;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.resource.CharResource;
import com.JRcServer.commons.resource.Resource;
import com.JRcServer.commons.resource.ResourceType;
import com.JRcServer.commons.util.Roll;

public class CharResourceRoll
implements Roll {
    private static final int DEF_SIZE = 32;
    private CharResource[] m_roll = null;
    private ResourceType m_resType = null;
    private int m_max = 0;
    private int m_now = 0;
    private int m_nowLen = 0;
    private int m_addResCnt = 0;

    private CharResourceRoll() {
    }

    public CharResourceRoll(ResourceType resType, int max) throws InputException {
        CharResource[] roll = null;
        if (resType == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        max = max <= 32 ? 32 : max;
        roll = new CharResource[max];
        int i = 0;
        while (i < max) {
            roll[i] = null;
            ++i;
        }
        this.m_roll = roll;
        this.m_resType = resType;
        this.m_max = max;
        this.m_now = 0;
        this.m_nowLen = 0;
        this.m_addResCnt = 0;
    }

    protected final void finalize() throws Exception {
        this.destroy();
    }

    public final void destroy() {
        CharResource[] roll = null;
        int len = this.m_max;
        if (len > 0) {
            roll = this.m_roll;
            int i = 0;
            while (i < len) {
                if (roll[i] != null) {
                    roll[i].clear();
                }
                roll[i] = null;
                ++i;
            }
        }
        this.m_roll = null;
        this.m_resType = null;
        this.m_max = 0;
        this.m_now = 0;
        this.m_nowLen = 0;
        this.m_addResCnt = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addReservationByON() {
        CharResourceRoll charResourceRoll = this;
        synchronized (charResourceRoll) {
            ++this.m_addResCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addReservationByOFF() {
        CharResourceRoll charResourceRoll = this;
        synchronized (charResourceRoll) {
            this.m_addResCnt = this.m_addResCnt <= 0 ? 0 : this.m_addResCnt - 1;
        }
    }

    public final boolean add(char[] value) throws InputException {
        return this.addTo(false, value);
    }

    public final boolean add(CharResource value) throws InputException {
        return this.addTo(false, value);
    }

    public final boolean addHead(char[] value) throws InputException {
        return this.addTo(true, value);
    }

    public final boolean addHead(CharResource value) throws InputException {
        return this.addTo(true, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final char[] getChars() {
        CharResource[] roll = null;
        char[] ret = null;
        CharResourceRoll charResourceRoll = this;
        synchronized (charResourceRoll) {
            if (this.m_nowLen <= 0) {
                ret = null;
            } else {
                roll = this.m_roll;
                int pnt = this.m_now - this.m_nowLen;
                if (pnt < 0) {
                    pnt = this.m_max + pnt;
                }
                ret = roll[pnt].getChars(0);
                roll[pnt].reset();
                --this.m_nowLen;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CharResource getCharResource() {
        CharResource[] roll = null;
        CharResource ret = null;
        CharResourceRoll charResourceRoll = this;
        synchronized (charResourceRoll) {
            if (this.m_nowLen <= 0) {
                ret = null;
            } else {
                roll = this.m_roll;
                int pnt = this.m_now - this.m_nowLen;
                if (pnt < 0) {
                    pnt = this.m_max + pnt;
                }
                ret = roll[pnt];
                roll[pnt] = null;
                --this.m_nowLen;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getMax() {
        int ret;
        CharResourceRoll charResourceRoll = this;
        synchronized (charResourceRoll) {
            ret = this.m_max;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getSize() {
        int ret;
        CharResourceRoll charResourceRoll = this;
        synchronized (charResourceRoll) {
            ret = this.m_nowLen;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAdd() {
        boolean ret;
        CharResourceRoll charResourceRoll = this;
        synchronized (charResourceRoll) {
            if (this.m_nowLen + this.m_addResCnt >= this.m_max) {
                boolean bl = false;
            }
            ret = true;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAddReservation() {
        boolean ret;
        CharResourceRoll charResourceRoll = this;
        synchronized (charResourceRoll) {
            ret = this.m_addResCnt > 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean addTo(boolean hlMode, char[] value) throws InputException {
        CharResource[] roll = null;
        if (value == null || value.length <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        boolean ret = false;
        CharResourceRoll charResourceRoll = this;
        synchronized (charResourceRoll) {
            if (this.m_nowLen + this.m_addResCnt >= this.m_max) {
                ret = false;
            } else {
                roll = this.m_roll;
                int next = this.getAddPoint(hlMode);
                if (roll[next] == null || roll[next].getAllSize() * 2 > Resource.getRenewRollValueCode(value.length * 2)) {
                    if (roll[next] != null) {
                        roll[next].clear();
                        roll[next] = null;
                    }
                    roll[next] = new CharResource(this.m_resType, value.length);
                } else {
                    roll[next].reset();
                }
                roll[next].setChars(0, value);
                ret = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean addTo(boolean hlMode, CharResource value) throws InputException {
        CharResource[] roll = null;
        if (value == null || !value.isUse() || value.size() <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        boolean ret = false;
        CharResourceRoll charResourceRoll = this;
        synchronized (charResourceRoll) {
            if (this.m_nowLen + this.m_addResCnt >= this.m_max) {
                ret = false;
            } else {
                roll = this.m_roll;
                int next = this.getAddPoint(hlMode);
                if (roll[next] != null) {
                    roll[next].clear();
                    roll[next] = null;
                }
                roll[next] = value;
                ret = true;
            }
        }
        return ret;
    }

    private final int getAddPoint(boolean hlMode) {
        int ret = this.m_now;
        if (hlMode) {
            if (this.m_nowLen > 0) {
                ret = this.m_now - this.m_nowLen;
                if (ret < 0) {
                    ret = this.m_max + ret;
                }
                if (--ret < 0) {
                    ret = this.m_max - 1;
                }
            } else {
                if (ret >= this.m_max) {
                    ret = 0;
                }
                this.m_now = ret + 1;
            }
            ++this.m_nowLen;
        } else {
            if (ret >= this.m_max) {
                ret = 0;
            }
            ++this.m_nowLen;
            this.m_now = ret + 1;
        }
        return ret;
    }
}

