/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.resource;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.resource.CharResource;
import com.JRcServer.commons.resource.CharResourceValue;
import com.JRcServer.commons.resource.Resource;
import com.JRcServer.commons.resource.ResourceRollState;
import com.JRcServer.commons.resource.ResourceType;
import com.JRcServer.commons.util.Roll;

public class CharResourceRollEx
implements Roll {
    private static final int DEF_SIZE = 32;
    private CharResourceValue[] m_roll = null;
    private ResourceType m_resType = null;
    private Class m_stateClass = null;
    private int m_max = 0;
    private int m_now = 0;
    private int m_nowLen = 0;
    private int m_addResCnt = 0;

    private CharResourceRollEx() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CharResourceRollEx(ResourceType resType, String name, int max) throws InputException {
        Object obj = null;
        Class<?> cls = null;
        CharResourceValue[] roll = null;
        if (resType == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            try {
                cls = Class.forName(name);
                obj = cls.newInstance();
                if (!(obj instanceof ResourceRollState)) {
                    throw new InputException("\u5bfe\u8c61\u540d[" + name + "]\u306f(com.JRcServer.commons.resource.ResourceRollState" + ")\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
                }
                max = max <= 32 ? 32 : max;
                roll = new CharResourceValue[max];
                int i = 0;
                while (true) {
                    block9: {
                        if (i < max) break block9;
                        this.m_roll = roll;
                        this.m_resType = resType;
                        this.m_stateClass = cls;
                        this.m_max = max;
                        this.m_now = 0;
                        this.m_nowLen = 0;
                        this.m_addResCnt = 0;
                        break;
                    }
                    roll[i] = new CharResourceValue();
                    roll[i].RES = null;
                    roll[i].STA = (ResourceRollState)cls.newInstance();
                    ++i;
                }
            }
            catch (InputException in) {
                this.destroy();
                throw in;
            }
            catch (Exception e) {
                this.destroy();
                throw new InputException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            cls = null;
            obj = null;
            roll = null;
            throw throwable;
        }
        {
            Object var9_12 = null;
            cls = null;
            obj = null;
        }
        roll = null;
    }

    protected final void finalize() throws Exception {
        this.destroy();
    }

    public final void destroy() {
        CharResourceValue[] roll = null;
        int len = this.m_max;
        if (len > 0) {
            roll = this.m_roll;
            int i = 0;
            while (i < len) {
                if (roll[i] != null) {
                    if (roll[i].RES != null) {
                        roll[i].RES.clear();
                    }
                    if (roll[i].STA != null) {
                        roll[i].STA.clear();
                    }
                }
                roll[i] = null;
                ++i;
            }
        }
        this.m_roll = null;
        this.m_resType = null;
        this.m_stateClass = null;
        this.m_max = 0;
        this.m_now = 0;
        this.m_nowLen = 0;
        this.m_addResCnt = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addReservationByON() {
        CharResourceRollEx charResourceRollEx = this;
        synchronized (charResourceRollEx) {
            ++this.m_addResCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addReservationByOFF() {
        CharResourceRollEx charResourceRollEx = this;
        synchronized (charResourceRollEx) {
            this.m_addResCnt = this.m_addResCnt <= 0 ? 0 : this.m_addResCnt - 1;
        }
    }

    public final boolean add(char[] value, ResourceRollState state) throws InputException {
        return this.addTo(false, value, state);
    }

    public final boolean add(CharResource value, ResourceRollState state) throws InputException {
        return this.addTo(false, value, state);
    }

    public final boolean addHead(char[] value, ResourceRollState state) throws InputException {
        return this.addTo(true, value, state);
    }

    public final boolean addHead(CharResource value, ResourceRollState state) throws InputException {
        return this.addTo(true, value, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final char[] getChars(ResourceRollState out) {
        boolean flg;
        CharResourceValue[] roll = null;
        char[] ret = null;
        try {
            this.checkResourceRollState(out);
            flg = true;
        }
        catch (Exception e) {
            ret = null;
            flg = false;
        }
        if (flg) {
            CharResourceRollEx charResourceRollEx = this;
            synchronized (charResourceRollEx) {
                if (this.m_nowLen <= 0) {
                    ret = null;
                } else {
                    roll = this.m_roll;
                    int pnt = this.m_now - this.m_nowLen;
                    if (pnt < 0) {
                        pnt = this.m_max + pnt;
                    }
                    ret = roll[pnt].RES.getChars(0);
                    out.set(roll[pnt].STA);
                    roll[pnt].STA.clear();
                    --this.m_nowLen;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CharResource getCharResource(ResourceRollState out) {
        boolean flg;
        CharResourceValue[] roll = null;
        CharResource ret = null;
        try {
            this.checkResourceRollState(out);
            flg = true;
        }
        catch (Exception e) {
            ret = null;
            flg = false;
        }
        if (flg) {
            CharResourceRollEx charResourceRollEx = this;
            synchronized (charResourceRollEx) {
                if (this.m_nowLen <= 0) {
                    ret = null;
                } else {
                    roll = this.m_roll;
                    int pnt = this.m_now - this.m_nowLen;
                    if (pnt < 0) {
                        pnt = this.m_max + pnt;
                    }
                    ret = roll[pnt].RES;
                    roll[pnt].RES = null;
                    out.set(roll[pnt].STA);
                    roll[pnt].STA.clear();
                    --this.m_nowLen;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getMax() {
        int ret;
        CharResourceRollEx charResourceRollEx = this;
        synchronized (charResourceRollEx) {
            ret = this.m_max;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getSize() {
        int ret;
        CharResourceRollEx charResourceRollEx = this;
        synchronized (charResourceRollEx) {
            ret = this.m_nowLen;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAdd() {
        boolean ret;
        CharResourceRollEx charResourceRollEx = this;
        synchronized (charResourceRollEx) {
            if (this.m_nowLen + this.m_addResCnt >= this.m_max) {
                boolean bl = false;
            }
            ret = true;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAddReservation() {
        boolean ret;
        CharResourceRollEx charResourceRollEx = this;
        synchronized (charResourceRollEx) {
            ret = this.m_addResCnt > 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean addTo(boolean hlMode, char[] value, ResourceRollState state) throws InputException {
        CharResourceValue[] roll = null;
        if (value == null || value.length <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.checkResourceRollState(state);
        boolean ret = false;
        CharResourceRollEx charResourceRollEx = this;
        synchronized (charResourceRollEx) {
            if (this.m_nowLen + this.m_addResCnt >= this.m_max) {
                ret = false;
            } else {
                int next = this.getAddPoint(hlMode);
                roll = this.m_roll;
                if (roll[next].RES == null || roll[next].RES.getAllSize() * 2 > Resource.getRenewRollValueCode(value.length * 2)) {
                    if (roll[next].RES != null) {
                        roll[next].RES.clear();
                        roll[next].RES = null;
                    }
                    roll[next].RES = new CharResource(this.m_resType, value.length);
                } else {
                    roll[next].RES.reset();
                }
                roll[next].RES.setChars(0, value);
                roll[next].STA.set(state);
                ret = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean addTo(boolean hlMode, CharResource value, ResourceRollState state) throws InputException {
        CharResourceValue[] roll = null;
        if (value == null || !value.isUse() || value.size() <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.checkResourceRollState(state);
        boolean ret = false;
        CharResourceRollEx charResourceRollEx = this;
        synchronized (charResourceRollEx) {
            if (this.m_nowLen + this.m_addResCnt >= this.m_max) {
                ret = false;
            } else {
                int next = this.getAddPoint(hlMode);
                roll = this.m_roll;
                if (roll[next].RES != null) {
                    roll[next].RES.clear();
                    roll[next].RES = null;
                }
                roll[next].RES = value;
                roll[next].STA.set(state);
                ret = true;
            }
        }
        return ret;
    }

    private final int getAddPoint(boolean hlMode) {
        int ret = this.m_now;
        if (hlMode) {
            if (this.m_nowLen > 0) {
                ret = this.m_now - this.m_nowLen;
                if (ret < 0) {
                    ret = this.m_max + ret;
                }
                if (--ret < 0) {
                    ret = this.m_max - 1;
                }
            } else {
                if (ret >= this.m_max) {
                    ret = 0;
                }
                this.m_now = ret + 1;
            }
            ++this.m_nowLen;
        } else {
            if (ret >= this.m_max) {
                ret = 0;
            }
            ++this.m_nowLen;
            this.m_now = ret + 1;
        }
        return ret;
    }

    private final void checkResourceRollState(ResourceRollState obj) throws InputException {
        if (obj == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!this.m_stateClass.isAssignableFrom(obj.getClass())) {
            throw new InputException("\u6307\u5b9a\u30b9\u30c6\u30fc\u30bf\u30b9\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f(" + this.m_stateClass.getName() + ")\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
        }
    }
}

