/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.resource;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.resource.BinResource;
import com.JRcServer.commons.resource.BufferedBinResource;
import com.JRcServer.commons.resource.Resource;
import java.math.BigDecimal;

public class ConvertResourceParam {
    private static final char ENDCHAR = '\u0000';
    private static final int BOOLEAN_TRUE_CD = 128;
    private static final int BOOLEAN_FALSE_CD = 8;
    public static final int LENGTH_BOOLEAN = 1;
    public static final int LENGTH_BYTE = 1;
    public static final int LENGTH_CHAR = 2;
    public static final int LENGTH_SHORT = 2;
    public static final int LENGTH_INT = 4;
    public static final int LENGTH_LONG = 8;

    private ConvertResourceParam() {
    }

    public static final void convertBoolean(BinResource out, int offset, boolean value) {
        out.set(offset, (byte)(value ? 128 : 8));
    }

    public static final void convertBoolean(BufferedBinResource out, int offset, boolean value) {
        out.set(offset, (byte)(value ? 128 : 8));
    }

    public static final boolean convertBoolean(int off, BinResource binary) throws InputException {
        boolean ret;
        try {
            ret = (binary.get(off) & 0xFF) == 128;
        }
        catch (NullPointerException nul) {
            throw new InputException(nul);
        }
        catch (IndexOutOfBoundsException io) {
            throw new InputException(io);
        }
        return ret;
    }

    public static final boolean convertBoolean(int off, BufferedBinResource binary) throws InputException {
        boolean ret;
        try {
            ret = (binary.get(off) & 0xFF) == 128;
        }
        catch (NullPointerException nul) {
            throw new InputException(nul);
        }
        catch (IndexOutOfBoundsException io) {
            throw new InputException(io);
        }
        return ret;
    }

    public static final void convertByte(BinResource out, int offset, byte value) {
        out.set(offset, value);
    }

    public static final void convertByte(BufferedBinResource out, int offset, byte value) {
        out.set(offset, value);
    }

    public static final byte convertByte(int off, BinResource binary) throws InputException {
        byte ret;
        try {
            ret = (byte)(binary.get(off) & 0xFF);
        }
        catch (NullPointerException nul) {
            throw new InputException(nul);
        }
        catch (IndexOutOfBoundsException io) {
            throw new InputException(io);
        }
        return ret;
    }

    public static final byte convertByte(int off, BufferedBinResource binary) throws InputException {
        byte ret;
        try {
            ret = (byte)(binary.get(off) & 0xFF);
        }
        catch (NullPointerException nul) {
            throw new InputException(nul);
        }
        catch (IndexOutOfBoundsException io) {
            throw new InputException(io);
        }
        return ret;
    }

    public static final void convertChar(BinResource out, int offset, char value) {
        byte[] bin = null;
        bin = new byte[]{(byte)(value & 0xFF), (byte)((value & 0xFF00) >> 8)};
        out.setBinary(offset, bin);
    }

    public static final void convertChar(BufferedBinResource out, int offset, char value) {
        out.set(offset, (byte)(value & 0xFF));
        out.set(offset + 1, (byte)((value & 0xFF00) >> 8));
    }

    public static final char convertChar(int off, BinResource binary) throws InputException {
        char ret;
        byte[] bin = null;
        try {
            bin = binary.getBinary(off, 2);
            ret = (char)(bin[0] & 0xFF | (bin[1] & 0xFF) << 8);
        }
        catch (NullPointerException nul) {
            throw new InputException(nul);
        }
        catch (IndexOutOfBoundsException io) {
            throw new InputException(io);
        }
        return ret;
    }

    public static final char convertChar(int off, BufferedBinResource binary) throws InputException {
        char ret;
        try {
            ret = (char)(binary.get(off) & 0xFF | (binary.get(off + 1) & 0xFF) << 8);
        }
        catch (NullPointerException nul) {
            throw new InputException(nul);
        }
        catch (IndexOutOfBoundsException io) {
            throw new InputException(io);
        }
        return ret;
    }

    public static final void convertShort(BinResource out, int offset, short value) {
        byte[] bin = null;
        bin = new byte[]{(byte)(value & 0xFF), (byte)((value & 0xFF00) >> 8)};
        out.setBinary(offset, bin);
    }

    public static final void convertShort(BufferedBinResource out, int offset, short value) {
        out.set(offset, (byte)(value & 0xFF));
        out.set(offset + 1, (byte)((value & 0xFF00) >> 8));
    }

    public static final short convertShort(int off, BinResource binary) throws InputException {
        short ret;
        byte[] bin = null;
        try {
            bin = binary.getBinary(off, 2);
            ret = (short)(bin[0] & 0xFF | (bin[1] & 0xFF) << 8);
        }
        catch (NullPointerException nul) {
            throw new InputException(nul);
        }
        catch (IndexOutOfBoundsException io) {
            throw new InputException(io);
        }
        return ret;
    }

    public static final short convertShort(int off, BufferedBinResource binary) throws InputException {
        short ret;
        try {
            ret = (short)(binary.get(off) & 0xFF | (binary.get(off + 1) & 0xFF) << 8);
        }
        catch (NullPointerException nul) {
            throw new InputException(nul);
        }
        catch (IndexOutOfBoundsException io) {
            throw new InputException(io);
        }
        return ret;
    }

    public static final void convertInt(BinResource out, int offset, int value) {
        byte[] bin = null;
        bin = new byte[]{(byte)(value & 0xFF), (byte)((value & 0xFF00) >> 8), (byte)((value & 0xFF0000) >> 16), (byte)((value & 0xFF000000) >> 24)};
        out.setBinary(offset, bin);
    }

    public static final void convertInt(BufferedBinResource out, int offset, int value) {
        out.set(offset, (byte)(value & 0xFF));
        out.set(offset + 1, (byte)((value & 0xFF00) >> 8));
        out.set(offset + 2, (byte)((value & 0xFF0000) >> 16));
        out.set(offset + 3, (byte)((value & 0xFF000000) >> 24));
    }

    public static final int convertInt(int off, BinResource binary) throws InputException {
        int ret;
        byte[] bin = null;
        try {
            bin = binary.getBinary(off, 4);
            ret = bin[0] & 0xFF | (bin[1] & 0xFF) << 8 | (bin[2] & 0xFF) << 16 | (bin[3] & 0xFF) << 24;
        }
        catch (NullPointerException nul) {
            throw new InputException(nul);
        }
        catch (IndexOutOfBoundsException io) {
            throw new InputException(io);
        }
        return ret;
    }

    public static final int convertInt(int off, BufferedBinResource binary) throws InputException {
        short ret;
        try {
            ret = (short)(binary.get(off) & 0xFF | (binary.get(off + 1) & 0xFF) << 8 | (binary.get(off + 2) & 0xFF) << 16 | (binary.get(off + 3) & 0xFF) << 24);
        }
        catch (NullPointerException nul) {
            throw new InputException(nul);
        }
        catch (IndexOutOfBoundsException io) {
            throw new InputException(io);
        }
        return ret;
    }

    public static final void convertLong(BinResource out, int offset, long value) {
        byte[] bin = null;
        bin = new byte[]{(byte)(value & 0xFFL), (byte)((value & 0xFF00L) >> 8), (byte)((value & 0xFF0000L) >> 16), (byte)((value & 0xFF000000L) >> 24), (byte)((value & 0xFF00000000L) >> 32), (byte)((value & 0xFF0000000000L) >> 40), (byte)((value & 0xFF000000000000L) >> 48), (byte)((value & 0xFF00000000000000L) >> 56)};
        out.setBinary(offset, bin);
    }

    public static final void convertLong(BufferedBinResource out, int offset, long value) {
        out.set(offset, (byte)(value & 0xFFL));
        out.set(offset + 1, (byte)((value & 0xFF00L) >> 8));
        out.set(offset + 2, (byte)((value & 0xFF0000L) >> 16));
        out.set(offset + 3, (byte)((value & 0xFF000000L) >> 24));
        out.set(offset + 4, (byte)((value & 0xFF00000000L) >> 32));
        out.set(offset + 5, (byte)((value & 0xFF0000000000L) >> 40));
        out.set(offset + 6, (byte)((value & 0xFF000000000000L) >> 48));
        out.set(offset + 7, (byte)((value & 0xFF00000000000000L) >> 56));
    }

    public static final long convertLong(int off, BinResource binary) throws InputException {
        long ret;
        byte[] bin = null;
        try {
            bin = binary.getBinary(off, 8);
            ret = (long)bin[0] & 0xFFL | ((long)bin[1] & 0xFFL) << 8 | ((long)bin[2] & 0xFFL) << 16 | ((long)bin[3] & 0xFFL) << 24 | ((long)bin[4] & 0xFFL) << 32 | ((long)bin[5] & 0xFFL) << 40 | ((long)bin[6] & 0xFFL) << 48 | ((long)bin[7] & 0xFFL) << 56;
        }
        catch (NullPointerException nul) {
            throw new InputException(nul);
        }
        catch (IndexOutOfBoundsException io) {
            throw new InputException(io);
        }
        return ret;
    }

    public static final long convertLong(int off, BufferedBinResource binary) throws InputException {
        long ret;
        try {
            ret = (long)binary.get(off) & 0xFFL | ((long)binary.get(off + 1) & 0xFFL) << 8 | ((long)binary.get(off + 2) & 0xFFL) << 16 | ((long)binary.get(off + 3) & 0xFFL) << 24 | ((long)binary.get(off + 4) & 0xFFL) << 32 | ((long)binary.get(off + 5) & 0xFFL) << 40 | ((long)binary.get(off + 6) & 0xFFL) << 48 | ((long)binary.get(off + 7) & 0xFFL) << 56;
        }
        catch (NullPointerException nul) {
            throw new InputException(nul);
        }
        catch (IndexOutOfBoundsException io) {
            throw new InputException(io);
        }
        return ret;
    }

    public static final int convertFloat(BinResource out, int offset, float value) {
        return ConvertResourceParam.convertFloatStringByBinary(out, offset, String.valueOf(value));
    }

    public static final int convertFloat(BufferedBinResource out, int offset, float value) {
        return ConvertResourceParam.convertFloatStringByBinary(out, offset, String.valueOf(value));
    }

    public static final float convertFloat(int off, int length, BinResource binary) throws InputException {
        return Float.parseFloat(ConvertResourceParam.convertFloatBinaryByString(off, binary));
    }

    public static final float convertFloat(int off, int length, BufferedBinResource binary) throws InputException {
        return Float.parseFloat(ConvertResourceParam.convertFloatBinaryByString(off, binary));
    }

    public static final int convertDouble(BinResource out, int offset, double value) {
        return ConvertResourceParam.convertFloatStringByBinary(out, offset, String.valueOf(value));
    }

    public static final int convertDouble(BufferedBinResource out, int offset, double value) {
        return ConvertResourceParam.convertFloatStringByBinary(out, offset, String.valueOf(value));
    }

    public static final double convertDouble(int off, int length, BinResource binary) throws InputException {
        return Double.parseDouble(ConvertResourceParam.convertFloatBinaryByString(off, binary));
    }

    public static final double convertDouble(int off, int length, BufferedBinResource binary) throws InputException {
        return Double.parseDouble(ConvertResourceParam.convertFloatBinaryByString(off, binary));
    }

    public static final int convertDecimal(BinResource out, int offset, BigDecimal value) {
        return ConvertResourceParam.convertFloatStringByBinary(out, offset, value.toString());
    }

    public static final int convertDecimal(BufferedBinResource out, int offset, BigDecimal value) {
        return ConvertResourceParam.convertFloatStringByBinary(out, offset, value.toString());
    }

    public static final BigDecimal convertDecimal(int off, int length, BinResource binary) throws InputException {
        return new BigDecimal(ConvertResourceParam.convertFloatBinaryByString(off, binary));
    }

    public static final BigDecimal convertDecimal(int off, int length, BufferedBinResource binary) throws InputException {
        return new BigDecimal(ConvertResourceParam.convertFloatBinaryByString(off, binary));
    }

    public static final int convertString(BinResource out, int offset, String value, String charset) {
        int ret;
        try {
            ret = Resource.convertStringByBinResource(out, value, offset, value.length(), charset);
        }
        catch (Exception t) {
            ret = 0;
        }
        return ret;
    }

    public static final int convertString(BufferedBinResource out, int offset, String value, String charset) {
        int ret;
        try {
            ret = Resource.convertStringByBinResource(out.getResource(), value, offset, value.length(), charset);
        }
        catch (Exception t) {
            ret = 0;
        }
        return ret;
    }

    public static final String convertString(int off, int length, BinResource binary, String charset) throws InputException {
        String ret = null;
        try {
            ret = Resource.convertBinResourceByString(binary, off, length, charset);
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception e) {
            throw new InputException(e);
        }
        return ret;
    }

    public static final String convertString(int off, int length, BufferedBinResource binary, String charset) throws InputException {
        String ret = null;
        try {
            ret = Resource.convertBinResourceByString(binary.getResource(), off, length, charset);
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception e) {
            throw new InputException(e);
        }
        return ret;
    }

    private static final int convertFloatStringByBinary(BinResource out, int off, String data) {
        byte[] bin = null;
        int len = data.length();
        int ret = (len + 1) / 2;
        bin = new byte[ret + 2];
        bin[0] = (byte)(ret & 0xFF);
        bin[1] = (byte)((ret & 0xFF00) >> 8);
        int i = 0;
        int j = 2;
        while (i < len) {
            byte dat = ConvertResourceParam.cnvCharByNumBin(data.charAt(i));
            if ((i & 1) == 0) {
                bin[j] = (byte)(dat & 0xF);
            } else {
                int n = j++;
                bin[n] = (byte)(bin[n] | (byte)((dat & 0xF) << 4));
            }
            ++i;
        }
        out.setBinary(off, bin);
        return ret;
    }

    private static final int convertFloatStringByBinary(BufferedBinResource out, int off, String data) {
        int len = data.length();
        int ret = (len + 1) / 2;
        out.set(off, (byte)(ret & 0xFF));
        out.set(off + 1, (byte)((ret & 0xFF00) >> 8));
        int i = 0;
        int j = off + 2;
        int cd = -1;
        while (i < len) {
            byte dat = ConvertResourceParam.cnvCharByNumBin(data.charAt(i));
            if ((i & 1) == 0) {
                cd = dat & 0xF;
            } else {
                out.set(j, cd |= (dat & 0xF) << 4);
                cd = -1;
                ++j;
            }
            ++i;
        }
        if (cd != -1) {
            out.set(off + 2 + len - 1, cd);
        }
        return ret;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String convertFloatBinaryByString(int off, BinResource binary) throws InputException {
        byte[] bin = null;
        StringBuffer buf = null;
        String ret = null;
        if (binary == null) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        if (!binary.isUse()) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        if (binary.size() <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        buf = new StringBuffer();
        try {
            try {
                char dat;
                bin = binary.getBinary(off, 2);
                int len = bin[0] & 0xFF | (bin[1] & 0xFF) << 8;
                bin = binary.getBinary(off + 2, len);
                int i = 0;
                while (i < len && (dat = ConvertResourceParam.cnvNumBinByChar((byte)(bin[i] & 0xF))) != '\u0000') {
                    buf.append(dat);
                    dat = ConvertResourceParam.cnvNumBinByChar((byte)((bin[i] & 0xF0) >> 4));
                    if (dat == '\u0000') break;
                    buf.append(dat);
                    ++i;
                }
                ret = buf.toString();
            }
            catch (Exception e) {
                throw new InputException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            buf = null;
            bin = null;
            throw throwable;
        }
        {
            Object var9_11 = null;
            buf = null;
        }
        bin = null;
        return ret;
    }

    /*
     * Exception decompiling
     */
    public static final String convertFloatBinaryByString(int off, BufferedBinResource binary) throws InputException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 183->186)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final byte cnvCharByNumBin(char cd) {
        byte ret;
        switch (cd) {
            case '0': {
                ret = 1;
                break;
            }
            case '1': {
                ret = 2;
                break;
            }
            case '2': {
                ret = 3;
                break;
            }
            case '3': {
                ret = 4;
                break;
            }
            case '4': {
                ret = 5;
                break;
            }
            case '5': {
                ret = 6;
                break;
            }
            case '6': {
                ret = 7;
                break;
            }
            case '7': {
                ret = 8;
                break;
            }
            case '8': {
                ret = 9;
                break;
            }
            case '9': {
                ret = 10;
                break;
            }
            case '+': {
                ret = 11;
                break;
            }
            case '-': {
                ret = 12;
                break;
            }
            case '.': {
                ret = 13;
                break;
            }
            default: {
                ret = 15;
            }
        }
        return ret;
    }

    private static final char cnvNumBinByChar(byte cd) {
        char ret;
        switch (cd) {
            case 0: {
                ret = '\u0000';
                break;
            }
            case 1: {
                ret = '0';
                break;
            }
            case 2: {
                ret = '1';
                break;
            }
            case 3: {
                ret = '2';
                break;
            }
            case 4: {
                ret = '3';
                break;
            }
            case 5: {
                ret = '4';
                break;
            }
            case 6: {
                ret = '5';
                break;
            }
            case 7: {
                ret = '6';
                break;
            }
            case 8: {
                ret = '7';
                break;
            }
            case 9: {
                ret = '8';
                break;
            }
            case 10: {
                ret = '9';
                break;
            }
            case 11: {
                ret = '+';
                break;
            }
            case 12: {
                ret = '-';
                break;
            }
            case 13: {
                ret = '.';
                break;
            }
            default: {
                ret = '?';
            }
        }
        return ret;
    }
}

