/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.resource;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.resource.BinCacheResource;
import com.JRcServer.commons.resource.BinFileResource;
import com.JRcServer.commons.resource.BinMemoryResource;
import com.JRcServer.commons.resource.BinResource;
import com.JRcServer.commons.resource.BinResourceInputStream;
import com.JRcServer.commons.resource.BinResourceOutputStream;
import com.JRcServer.commons.resource.CharResource;
import com.JRcServer.commons.resource.ResourceType;
import com.JRcServer.commons.resource.cache.CacheManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class Resource {
    public static final Object SYNC = new Object();
    private static final int BUF_LEN = 1024;

    private Resource() {
    }

    public static final BinResource createBinResource(ResourceType rs, int size) {
        BinResource ret = null;
        try {
            ret = rs == null ? (size <= 0 ? new BinMemoryResource(1) : new BinMemoryResource(size)) : Resource.createBinResource(rs.getType(), rs.getTmpDir(), rs.getCacheID(), size);
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public static final BinResource createBinResource(int type, String tmpDir, int size) {
        return Resource.createBinResource(type, tmpDir, -1L, size);
    }

    public static final BinResource createBinResource(int type, String tmpDir, long cacheID, int size) {
        BinResource ret = null;
        size = size <= 0 ? 1 : size;
        try {
            switch (type) {
                case 1: {
                    ret = new BinMemoryResource(size);
                    break;
                }
                case 2: {
                    if (tmpDir != null) {
                        ret = new BinFileResource(tmpDir, size);
                        break;
                    }
                    ret = new BinMemoryResource(size);
                    break;
                }
                case 3: {
                    if (cacheID >= 0L && CacheManager.get(cacheID) != null) {
                        ret = new BinCacheResource(size, cacheID);
                        break;
                    }
                    ret = new BinMemoryResource(size);
                    break;
                }
                default: {
                    ret = new BinMemoryResource(size);
                }
            }
            ret.reset();
        }
        catch (Exception e) {
            try {
                ret = size <= 0 ? new BinMemoryResource(1) : new BinMemoryResource(size);
            }
            catch (Exception ee) {
                ret = null;
            }
        }
        return ret;
    }

    public static final BinResource createBinResource(ResourceType rs, byte[] bin) {
        BinResource ret = null;
        try {
            ret = rs == null ? (bin == null || bin.length <= 0 ? new BinMemoryResource(1) : new BinMemoryResource(bin)) : Resource.createBinResource(rs.getType(), rs.getTmpDir(), rs.getCacheID(), bin);
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public static final BinResource createBinResource(int type, String tmpDir, byte[] bin) {
        return Resource.createBinResource(type, tmpDir, -1L, bin);
    }

    public static final BinResource createBinResource(int type, String tmpDir, long cacheID, byte[] bin) {
        BinResource ret = null;
        try {
            switch (type) {
                case 1: {
                    ret = bin == null || bin.length <= 0 ? new BinMemoryResource(1) : new BinMemoryResource(bin);
                    break;
                }
                case 2: {
                    if (tmpDir != null) {
                        if (bin != null && bin.length > 0) {
                            ret = new BinFileResource(tmpDir, bin.length);
                            ret.setBinary(0, bin);
                            break;
                        }
                        ret = new BinFileResource(tmpDir, 1);
                        break;
                    }
                    ret = bin == null || bin.length <= 0 ? new BinMemoryResource(1) : new BinMemoryResource(bin);
                    break;
                }
                case 3: {
                    if (cacheID >= 0L && CacheManager.get(cacheID) != null) {
                        if (bin != null && bin.length > 0) {
                            ret = new BinCacheResource(bin.length, cacheID);
                            ret.setBinary(0, bin);
                            break;
                        }
                        ret = new BinCacheResource(1, cacheID);
                        break;
                    }
                    ret = bin == null || bin.length <= 0 ? new BinMemoryResource(1) : new BinMemoryResource(bin);
                    break;
                }
                default: {
                    ret = bin == null || bin.length <= 0 ? new BinMemoryResource(1) : new BinMemoryResource(bin);
                    break;
                }
            }
        }
        catch (Exception e) {
            try {
                ret = bin == null || bin.length <= 0 ? new BinMemoryResource(1) : new BinMemoryResource(bin);
            }
            catch (Exception ee) {
                ret = null;
            }
        }
        return ret;
    }

    public static final void arraycopy(BinResource src, int src_pnt, BinResource dst, int dst_pnt, int len) throws ArrayIndexOutOfBoundsException {
        try {
            dst.setBinary(dst_pnt, src, src_pnt, len);
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw ai;
        }
        catch (Exception e) {
            throw new ArrayIndexOutOfBoundsException(e.getMessage());
        }
    }

    public static final void arraycopy(byte[] src, int src_pnt, BinResource dst, int dst_pnt, int len) throws ArrayIndexOutOfBoundsException {
        try {
            dst.setBinary(dst_pnt, src, src_pnt, len);
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            throw ai;
        }
        catch (Exception e) {
            throw new ArrayIndexOutOfBoundsException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void arraycopy(BinResource src, int src_pnt, byte[] dst, int dst_pnt, int len) throws ArrayIndexOutOfBoundsException {
        BinMemoryResource b = null;
        try {
            try {
                b = new BinMemoryResource(dst);
                b.setBinary(dst_pnt, src, src_pnt, len);
            }
            catch (ArrayIndexOutOfBoundsException ai) {
                throw ai;
            }
            catch (Exception e) {
                throw new ArrayIndexOutOfBoundsException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (b != null) {
                b.clear();
            }
            b = null;
            throw throwable;
        }
        {
            Object var7_10 = null;
            if (b == null) return;
            b.clear();
            return;
        }
    }

    public static final String convertBinResourceByString(BinResource bin) throws InputException, UnsupportedEncodingException {
        return Resource.convertBinResourceByString(bin, 0, -1, null);
    }

    public static final String convertBinResourceByString(BinResource bin, String charset) throws InputException, UnsupportedEncodingException {
        return Resource.convertBinResourceByString(bin, 0, -1, charset);
    }

    public static final String convertBinResourceByString(BinResource bin, int offset, int length) throws InputException, UnsupportedEncodingException {
        return Resource.convertBinResourceByString(bin, offset, length, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String convertBinResourceByString(BinResource bin, int offset, int length, String charset) throws InputException, UnsupportedEncodingException {
        block14: {
            tmp = null;
            br = null;
            buf = null;
            ret = null;
            if (bin == null) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            if (bin.isUse() == false) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            blen = bin.size();
            if (blen <= 0) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            if (offset < 0) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            if (length != -1 && length < 0) {
                throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            }
            charset = charset == null || charset.length() <= 0 ? null : charset;
            length = length == -1 ? blen - offset : length;
            try {
                try {
                    br = charset == null ? new BufferedReader(new InputStreamReader(new BinResourceInputStream(false, bin, offset, length))) : new BufferedReader(new InputStreamReader((InputStream)new BinResourceInputStream(false, bin, offset, length), charset));
                    buf = new StringBuffer();
                    tmp = new char[1024];
                    while (true) {
                        block13: {
                            if ((len = br.read(tmp, 0, 1024)) >= 0) break block13;
                            ret = buf.toString();
                            break;
                        }
                        buf.append(tmp, 0, len);
                    }
                }
                catch (InputException in) {
                    throw in;
                }
                catch (UnsupportedEncodingException ue) {
                    throw ue;
                }
                catch (Exception e) {
                    ret = null;
                }
            }
            catch (Throwable var12_13) {
                var11_14 = null;
                try {
                    br.close();
                }
                catch (Exception var13_16) {
                    // empty catch block
                }
                buf = null;
                tmp = null;
                throw var12_13;
            }
            {
                var11_15 = null;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 241->249)] { 
lbl48:
            // 1 sources

            br.close();
            break block14;
lbl50:
            // 1 sources

            catch (Exception var13_17) {
                // empty catch block
            }
        }
        buf = null;
        tmp = null;
        return ret;
    }

    public static final int convertStringByBinResource(BinResource out, String str) throws InputException, UnsupportedEncodingException {
        return Resource.convertStringByBinResource(out, 0, str, 0, -1, null);
    }

    public static final int convertStringByBinResource(BinResource out, String str, String charset) throws InputException, UnsupportedEncodingException {
        return Resource.convertStringByBinResource(out, 0, str, 0, -1, charset);
    }

    public static final int convertStringByBinResource(BinResource out, String str, int offset, int length) throws InputException, UnsupportedEncodingException {
        return Resource.convertStringByBinResource(out, 0, str, offset, length, null);
    }

    public static final int convertStringByBinResource(BinResource out, String str, int offset, int length, String charset) throws InputException, UnsupportedEncodingException {
        return Resource.convertStringByBinResource(out, 0, str, offset, length, null);
    }

    public static final int convertStringByBinResource(BinResource out, int no, String str) throws InputException, UnsupportedEncodingException {
        return Resource.convertStringByBinResource(out, no, str, 0, -1, null);
    }

    public static final int convertStringByBinResource(BinResource out, int no, String str, String charset) throws InputException, UnsupportedEncodingException {
        return Resource.convertStringByBinResource(out, no, str, 0, -1, charset);
    }

    public static final int convertStringByBinResource(BinResource out, int no, String str, int offset, int length) throws InputException, UnsupportedEncodingException {
        return Resource.convertStringByBinResource(out, no, str, offset, length, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final int convertStringByBinResource(BinResource out, int no, String str, int offset, int length, String charset) throws InputException, UnsupportedEncodingException {
        block14: {
            bw = null;
            if (out == null) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            if (out.isUse() == false) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            if (str == null) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            slen = str.length();
            if (slen <= 0) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            if (offset < 0) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            if (length != -1 && length < 0) {
                throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            }
            no = no <= 0 ? 0 : no;
            charset = charset == null || charset.length() <= 0 ? null : charset;
            length = length == -1 ? slen - offset : length;
            try {
                try {
                    bw = charset == null ? new BufferedWriter(new OutputStreamWriter(new BinResourceOutputStream(false, out, no))) : new BufferedWriter(new OutputStreamWriter((OutputStream)new BinResourceOutputStream(false, out, no), charset));
                    bw.write(str, offset, length);
                    ret = out.size();
                }
                catch (InputException in) {
                    if (out == null) throw in;
                    out.clear();
                    throw in;
                }
                catch (UnsupportedEncodingException ue) {
                    if (out == null) throw ue;
                    out.clear();
                    throw ue;
                }
                catch (Exception e) {
                    if (out != null) {
                        out.clear();
                    }
                    ret = -1;
                }
            }
            catch (Throwable var12_12) {
                var11_13 = null;
                try {
                    bw.close();
                }
                catch (Exception var13_15) {
                    // empty catch block
                }
                bw = null;
                throw var12_12;
            }
            {
                var11_14 = null;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 243->251)] { 
lbl45:
            // 1 sources

            bw.close();
            break block14;
lbl47:
            // 1 sources

            catch (Exception var13_16) {
                // empty catch block
            }
        }
        bw = null;
        if (ret <= 0) {
            return -1;
        }
        v0 = ret;
        return v0;
    }

    public static final int convertBinResourceByCharResource(CharResource out, BinResource bin) throws InputException, UnsupportedEncodingException {
        return Resource.convertBinResourceByCharResource(out, bin, 0, -1, null);
    }

    public static final int convertBinResourceByCharResource(CharResource out, BinResource bin, String charset) throws InputException, UnsupportedEncodingException {
        return Resource.convertBinResourceByCharResource(out, bin, 0, -1, charset);
    }

    public static final int convertBinResourceByCharResource(CharResource out, BinResource bin, int offset, int length) throws InputException, UnsupportedEncodingException {
        return Resource.convertBinResourceByCharResource(out, bin, offset, length, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final int convertBinResourceByCharResource(CharResource out, BinResource bin, int offset, int length, String charset) throws InputException, UnsupportedEncodingException {
        block16: {
            tmp = null;
            br = null;
            if (out == null) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            if (out.isUse() == false) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            if (bin == null) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            if (bin.isUse() == false) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            blen = bin.size();
            if (blen <= 0) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            if (offset < 0) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            if (length != -1 && length < 0) {
                throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            }
            out.reset();
            charset = charset == null || charset.length() <= 0 ? null : charset;
            length = length == -1 ? blen - offset : length;
            try {
                try {
                    br = charset == null ? new BufferedReader(new InputStreamReader(new BinResourceInputStream(false, bin, offset, length))) : new BufferedReader(new InputStreamReader((InputStream)new BinResourceInputStream(false, bin, offset, length), charset));
                    tmp = new char[1024];
                    pnt = 0;
                    while (true) {
                        block15: {
                            if ((len = br.read(tmp, 0, 1024)) >= 0) break block15;
                            ret = out.size();
                            break;
                        }
                        out.setChars(pnt, tmp, 0, len);
                        pnt += len;
                    }
                }
                catch (InputException in) {
                    if (out == null) throw in;
                    out.clear();
                    throw in;
                }
                catch (UnsupportedEncodingException ue) {
                    if (out == null) throw ue;
                    out.clear();
                    throw ue;
                }
                catch (Exception e) {
                    if (out != null) {
                        out.clear();
                    }
                    ret = -1;
                }
            }
            catch (Throwable var13_14) {
                var12_15 = null;
                try {
                    br.close();
                }
                catch (Exception var14_17) {
                    // empty catch block
                }
                tmp = null;
                throw var13_14;
            }
            {
                var12_16 = null;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 281->289)] { 
lbl55:
            // 1 sources

            br.close();
            break block16;
lbl57:
            // 1 sources

            catch (Exception var14_18) {
                // empty catch block
            }
        }
        tmp = null;
        if (ret <= 0) {
            return -1;
        }
        v0 = ret;
        return v0;
    }

    public static final int convertCharResourceByBinResource(BinResource out, CharResource chr) throws InputException, UnsupportedEncodingException {
        return Resource.convertCharResourceByBinResource(out, chr, 0, -1, null);
    }

    public static final int convertCharResourceByBinResource(BinResource out, CharResource chr, String charset) throws InputException, UnsupportedEncodingException {
        return Resource.convertCharResourceByBinResource(out, chr, 0, -1, charset);
    }

    public static final int convertCharResourceByBinResource(BinResource out, CharResource chr, int offset, int length) throws InputException, UnsupportedEncodingException {
        return Resource.convertCharResourceByBinResource(out, chr, offset, length, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final int convertCharResourceByBinResource(BinResource out, CharResource chr, int offset, int length, String charset) throws InputException, UnsupportedEncodingException {
        block15: {
            tmp = null;
            bw = null;
            if (out == null) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            if (out.isUse() == false) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            if (chr == null) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            if (chr.isUse() == false) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            slen = chr.size();
            if (slen <= 0) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            if (offset < 0) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            if (length != -1 && length < 0) {
                throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            }
            out.reset();
            charset = charset == null || charset.length() <= 0 ? null : charset;
            try {
                try {
                    bw = charset == null ? new BufferedWriter(new OutputStreamWriter(new BinResourceOutputStream(false, out))) : new BufferedWriter(new OutputStreamWriter((OutputStream)new BinResourceOutputStream(false, out), charset));
                    tmp = new char[1024];
                    pnt = offset;
                    endLen = false;
                    for (length = length == -1 ? slen - offset : length; length > 0 && (readLen = chr.getChars(tmp, pnt, 0, 1024)) > 0; length -= readLen, pnt += readLen) {
                        bw.write(tmp, 0, readLen >= length ? length : readLen);
                    }
                    ret = out.size();
                }
                catch (InputException in) {
                    if (out == null) throw in;
                    out.clear();
                    throw in;
                }
                catch (UnsupportedEncodingException ue) {
                    if (out == null) throw ue;
                    out.clear();
                    throw ue;
                }
                catch (Exception e) {
                    if (out != null) {
                        out.clear();
                    }
                    ret = -1;
                }
            }
            catch (Throwable var15_15) {
                var14_16 = null;
                try {
                    bw.close();
                }
                catch (Exception var16_18) {
                    // empty catch block
                }
                bw = null;
                tmp = null;
                throw var15_15;
            }
            {
                var14_17 = null;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 312->320)] { 
lbl52:
            // 1 sources

            bw.close();
            break block15;
lbl54:
            // 1 sources

            catch (Exception var16_19) {
                // empty catch block
            }
        }
        bw = null;
        tmp = null;
        if (ret <= 0) {
            return -1;
        }
        v0 = ret;
        return v0;
    }

    public static final int getRenewRollValueCode(int length) {
        return (((length & 0xFFFFF000) >> 12) + (((length = (int)((double)length * 2.48)) & 0xC) != 0 ? 1 : 0)) * 4096;
    }
}

