/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.resource;

import com.JRcServer.commons.io.IOCom;
import com.JRcServer.commons.resource.cache.CacheManager;
import com.JRcServer.commons.serialize.SerializeUtil;
import java.io.Serializable;

public class ResourceType
implements Serializable {
    private static final long serialVersionUID;
    public static final int RESOURCE_TYPE_MEMORY = 1;
    public static final int RESOURCE_TYPE_FILE = 2;
    public static final int RESOURCE_TYPE_CACHE = 3;
    private int m_type = 0;
    private String m_tmpDir = null;
    private long m_cacheID = -1L;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.JRcServer.commons.resource.ResourceType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        serialVersionUID = SerializeUtil.serialVersionUID(clazz.getName());
    }

    public ResourceType() {
        this.m_type = 1;
        this.m_tmpDir = null;
        this.m_cacheID = -1L;
    }

    public ResourceType(int type, String dir) {
        this(type, dir, -1L);
    }

    public ResourceType(int type, long cacheID) {
        this(type, null, cacheID);
    }

    public ResourceType(int type, String dir, long cacheID) {
        if (type != 1 && type != 2 && type != 3) {
            type = 1;
        }
        if (type == 1) {
            dir = null;
            cacheID = -1L;
        } else if (type == 2) {
            cacheID = -1L;
            if (dir != null) {
                try {
                    IOCom.mkdirs(dir);
                }
                catch (Exception e) {
                    dir = null;
                    type = 1;
                }
            } else {
                dir = null;
                type = 1;
            }
        } else if (type == 3) {
            dir = null;
            if (CacheManager.get(cacheID) == null) {
                type = 1;
                cacheID = -1L;
            }
        }
        this.m_type = type;
        this.m_tmpDir = dir;
        this.m_cacheID = cacheID;
    }

    public final int getType() {
        return this.m_type;
    }

    public final String getTmpDir() {
        return this.m_tmpDir;
    }

    public final long getCacheID() {
        return this.m_cacheID;
    }
}

