/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.resource.cache;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.resource.cache.Cache;
import com.JRcServer.commons.resource.cache.NotUseSectorException;
import com.JRcServer.commons.resource.cache.SectorIO;

class CacheImple
implements Cache {
    private int id = -1;
    private SectorIO sectorIO = null;

    private CacheImple() {
    }

    public CacheImple(int id, SectorIO sectorIO) throws InputException {
        if (id < 0 || sectorIO == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.id = id;
        this.sectorIO = sectorIO;
    }

    protected final void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void close() {
        if (this.sectorIO != null) {
            try {
                this.sectorIO.releaseID(this.id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.id = -1;
        this.sectorIO = null;
    }

    public synchronized void reset() {
        this.sectorIO.setUseIDByDataSize(this.id, 0);
    }

    public synchronized byte[] read(int seek) throws AccessException {
        byte[] ret = null;
        int len = this.sectorIO.getUseIDByDataSize(this.id);
        if (len <= 0 || len - seek <= 0) {
            return null;
        }
        ret = new byte[len - seek];
        this.read(ret, seek, 0, len);
        return ret;
    }

    public synchronized int read(byte[] out, int seek) throws AccessException {
        if (out == null || out.length <= 0) {
            return -1;
        }
        return this.read(out, seek, 0, out.length);
    }

    public synchronized int read(byte[] out, int seek, int offset) throws AccessException {
        if (out == null || out.length <= 0) {
            return -1;
        }
        return this.read(out, seek, offset, out.length);
    }

    public synchronized int read(byte[] out, int seek, int offset, int length) throws AccessException {
        int binLen;
        int ret = -1;
        if (out == null || (binLen = out.length) <= 0 || offset >= binLen) {
            return -1;
        }
        seek = seek <= 0 ? 0 : seek;
        length = offset + length >= binLen ? binLen - offset : length;
        int scLen = this.sectorIO.getUseIDByDataSize(this.id);
        if ((length = seek + length >= scLen ? scLen - seek : length) <= 0) {
            return -1;
        }
        ret = length;
        int i = (seek & 0xFFFFF000) >> 12;
        int len = ((length + seek & 0xFFF) != 0 ? 1 : 0) + ((length + seek & 0xFFFFF000) >> 12);
        int binOff = seek & 0xFFF;
        binLen = length >= 4096 ? 4096 : length;
        while (i < len) {
            binLen = this.sectorIO.readData(out, this.id, i, binOff, offset, binLen);
            offset += binLen;
            binLen = (length -= binLen) >= 4096 ? 4096 : length;
            ++i;
            binOff = 0;
        }
        return ret;
    }

    public synchronized int write(byte[] in, int seek) throws NotUseSectorException, AccessException {
        if (in == null || in.length <= 0) {
            return -1;
        }
        return this.write(in, seek, 0, in.length);
    }

    public synchronized int write(byte[] in, int seek, int offset) throws NotUseSectorException, AccessException {
        if (in == null || in.length <= 0) {
            return -1;
        }
        return this.write(in, seek, offset, in.length);
    }

    public synchronized int write(byte[] in, int seek, int offset, int length) throws NotUseSectorException, AccessException {
        int binLen;
        int ret = -1;
        if (in == null || (binLen = in.length) <= 0 || offset >= binLen) {
            return -1;
        }
        seek = seek <= 0 ? 0 : seek;
        length = offset + length >= binLen ? binLen - offset : length;
        int newLen = ((seek + length & 0xFFF) != 0 ? 1 : 0) + ((seek + length & 0xFFFFF000) >> 12);
        if ((newLen -= this.sectorIO.getReservationSectorSize(this.id)) > 0) {
            try {
                if (this.sectorIO.reservationSector(this.id, newLen) <= 0) {
                    throw new NotUseSectorException("\u7a7a\u304d\u30bb\u30af\u30bf\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                }
            }
            catch (NotUseSectorException ne) {
                throw ne;
            }
            catch (Exception e) {
                throw new AccessException(e);
            }
        }
        int scLen = this.sectorIO.getUseIDByDataSize(this.id);
        ret = length;
        int i = (seek & 0xFFFFF000) >> 12;
        int len = ((length + seek & 0xFFF) != 0 ? 1 : 0) + ((length + seek & 0xFFFFF000) >> 12);
        int binOff = seek & 0xFFF;
        binLen = length >= 4096 ? 4096 : length;
        while (i < len) {
            binLen = this.sectorIO.writeData(in, this.id, i, binOff, offset, binLen);
            offset += binLen;
            binLen = (length -= binLen) >= 4096 ? 4096 : length;
            ++i;
            binOff = 0;
        }
        this.sectorIO.setUseIDByDataSize(this.id, scLen <= ret + seek ? ret + seek : scLen);
        return ret;
    }

    public synchronized int getLength() {
        return this.sectorIO.getUseIDByDataSize(this.id);
    }

    public synchronized int getSector() {
        return this.sectorIO.getReservationSectorSize(this.id);
    }
}

