/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.resource.cache;

import com.JRcServer.commons.beans.BaseBean;
import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.resource.cache.CacheIO;
import com.JRcServer.commons.resource.cache.CacheIOImple;
import com.JRcServer.commons.resource.cache.SectorIO;
import com.JRcServer.commons.sys.Initializer;
import com.JRcServer.commons.sys.Manager;
import com.JRcServer.commons.sys.NamingManager;
import com.JRcServer.commons.util.BigTableSync;
import com.JRcServer.commons.util.SearchPortion;

public class CacheManager
implements Initializer {
    public static final String MANAGER_NAME = "cache@manager";
    public static final String NAMING_PLUS = "@cache.manager";
    private static final Object SYNC = new Object();
    static /* synthetic */ Class class$0;

    public synchronized void init() throws AccessException {
        this.init(null);
    }

    public synchronized void init(BaseBean bean) throws AccessException {
        BigTableSync table = null;
        if (Manager.getInstance().isData(MANAGER_NAME)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.JRcServer.commons.resource.cache.CacheManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new AccessException(String.valueOf(clazz.getName()) + " \u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059");
        }
        try {
            table = new BigTableSync();
            Manager.getInstance().put(MANAGER_NAME, table);
        }
        catch (Exception e) {
            this.destroy();
            throw new AccessException(e);
        }
    }

    public synchronized void destroy() {
        BigTableSync table = null;
        table = (BigTableSync)Manager.getInstance().get(MANAGER_NAME);
        if (table == null) {
            return;
        }
        table.clear();
        table = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long create(String cacheFileName, int size) throws InputException, AccessException {
        long ret = -1L;
        BigTableSync table = null;
        SectorIO io = null;
        CacheIOImple imple = null;
        Object object = SYNC;
        synchronized (object) {
            table = (BigTableSync)Manager.getInstance().get(MANAGER_NAME);
            if (table == null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.JRcServer.commons.resource.cache.CacheManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new AccessException(String.valueOf(clazz.getName()) + " \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            try {
                io = new SectorIO(cacheFileName, size);
                imple = new CacheIOImple(io);
                ret = imple.getUniqueID();
                while (table.isData(ret)) {
                    ret = ret + 1L & 0x3FFFFFFFFFFFFFFFL;
                }
                imple.setUniqueID(ret);
                table.add(ret, imple);
            }
            catch (Exception e) {
                throw new AccessException(e);
            }
        }
        return ret;
    }

    public static final void delete(Long uniqueID) {
        if (uniqueID == null) {
            return;
        }
        CacheManager.delete((long)uniqueID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void delete(long uniqueID) {
        CacheIOImple io = null;
        BigTableSync table = null;
        Object object = SYNC;
        synchronized (object) {
            table = (BigTableSync)Manager.getInstance().get(MANAGER_NAME);
            if (table == null) {
                return;
            }
            io = (CacheIOImple)table.remove(uniqueID);
            if (io != null) {
                io.destroy();
            }
        }
    }

    public static final CacheIO get(Long uniqueID) {
        if (uniqueID == null) {
            return null;
        }
        return CacheManager.get((long)uniqueID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final CacheIO get(long uniqueID) {
        CacheIOImple ret = null;
        BigTableSync table = null;
        Object object = SYNC;
        synchronized (object) {
            table = (BigTableSync)Manager.getInstance().get(MANAGER_NAME);
            ret = table == null ? null : (CacheIOImple)table.get(uniqueID);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void putNamingManagerByCacheIO(String naming, String cacheFileName, int size) throws InputException, AccessException {
        long uniqueID = -1L;
        if (naming == null || (naming = naming.trim()).length() <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        Object object = SYNC;
        synchronized (object) {
            uniqueID = CacheManager.create(cacheFileName, size);
            CacheManager.putNamingManager(naming, uniqueID);
        }
    }

    public static final void putNamingManager(String name, Long uniqueID) {
        if (uniqueID == null) {
            return;
        }
        CacheManager.putNamingManager(name, (long)uniqueID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void putNamingManager(String name, long uniqueID) {
        if (name == null || (name = name.trim().toLowerCase()).length() <= 0 || uniqueID < 0L) {
            return;
        }
        Object object = SYNC;
        synchronized (object) {
            name = name + NAMING_PLUS;
            NamingManager.add(name, new Long(uniqueID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void removeNamingManagerByCacheIO(String name) {
        long uniqueID = -1L;
        Object object = SYNC;
        synchronized (object) {
            uniqueID = CacheManager.removeNamingManager(name);
            if (uniqueID != -1L) {
                CacheManager.delete(uniqueID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long removeNamingManager(String name) {
        long ret = -1L;
        Object o = null;
        if (name == null || (name = name.trim().toLowerCase()).length() <= 0) {
            return -1L;
        }
        name = name + NAMING_PLUS;
        Object object = SYNC;
        synchronized (object) {
            o = NamingManager.get(name);
            if (o != null && o instanceof Long) {
                ret = (Long)o;
                NamingManager.remove(name);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final CacheIO getNamingManagerByCacheIO(String name) {
        long uniqueID = -1L;
        CacheIO ret = null;
        Object object = SYNC;
        synchronized (object) {
            uniqueID = CacheManager.getNamingManager(name);
            if (uniqueID != -1L) {
                ret = CacheManager.get(uniqueID);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long getNamingManager(String name) {
        long ret = -1L;
        Object o = null;
        if (name == null || (name = name.trim().toLowerCase()).length() <= 0) {
            return -1L;
        }
        name = name + NAMING_PLUS;
        Object object = SYNC;
        synchronized (object) {
            o = NamingManager.get(name);
            if (o != null && o instanceof Long) {
                ret = (Long)o;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String[] getNames() {
        String[] ret = null;
        Object object = SYNC;
        synchronized (object) {
            ret = SearchPortion.searchString(NamingManager.getNames(), "*" + NAMING_PLUS);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int size() {
        BigTableSync table = null;
        Object object = SYNC;
        synchronized (object) {
            block4: {
                table = (BigTableSync)Manager.getInstance().get(MANAGER_NAME);
                if (table != null) break block4;
                return 0;
            }
            return table.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long[] getUniqueIDs() {
        BigTableSync table = null;
        Object object = SYNC;
        synchronized (object) {
            table = (BigTableSync)Manager.getInstance().get(MANAGER_NAME);
            if (table == null) {
                return null;
            }
            return table.getNumbers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean isManager() {
        Object object = SYNC;
        synchronized (object) {
            return Manager.getInstance().isData(MANAGER_NAME);
        }
    }
}

