/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.resource.cache;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.io.IOCom;
import java.io.RandomAccessFile;

public class SectorDataFile {
    private RandomAccessFile filePointer = null;
    private int maxSector = -1;
    private String fileName = null;

    private SectorDataFile() {
    }

    public SectorDataFile(String name, int size) throws InputException, AccessException {
        if (name == null || name.length() <= 0 || size <= 0 || size > 524288) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            long len = (long)size * 4096L;
            if (!IOCom.isFileExists(name)) {
                this.filePointer = new RandomAccessFile(name, "rw");
                this.filePointer.setLength(len);
            } else {
                this.filePointer = new RandomAccessFile(name, "rw");
                if (len != this.filePointer.length()) {
                    this.filePointer.setLength(len);
                }
            }
            this.maxSector = size;
            this.fileName = name;
        }
        catch (Exception e) {
            this.destroy();
            throw new AccessException(e);
        }
    }

    protected final void finalize() throws Exception {
        try {
            this.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() {
        if (this.filePointer != null) {
            try {
                this.filePointer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.filePointer = null;
        this.maxSector = -1;
    }

    public int read(byte[] out, int sectorNo, int sectorOffset, int offset, int length) throws InputException, AccessException {
        int ret;
        if (out == null || out.length <= 0 || sectorNo < 0 || sectorNo > this.maxSector || sectorOffset >= 4096 || length <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.filePointer != null) {
            sectorOffset = sectorOffset <= 0 ? 0 : sectorOffset;
            length = length + offset >= out.length ? out.length - offset : length;
            long sp = (long)(sectorNo * 4096) + (long)sectorOffset;
            try {
                this.filePointer.seek(sp);
                ret = this.filePointer.read(out, offset, length);
            }
            catch (Exception e) {
                throw new AccessException(e);
            }
        } else {
            ret = -1;
        }
        return ret;
    }

    public void write(byte[] in, int sectorNo, int sectorOffset, int offset, int length) throws InputException, AccessException {
        if (in == null || in.length <= 0 || sectorNo < 0 || sectorNo > this.maxSector || sectorOffset >= 4096 || length <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.filePointer != null) {
            sectorOffset = sectorOffset <= 0 ? 0 : sectorOffset;
            length = length + offset >= in.length ? in.length - offset : length;
            long sp = (long)(sectorNo * 4096) + (long)sectorOffset;
            try {
                this.filePointer.seek(sp);
                this.filePointer.write(in, offset, length);
            }
            catch (Exception e) {
                throw new AccessException(e);
            }
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isUseObject() {
        return this.filePointer != null;
    }
}

