/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.resource.cache;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.resource.cache.NotUseSectorException;
import com.JRcServer.commons.resource.cache.UseSectorFlags;
import com.JRcServer.commons.serialize.SerializeUtil;
import com.JRcServer.commons.util.NumberTable;
import com.JRcServer.commons.util.array.IntArray;
import java.io.Serializable;

public class SectorIDManage
implements Serializable {
    private static final long serialVersionUID;
    public static final int SECTOR_LENGTH = 4096;
    public static final int MIN_SECTOR = 128;
    public static final int MAX_SECTOR = 524288;
    private UseSectorFlags useSectorFlags = null;
    private NumberTable useIDBySector = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.JRcServer.commons.resource.cache.SectorIDManage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        serialVersionUID = SerializeUtil.serialVersionUID(clazz.getName());
    }

    private SectorIDManage() {
    }

    public SectorIDManage(int size) {
        if (size <= 128) {
            size = 128;
        } else if (size >= 524288) {
            size = 524288;
        }
        try {
            this.useSectorFlags = new UseSectorFlags(size);
            size = this.useSectorFlags.getMaxSize();
            this.useIDBySector = new NumberTable();
        }
        catch (Exception e) {
            this.destroy();
        }
    }

    protected final void finalize() throws Exception {
        try {
            this.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void destroy() {
        if (this.useSectorFlags != null) {
            this.useSectorFlags.clear();
        }
        if (this.useIDBySector != null) {
            this.useIDBySector.clear();
        }
        this.useSectorFlags = null;
        this.useIDBySector = null;
    }

    public int searchByReservationOneSector(int useID) throws InputException, NotUseSectorException {
        int ret = -1;
        IntArray ary = null;
        if (useID < 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.useSectorFlags != null) {
            ret = this.useSectorFlags.useSearchSector();
            if (ret == -1) {
                throw new NotUseSectorException("\u30bb\u30af\u30bf\u7a7a\u304d\u9818\u57df\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            ary = (IntArray)this.useIDBySector.get(useID);
            if (ary == null) {
                ary = new IntArray();
                this.useIDBySector.add(useID, ary);
            }
            this.useSectorFlags.put(true, ret);
            ary.add(ret);
        }
        return ret;
    }

    public int searchByReservationSector(int useID, int reservationSize) throws InputException {
        int ret = 0;
        IntArray ary = null;
        if (useID < 0 || reservationSize <= 0 || reservationSize > 524288) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.useSectorFlags != null) {
            int i = 0;
            ret = 0;
            int index = -1;
            while (i < reservationSize) {
                int code = this.useSectorFlags.useSearchSector(index);
                if (code == -1) break;
                if (i == 0 && (ary = (IntArray)this.useIDBySector.get(useID)) == null) {
                    ary = new IntArray();
                    this.useIDBySector.add(useID, ary);
                }
                this.useSectorFlags.put(true, code);
                ary.add(code);
                ++ret;
                index = code;
                ++i;
            }
        }
        return ret;
    }

    public void releaseOneSector(int useID, int no) throws InputException {
        IntArray ary = null;
        if (useID < 0 || no < 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.useSectorFlags != null) {
            try {
                ary = (IntArray)this.useIDBySector.get(useID);
                if (ary != null) {
                    int sectorNo = ary.remove(no);
                    if (ary.size() <= 0) {
                        this.useIDBySector.remove(useID);
                    }
                    if (sectorNo < Integer.MAX_VALUE) {
                        this.useSectorFlags.put(false, sectorNo);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void releaseUseIDByAllSector(int useID) throws InputException {
        IntArray ary = null;
        if (useID < 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.useSectorFlags != null && (ary = (IntArray)this.useIDBySector.get(useID)) != null) {
            int len = ary.size();
            int i = 0;
            while (i < len) {
                int sectorNo = ary.get(i);
                this.useSectorFlags.put(false, sectorNo);
                ++i;
            }
            this.useIDBySector.remove(useID);
        }
    }

    public int getReservationOneSector(int useID, int no) {
        int ret = -1;
        IntArray ary = null;
        if (useID < 0 || no < 0) {
            return -1;
        }
        if (this.useSectorFlags != null) {
            try {
                ary = (IntArray)this.useIDBySector.get(useID);
                if (ary != null) {
                    ret = ary.get(no);
                }
            }
            catch (Exception e) {
                ret = -1;
            }
        }
        return ret;
    }

    public int[] getReservationAllUse(int useID) {
        int len;
        IntArray ary = null;
        int[] ret = null;
        if (useID < 0) {
            return null;
        }
        if (this.useSectorFlags != null && (ary = (IntArray)this.useIDBySector.get(useID)) != null && (len = ary.size()) > 0) {
            ret = new int[len];
            int i = 0;
            while (i < len) {
                ret[i] = ary.get(i);
                ++i;
            }
        }
        return ret;
    }

    public int getReservationSectorSize(int useID) {
        int ret = -1;
        IntArray ary = null;
        if (useID < 0) {
            return -1;
        }
        if (this.useSectorFlags != null) {
            try {
                ary = (IntArray)this.useIDBySector.get(useID);
                if (ary != null) {
                    ret = ary.size();
                }
            }
            catch (Exception e) {
                ret = -1;
            }
        }
        return ret;
    }

    public int getMaxSector() {
        int ret;
        try {
            ret = this.useSectorFlags.getMaxSize();
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    public int getUseSector() {
        int ret;
        try {
            ret = this.useSectorFlags.getUseSize();
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    public boolean isUseObject() {
        return this.useSectorFlags != null;
    }
}

