/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.resource.cache;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.resource.cache.SectorDataFile;
import com.JRcServer.commons.resource.cache.SectorIDManage;
import com.JRcServer.commons.resource.cache.SectorSizeManage;
import com.JRcServer.commons.util.IdManager;

public class SectorIO {
    public static final long SECTOR_LENGTH = 4096L;
    private IdManager sequenceIDManage = null;
    private SectorIDManage idManage = null;
    private SectorSizeManage sizeManage = null;
    private SectorDataFile dataFileManage = null;
    private long uniqueID = -1L;

    private SectorIO() {
    }

    public SectorIO(String name, int size) throws InputException, AccessException {
        if (name == null || name.length() <= 0 || size <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.idManage = new SectorIDManage(size);
            size = this.idManage.getMaxSector();
            this.sizeManage = new SectorSizeManage(size);
            this.dataFileManage = new SectorDataFile(name, size);
            this.sequenceIDManage = new IdManager(0, size);
            this.uniqueID = SectorIO.createUniqueID(this.dataFileManage.getFileName(), this.idManage.getMaxSector());
        }
        catch (AccessException ae) {
            this.destroy();
            throw ae;
        }
        catch (Exception e) {
            this.destroy();
            throw new AccessException(e);
        }
    }

    protected final void finalize() throws Exception {
        try {
            this.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void destroy() {
        if (this.idManage != null) {
            try {
                this.idManage.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.sizeManage != null) {
            try {
                this.sizeManage.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.dataFileManage != null) {
            try {
                this.dataFileManage.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.sequenceIDManage != null) {
            try {
                this.sequenceIDManage.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.idManage = null;
        this.sizeManage = null;
        this.dataFileManage = null;
        this.sequenceIDManage = null;
        this.uniqueID = -1L;
    }

    public synchronized int reservationID() {
        int ret = -1;
        if (this.sequenceIDManage != null) {
            ret = this.sequenceIDManage.getID();
        }
        return ret;
    }

    public synchronized int reservationSector(int id, int size) throws InputException {
        int ret = 0;
        if (id < 0 || size <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.sequenceIDManage != null && this.sequenceIDManage.isUseID(id)) {
            if (this.idManage.getReservationSectorSize(id) <= 0) {
                this.sizeManage.set(id, 0);
            }
            try {
                ret = this.idManage.searchByReservationSector(id, size);
            }
            catch (Exception e) {
                ret = 0;
            }
        }
        return ret;
    }

    public synchronized void releaseID(int id) {
        if (id >= 0 || this.sequenceIDManage != null) {
            try {
                this.idManage.releaseUseIDByAllSector(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.sizeManage.set(id, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.sequenceIDManage.removeID(id);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized int readData(byte[] out, int id, int no, int sectorOffset, int offset, int length) throws AccessException {
        int sectorPoint;
        int ret = -1;
        if (this.sequenceIDManage != null && (sectorPoint = this.idManage.getReservationOneSector(id, no)) != -1) {
            if (4096 < sectorOffset + length) {
                length = 4096 - sectorOffset;
            }
            try {
                ret = this.dataFileManage.read(out, sectorPoint, sectorOffset, offset, length);
            }
            catch (AccessException ae) {
                throw ae;
            }
            catch (Exception e) {
                throw new AccessException(e);
            }
        }
        return ret;
    }

    public synchronized int writeData(byte[] in, int id, int no, int sectorOffset, int offset, int length) throws AccessException {
        int sectorPoint;
        int ret = -1;
        if (this.sequenceIDManage != null && (sectorPoint = this.idManage.getReservationOneSector(id, no)) != -1) {
            if (4096 < sectorOffset + length) {
                length = 4096 - sectorOffset;
            }
            try {
                this.dataFileManage.write(in, sectorPoint, sectorOffset, offset, length);
                ret = length;
            }
            catch (AccessException ae) {
                throw ae;
            }
            catch (Exception e) {
                throw new AccessException(e);
            }
        }
        return ret;
    }

    public synchronized int getReservationSectorPoint(int id, int no) {
        int ret = -1;
        if (this.sequenceIDManage != null) {
            ret = this.idManage.getReservationOneSector(id, no);
        }
        return ret;
    }

    public synchronized int getReservationSectorSize(int id) {
        int ret = -1;
        if (this.sequenceIDManage != null) {
            ret = this.idManage.getReservationSectorSize(id);
        }
        return ret;
    }

    public synchronized void setUseIDByDataSize(int id, int size) {
        if (this.sizeManage != null) {
            this.sizeManage.set(id, size);
        }
    }

    public synchronized int getUseIDByDataSize(int id) {
        int ret = 0;
        if (this.sizeManage != null) {
            ret = this.sizeManage.get(id);
        }
        return ret;
    }

    public synchronized int getIDLength() {
        int ret = -1;
        if (this.sequenceIDManage != null) {
            ret = this.sequenceIDManage.getUseIDSize();
        }
        return ret;
    }

    public synchronized String getFileName() {
        String ret = null;
        if (this.sequenceIDManage != null) {
            ret = this.dataFileManage.getFileName();
        }
        return ret;
    }

    public synchronized int getMaxSector() {
        int ret = -1;
        if (this.sequenceIDManage != null) {
            ret = this.idManage.getMaxSector();
        }
        return ret;
    }

    public synchronized int getUseSector() {
        int ret = -1;
        if (this.sequenceIDManage != null) {
            ret = this.idManage.getUseSector();
        }
        return ret;
    }

    public synchronized void setUniqueID(long id) {
        this.uniqueID = id;
    }

    public synchronized long getUniqueID() {
        long ret = -1L;
        if (this.sequenceIDManage != null) {
            ret = this.uniqueID;
        }
        return ret;
    }

    public static final long createUniqueID(String fileName, int size) {
        return SectorIO.getHash(fileName) + (long)size * 31L;
    }

    public synchronized boolean isUseId(int id) {
        boolean ret = false;
        if (this.sequenceIDManage != null) {
            ret = this.sequenceIDManage.isUseID(id);
        }
        return ret;
    }

    public synchronized boolean isUseObject() {
        return this.sequenceIDManage != null;
    }

    private static final long getHash(String name) {
        long ret = 0L;
        int len = name.length();
        int i = 0;
        while (i < len) {
            ret = 31L * ret + (long)(name.charAt(i) & 0xFFFF) & 0x3FFFFFFFFFFFFFFFL;
            ++i;
        }
        return ret;
    }
}

