/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.resource.cache;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.serialize.SerializeUtil;
import java.io.Serializable;
import java.util.Arrays;

class UseSectorFlags
implements Serializable {
    private static final long serialVersionUID;
    private static final int ELEMENT_LENGTH = 64;
    private static final int ELEMENT_MASK = 63;
    private static final int ELEMENT_BITCOUNT = 6;
    private long[] sector64Flags = null;
    private int maxSectorSize = 0;
    private int useSectorSize = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.JRcServer.commons.resource.cache.UseSectorFlags");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        serialVersionUID = SerializeUtil.serialVersionUID(clazz.getName());
    }

    public UseSectorFlags() {
    }

    public UseSectorFlags(int size) throws InputException {
        this.create(size);
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void create(int size) throws InputException {
        if (size < 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.clear();
        int no = ((size & 0x3F) != 0 ? 1 : 0) + ((size & 0xFFFFFFC0) >> 6);
        this.sector64Flags = new long[no];
        Arrays.fill(this.sector64Flags, 0L);
        this.maxSectorSize = no * 64;
        this.useSectorSize = 0;
    }

    public void clear() {
        this.sector64Flags = null;
        this.maxSectorSize = 0;
        this.useSectorSize = 0;
    }

    public void put(boolean flg, int no) {
        long[] flags = null;
        flags = this.sector64Flags;
        if (flags == null || no < 0 || no >= this.maxSectorSize) {
            return;
        }
        int indNo = (no & 0xFFFFFFC0) >> 6;
        int indOff = no & 0x3F;
        if (flg) {
            if ((flags[indNo] & 1L << indOff) == 0L) {
                ++this.useSectorSize;
            }
            int n = indNo;
            flags[n] = flags[n] | 1L << indOff & 0xFFFFFFFFFFFFFFFFL;
        } else {
            if ((flags[indNo] & 1L << indOff) != 0L) {
                --this.useSectorSize;
            }
            int n = indNo;
            flags[n] = flags[n] & ((1L << indOff ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public boolean get(int no) {
        long[] flags = null;
        flags = this.sector64Flags;
        if (flags == null || no < 0 || no >= this.maxSectorSize) {
            return false;
        }
        return (flags[(no & 0xFFFFFFC0) >> 6] & 1L << (no & 0x3F)) != 0L;
    }

    public int useSearchSector() {
        return this.useSearchSector(0);
    }

    public int useSearchSector(int index) {
        long[] flags = null;
        int ret = -1;
        int size = 0;
        size = this.maxSectorSize;
        flags = this.sector64Flags;
        if (flags == null) {
            return -1;
        }
        index = index <= 0 ? 0 : (index & 0xFFFFFFC0) >> 6;
        int len = 64;
        int max = flags.length;
        int i = index;
        ret = -1;
        boolean flg = false;
        while (i < max && !flg) {
            if (flags[i] != -1L) {
                int j = 0;
                while (j < len) {
                    if ((flags[i] & 1L << j) == 0L) {
                        ret = i * 64 + j;
                        if (ret >= size) {
                            ret = -1;
                            break;
                        }
                        flg = true;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return ret;
    }

    public int getMaxSize() {
        return this.maxSectorSize;
    }

    public int getUseSize() {
        return this.useSectorSize;
    }

    public boolean isUseObject() {
        return this.sector64Flags != null;
    }
}

