/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.sys;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.util.UtilCom;
import java.net.PasswordAuthentication;

class AutoUserPasswdPause {
    private String m_user = null;
    private String m_passwd = null;
    private String m_code = null;

    public AutoUserPasswdPause() {
    }

    public AutoUserPasswdPause(String user, String passwd) throws InputException {
        this.create(user, passwd, null, null);
    }

    public AutoUserPasswdPause(String user, String passwd, String scheme, String prompt) throws InputException {
        this.create(user, passwd, scheme, prompt);
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void create(String user, String passwd) throws InputException {
        this.create(user, passwd, null, null);
    }

    public final void create(String user, String passwd, String scheme, String prompt) throws InputException {
        this.clear();
        this.m_user = UtilCom.trimPlus(user);
        this.m_passwd = UtilCom.trimPlus(passwd);
        this.m_code = AutoUserPasswdPause.getCode(scheme, prompt);
    }

    public final void clear() {
        this.m_user = null;
        this.m_passwd = null;
        this.m_code = null;
    }

    public final PasswordAuthentication get() {
        PasswordAuthentication ret = null;
        try {
            ret = new PasswordAuthentication(this.m_user, this.m_passwd.toCharArray());
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    public final PasswordAuthentication get(String scheme, String prompt) {
        PasswordAuthentication ret = null;
        try {
            if (this.isCheck(scheme, prompt)) {
                ret = new PasswordAuthentication(this.m_user, this.m_passwd.toCharArray());
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    public final String getScheme() {
        String ret = null;
        if (this.m_code != null) {
            ret = this.m_code.substring(0, this.m_code.indexOf("@"));
        }
        return ret;
    }

    public final String getPrompt() {
        String ret = null;
        if (this.m_code != null) {
            ret = this.m_code.substring(this.m_code.indexOf("@"));
        }
        return ret;
    }

    public final boolean isCheck(String scheme, String prompt) {
        boolean ret;
        if (scheme == null && prompt == null && this.m_code == null) {
            return true;
        }
        try {
            ret = this.m_code.equals(AutoUserPasswdPause.getCode(scheme, prompt));
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }

    private static final String getCode(String scheme, String prompt) throws InputException {
        StringBuffer buf = null;
        String ret = null;
        if (scheme != null && prompt != null) {
            buf = new StringBuffer();
            buf.append(UtilCom.trimPlus(scheme));
            buf.append("@");
            buf.append(UtilCom.trimPlus(prompt));
            ret = buf.toString();
            buf = null;
        }
        return ret;
    }
}

