/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.sys;

import com.JRcServer.commons.exception.BaseException;
import com.JRcServer.commons.exception.ExecutionException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.exception.UnsupportException;
import com.JRcServer.commons.sys.Os;
import com.JRcServer.commons.sys.cmd.NativeCmd;
import com.JRcServer.commons.thread.Synchronized;
import com.JRcServer.commons.util.ArrayTable;

public class GetEnvironment {
    private static final String[] WINNT_ENVCMD = new String[]{"cmd", "/c", "set"};
    private static final String[] WIN9X_ENVCMD = new String[]{"command.com", "/c", "set"};
    private static final String[] OS_2_ENVCMD = new String[]{"cmd", "/c", "set"};
    private static final String[] UNIX1_ENVCMD = new String[]{"/bin/env"};
    private static final String[] UNIX2_ENVCMD = new String[]{"/usr/bin/env"};
    private static final String[] UNIX3_ENVCMD = new String[]{"env"};
    private static final String[] NETWARE_ENVCMD = new String[]{"env"};
    private static final String[] VMS_ENVCMD = new String[]{"show", "logical"};
    private volatile boolean m_createFlg = false;
    private final ArrayTable m_table = new ArrayTable();
    private final Synchronized m_sync = new Synchronized();
    private static final GetEnvironment SNGL = new GetEnvironment();

    private GetEnvironment() {
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final GetEnvironment getInstance() {
        return SNGL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void create() throws InputException, ExecutionException, UnsupportException {
        this.clear();
        try {
            this.m_sync.create();
            Object object = this.m_sync.get();
            synchronized (object) {
                switch (Os.getInstance().getOS()) {
                    case 1: 
                    case 33: 
                    case 34: 
                    case 49: 
                    case 257: 
                    case 289: 
                    case 305: {
                        GetEnvironment.getEnv(this.m_table, GetEnvironment.getCmd());
                        break;
                    }
                    case 321: {
                        GetEnvironment.getVmsEnv(this.m_table, GetEnvironment.getCmd());
                        break;
                    }
                    default: {
                        throw new UnsupportException("\u5bfe\u8c61\u306eOS(" + Os.getInstance().getName(Os.getInstance().getOS()) + ")\u3067\u306f\u3001\u74b0\u5883\u5909\u6570\u53d6\u5f97\u51e6\u7406\u3092\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093");
                    }
                }
            }
        }
        catch (InputException in) {
            this.clear();
            throw new ExecutionException(in);
        }
        catch (UnsupportException ue) {
            this.clear();
            throw ue;
        }
        catch (ExecutionException ee) {
            this.clear();
            throw ee;
        }
        catch (Exception t) {
            this.clear();
        }
    }

    public final void clear() {
        this.m_sync.clear();
        this.m_createFlg = false;
        this.m_table.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ArrayTable getTable() {
        ArrayTable ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_table;
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String get(String name) {
        String ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = (String)this.m_table.get(name, 0);
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String get(String name, int no) {
        String ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = (String)this.m_table.get(name, no);
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getNumber(String name) {
        int ret = 0;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = Integer.parseInt((String)this.m_table.get(name, 0));
            }
        }
        catch (Exception t) {
            ret = 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getNumber(String name, int no) {
        int ret = 0;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = Integer.parseInt((String)this.m_table.get(name, no));
            }
        }
        catch (Exception t) {
            ret = 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double getFloat(String name) {
        double ret = 0.0;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = Double.parseDouble((String)this.m_table.get(name, 0));
            }
        }
        catch (Exception t) {
            ret = 0.0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double getFloat(String name, int no) {
        double ret = 0.0;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = Double.parseDouble((String)this.m_table.get(name, no));
            }
        }
        catch (Exception t) {
            ret = 0.0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getElements(String name) {
        int ret = 0;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_table.getElements(name);
            }
        }
        catch (Exception t) {
            ret = 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getNames() {
        String[] ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_table.getNames();
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    private final synchronized void reCreate() {
        try {
            if (!this.m_createFlg) {
                this.create();
                this.m_createFlg = true;
            }
        }
        catch (UnsupportException ue) {
            this.m_createFlg = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    private static final void getEnv(ArrayTable out, String[] cmd) throws InputException, ExecutionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 331->335)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void getVmsEnv(ArrayTable out, String[] cmd) throws InputException, ExecutionException {
        String logName = null;
        String logValue = null;
        String newLogName = null;
        String line = null;
        String[] stdOut = null;
        if (out == null) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        if (cmd == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            try {
                stdOut = GetEnvironment.executionCmd(cmd);
                if (stdOut == null) {
                    throw new ExecutionException("\u5bfe\u8c61\u306e\u30b3\u30de\u30f3\u30c9(" + cmd[0] + ")\u304b\u3089\u60c5\u5831\u306f\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
                }
                int len = stdOut.length;
                int i = 0;
                while (true) {
                    block17: {
                        if (i < len) break block17;
                        if (logName != null) {
                            out.add(logName, logValue);
                        }
                        break;
                    }
                    line = null;
                    line = stdOut[i];
                    stdOut[i] = null;
                    if (line.startsWith("\t=")) {
                        if (logName != null) {
                            out.add(logName, line.substring(4, line.length() - 1));
                        }
                    } else if (line.startsWith("  \"")) {
                        int index;
                        if (logName != null) {
                            out.add(logName, logValue);
                        }
                        if (out.getElements(newLogName = line.substring(3, (index = line.indexOf(61)) - 2)) != 0) {
                            logName = null;
                        } else {
                            logName = newLogName;
                            logValue = line.substring(index + 3, line.length() - 1);
                        }
                    }
                    ++i;
                }
            }
            catch (InputException in) {
                throw in;
            }
            catch (ExecutionException ee) {
                throw ee;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            logName = null;
            logValue = null;
            newLogName = null;
            line = null;
            stdOut = null;
            throw throwable;
        }
        {
            Object var11_14 = null;
            logName = null;
            logValue = null;
            newLogName = null;
            line = null;
        }
        stdOut = null;
    }

    private static final String[] getCmd() throws UnsupportException {
        String[] ret = null;
        switch (Os.getInstance().getOS()) {
            case 49: {
                ret = OS_2_ENVCMD;
                break;
            }
            case 33: {
                ret = WINNT_ENVCMD;
                break;
            }
            case 34: {
                ret = WIN9X_ENVCMD;
                break;
            }
            case 1: 
            case 289: {
                if (GetEnvironment.isRead(UNIX1_ENVCMD[0])) {
                    ret = UNIX1_ENVCMD;
                    break;
                }
                if (GetEnvironment.isRead(UNIX2_ENVCMD[0])) {
                    ret = UNIX2_ENVCMD;
                    break;
                }
                ret = UNIX3_ENVCMD;
                break;
            }
            case 257: 
            case 305: {
                ret = NETWARE_ENVCMD;
                break;
            }
            case 321: {
                ret = VMS_ENVCMD;
                break;
            }
            default: {
                throw new UnsupportException("\u5bfe\u8c61\u306eOS(" + Os.getInstance().getName(Os.getInstance().getOS()) + ")\u3067\u306f\u3001\u74b0\u5883\u5909\u6570\u53d6\u5f97\u51e6\u7406\u3092\u5bfe\u5fdc\u3057\u3066\u3044\u307e\u305b\u3093");
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final String[] executionCmd(String[] cmd) throws InputException, ExecutionException {
        block12: {
            cmdLine = null;
            ret = null;
            if (cmd == null) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            len = cmd.length;
            if (len <= 0) {
                throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            }
            cmdLine = new NativeCmd();
            try {
                try {
                    ret = cmdLine.execution(false, cmd);
                    if (ret == null) {
                        throw new ExecutionException("\u53d6\u5f97\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093( cmd : " + cmdLine.getCommand() + ")");
                    }
                }
                catch (ExecutionException ee) {
                    ret = null;
                    throw ee;
                }
                catch (BaseException be) {
                    ret = null;
                    throw new ExecutionException(be);
                }
            }
            catch (Throwable var7_6) {
                var6_7 = null;
                try {
                    cmdLine.clear();
                }
                catch (Exception var8_9) {
                    // empty catch block
                }
                cmdLine = null;
                throw var7_6;
            }
            {
                var6_8 = null;
            }
            ** try [egrp 2[TRYBLOCK] [4 : 125->132)] { 
lbl33:
            // 1 sources

            cmdLine.clear();
            break block12;
lbl35:
            // 1 sources

            catch (Exception var8_10) {
                // empty catch block
            }
        }
        cmdLine = null;
        return ret;
    }

    /*
     * Exception decompiling
     */
    public static final boolean isRead(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 74->77)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

