/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.sys;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.util.CharTable;

public class Manager {
    private CharTable m_table = null;
    private static final Manager SNGL = new Manager();

    private Manager() {
    }

    public static final Manager getInstance() {
        return SNGL;
    }

    public synchronized void init() {
        if (this.m_table == null) {
            this.m_table = new CharTable();
        }
    }

    public synchronized void destroy() {
        if (this.m_table != null) {
            this.m_table.clear();
        }
    }

    public synchronized void put(String name, Object value) throws InputException {
        this.m_table.add(name, value);
    }

    public synchronized void remove(String name) {
        try {
            this.m_table.remove(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized Object get(String name) {
        return this.m_table.get(name);
    }

    public synchronized int size() {
        return this.m_table.size();
    }

    public synchronized String[] getNames() {
        return this.m_table.getNames();
    }

    public synchronized boolean isData(String name) {
        return this.m_table.isData(name);
    }
}

