/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.sys.cmd;

import com.JRcServer.commons.sys.Os;

class CmdCommon {
    private static final String[] WINNT_ENVCMD = new String[]{"cmd", "/c"};
    private static final String[] WIN9X_ENVCMD = new String[]{"command.com", "/c"};
    private static final String[] OS_2_ENVCMD = new String[]{"cmd", "/c"};

    private CmdCommon() {
    }

    public static final String[] getCmdHeader(String[] param, String cmd) {
        String[] tmp = null;
        String[] ret = null;
        if (param != null && param.length == 1) {
            cmd = param[0];
            param = null;
        }
        if (param != null) {
            switch (Os.getInstance().getOS()) {
                case 33: {
                    tmp = WINNT_ENVCMD;
                    break;
                }
                case 16: 
                case 34: {
                    tmp = WIN9X_ENVCMD;
                    break;
                }
                case 49: {
                    tmp = OS_2_ENVCMD;
                    break;
                }
                default: {
                    tmp = null;
                }
            }
            if (tmp != null) {
                int len = tmp.length;
                boolean flg = true;
                if (len > 0) {
                    int i = 0;
                    while (i < len) {
                        if (!tmp[i].toLowerCase().equals(param[i].toLowerCase())) {
                            flg = false;
                            break;
                        }
                        ++i;
                    }
                }
                if (!flg) {
                    ret = new String[len + param.length];
                    System.arraycopy(tmp, 0, ret, 0, len);
                    System.arraycopy(param, 0, ret, len, param.length);
                } else {
                    ret = param;
                }
            } else {
                ret = param;
            }
        } else {
            switch (Os.getInstance().getOS()) {
                case 33: {
                    tmp = WINNT_ENVCMD;
                    break;
                }
                case 16: 
                case 34: {
                    tmp = WIN9X_ENVCMD;
                    break;
                }
                case 49: {
                    tmp = OS_2_ENVCMD;
                    break;
                }
                default: {
                    tmp = null;
                }
            }
            if (tmp != null) {
                int len = tmp.length;
                ret = new String[len + 1];
                System.arraycopy(tmp, 0, ret, 0, len);
                ret[len] = cmd;
            } else {
                ret = new String[]{cmd};
            }
        }
        return ret;
    }
}

