/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.sys.user;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.sys.user.LoginException;
import com.JRcServer.commons.sys.user.UserManagerEngine;

public class UserManager {
    public static final String ROOT_USER = "root";
    public static final String GUEST_USER = "guest";
    private UserManagerEngine m_engine = null;

    private UserManager() {
    }

    public UserManager(String name) throws InputException, AccessException {
        this.m_engine = new UserManagerEngine();
        this.m_engine.create(name);
    }

    public UserManager(String name, long timing) throws InputException, AccessException {
        this.m_engine = new UserManagerEngine();
        this.m_engine.create(name);
    }

    protected final void finalize() throws Exception {
        try {
            this.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void destroy() {
        try {
            try {
                this.m_engine.clear();
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.m_engine = null;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.m_engine = null;
            return;
        }
    }

    public final void addUser(String user, String passwd) throws InputException {
        try {
            this.m_engine.addUser(user, passwd);
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void addUser(String user, String passwd, boolean rootOwner, boolean rootGroup) throws InputException {
        try {
            this.m_engine.addUser(user, passwd, rootOwner, rootGroup);
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void addUser(String user, String passwd, boolean rootOwner, boolean rootGroup, int max, String[] extension) throws InputException {
        try {
            this.m_engine.addUser(user, passwd, rootOwner, rootGroup, max, extension);
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void removeUser(String user) throws InputException {
        try {
            this.m_engine.removeUser(user);
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void renewPasswd(String user, String newPasswd) throws InputException {
        try {
            this.m_engine.renewPasswd(user, newPasswd);
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void renewRootOwner(String user, boolean owner) throws InputException {
        try {
            this.m_engine.renewRootOwner(user, owner);
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void renewRootGroup(String user, boolean group) throws InputException {
        try {
            this.m_engine.renewRootGroup(user, group);
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void renewMaxUserCount(String user, int newMax) throws InputException {
        try {
            this.m_engine.renewMaxUserCount(user, newMax);
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void renewExtension(String user, String[] newExtension) throws InputException {
        try {
            this.m_engine.renewExtension(user, newExtension);
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void addUserCount(String user) throws InputException, LoginException {
        try {
            this.m_engine.addUserCount(user);
        }
        catch (InputException in) {
            throw in;
        }
        catch (LoginException le) {
            throw le;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void removeUserCount(String user) throws InputException {
        try {
            this.m_engine.removeUserCount(user);
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final String getPasswd(String user) throws InputException {
        String ret = null;
        try {
            ret = this.m_engine.getPasswd(user);
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public final boolean getRootOwner(String user) throws InputException {
        boolean ret = false;
        try {
            ret = this.m_engine.getRootOwner(user);
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public final boolean getRootGroupOwner(String user) throws InputException {
        boolean ret = false;
        try {
            ret = this.m_engine.getRootGroupOwner(user);
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public final int getNowUserCount(String user) throws InputException {
        int ret = -1;
        try {
            ret = this.m_engine.getNowUserCount(user);
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    public final int getMaxUserCount(String user) throws InputException {
        int ret = -1;
        try {
            ret = this.m_engine.getMaxUserCount(user);
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    public final String[] getExtension(String user) throws InputException {
        String[] ret = null;
        try {
            ret = this.m_engine.getExtension(user);
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public final int getUserNameByUserID(String user) {
        int ret = -1;
        try {
            ret = this.m_engine.getUserNameByUserID(user);
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    public final String getUserIDByUserName(int id) {
        String ret = null;
        try {
            ret = this.m_engine.getUserIDByUserName(id);
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public final String[] getUsers() {
        String[] ret = null;
        try {
            ret = this.m_engine.getUsers();
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    public final int getUserLength() {
        int ret = 0;
        try {
            ret = this.m_engine.getUserLength();
        }
        catch (Exception e) {
            ret = 0;
        }
        return ret;
    }

    public final boolean isUserPasswd(String user, String passwd) {
        boolean ret;
        String chkPasswd = null;
        try {
            ret = this.m_engine.isUser(user) ? (!((chkPasswd = this.m_engine.getPasswd(user)) != null && chkPasswd.length() > 0 || passwd != null && passwd.length() > 0) ? true : passwd.equals(chkPasswd)) : false;
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public final boolean isUser(String user) {
        boolean ret = false;
        try {
            ret = this.m_engine.isUser(user);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public final boolean isUseUser(String user) {
        boolean ret = false;
        try {
            ret = this.m_engine.isUseUser(user);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }
}

