/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.thread;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.ExecutionException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.exception.SettingException;
import com.JRcServer.commons.thread.BaseThread;
import com.JRcServer.commons.thread.ExecutionThread;
import com.JRcServer.commons.thread.ProcessThread;
import com.JRcServer.commons.thread.Synchronized;
import com.JRcServer.commons.thread.ThreadManager;
import com.JRcServer.commons.thread.ThreadState;
import com.JRcServer.commons.util.UtilCom;

public class LoopThread
extends ProcessThread {
    private static final String RUN_NAME = "run";
    private static final String END_NAME = "end";
    private static final String STOP_NAME = "stop";
    private ExecutionThread m_exec = null;
    private final BaseThread m_thread = new BaseThread();
    private ThreadState m_state = null;
    private volatile long m_nowTime = 0L;
    private final Synchronized m_sync = new Synchronized();

    public LoopThread() {
    }

    public LoopThread(ExecutionThread exec) throws InputException {
        this.create(exec);
    }

    public LoopThread(ExecutionThread exec, Object param) throws InputException {
        this.create(exec, param);
    }

    public LoopThread(boolean mode, ExecutionThread exec, Object param) throws InputException {
        this.create(mode, exec, param);
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void create(ExecutionThread exec) throws InputException {
        this.create(exec, null);
    }

    public final void create(ExecutionThread exec, Object param) throws InputException {
        this.create(true, exec, param);
    }

    public final void create(boolean mode, ExecutionThread exec, Object param) throws InputException {
        if (exec == null) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        this.clear();
        try {
            this.m_thread.create(this, param, true);
            if (mode) {
                this.m_thread.setObjectName(exec.getClass().getName());
            } else {
                this.m_thread.setObjectName(null);
            }
            this.m_exec = exec;
            this.m_state = this.initState();
            this.m_sync.create();
        }
        catch (Exception t) {
            this.clear();
        }
    }

    public final void clear() {
        try {
            this.m_thread.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_state.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_exec = null;
        this.m_state = null;
        this.m_nowTime = 0L;
        this.m_sync.clear();
    }

    public final void startThread() throws SettingException {
        if (!this.isExecution()) {
            throw new SettingException("\u8a2d\u5b9a\u60c5\u5831\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059");
        }
        this.m_thread.startThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void exitThread() {
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    this.setFlg(END_NAME, true);
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            try {
                this.m_thread.exitThread();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var2_5 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        this.m_thread.exitThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopLoop() {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                boolean flg = !this.getFlg(STOP_NAME);
                this.setFlg(END_NAME, flg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void destroyThread() {
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    this.setFlg(END_NAME, true);
                }
                UtilCom.idleSleep(500L);
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            try {
                this.m_thread.destroyThread();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var2_5 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        this.m_thread.destroyThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPriority(int newPriority) throws InputException {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_thread.setPriority(newPriority);
            }
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getState() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_thread.getThreadState();
            }
        }
        catch (Exception t) {
            ret = -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getThreadTime() {
        long ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_nowTime;
            }
        }
        catch (Exception t) {
            ret = 0L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getPriority() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_thread.getPriority();
            }
        }
        catch (Exception t) {
            ret = -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ExecutionThread getExecutionThread() {
        ExecutionThread ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_exec;
            }
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isThread() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.getFlg(RUN_NAME);
            }
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isStop() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.getFlg(STOP_NAME);
            }
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEnd() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.getFlg(END_NAME);
            }
        }
        catch (Exception t) {
            ret = true;
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    protected void processThread(Object in) throws ExecutionException, ThreadDeath {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [11 : 250->254)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void destroyThread(Object in) throws Exception {
        this.m_exec.destroy(in);
    }

    protected void toException(ExecutionException err) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isExecution() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_exec != null;
            }
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ThreadState initState() throws AccessException {
        boolean[] value = null;
        ThreadState ret = null;
        try {
            try {
                ret = ThreadManager.getInstance().getState(this.m_thread.getName());
                value = new boolean[]{false};
                ret.setParameter(RUN_NAME, value);
                value = new boolean[]{true};
                ret.setParameter(END_NAME, value);
                value = new boolean[]{false};
                ret.setParameter(STOP_NAME, value);
            }
            catch (Exception t) {
                ret = null;
                throw new AccessException(t);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            value = null;
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        value = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void setFlg(String name, boolean flg) throws NullPointerException {
        boolean[] obj;
        ThreadState state = null;
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    state = this.m_state;
                    obj = (boolean[])state.getParameter(name);
                    obj[0] = flg;
                }
            }
            catch (Exception t) {
                throw new NullPointerException("\u30b9\u30c6\u30fc\u30bf\u30b9\u60c5\u5831\u306f\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            state = null;
            obj = null;
            throw throwable;
        }
        {
            Object var6_9 = null;
            state = null;
        }
        obj = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean getFlg(String name) throws NullPointerException {
        boolean ret;
        boolean[] obj;
        ThreadState state = null;
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    state = this.m_state;
                    obj = (boolean[])state.getParameter(name);
                    ret = obj[0];
                }
            }
            catch (Exception t) {
                throw new NullPointerException("\u30b9\u30c6\u30fc\u30bf\u30b9\u60c5\u5831\u306f\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            state = null;
            obj = null;
            throw throwable;
        }
        {
            Object var6_9 = null;
            state = null;
        }
        obj = null;
        return ret;
    }
}

