/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.thread;

import com.JRcServer.commons.serialize.InitSerialize;
import com.JRcServer.commons.serialize.SerializeUtil;

public class Synchronized
implements InitSerialize {
    private static final long serialVersionUID;
    private static final int DEF_TIMEOUT = 60000;
    private Boolean m_sync = null;
    private int m_lockTimeout = 0;
    private volatile transient int m_count = 0;
    private volatile transient long m_lockStartTime = -1L;
    private volatile transient String m_lockThreadName = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.JRcServer.commons.thread.Synchronized");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        serialVersionUID = SerializeUtil.serialVersionUID(clazz.getName());
    }

    public Synchronized() {
        this.m_lockTimeout = 60000;
        this.create();
    }

    public Synchronized(int timeout) {
        this.m_lockTimeout = timeout <= 0 ? 60000 : timeout;
        this.create();
    }

    public void initSerializable() {
        this.create();
    }

    public final synchronized void create() {
        if (this.m_sync != null) {
            this.clear();
        }
        this.m_sync = new Boolean(true);
        this.m_count = 0;
        this.m_lockThreadName = null;
        this.m_lockStartTime = -1L;
    }

    public final synchronized void clear() {
        this.m_sync = null;
        this.m_count = 0;
        this.m_lockThreadName = null;
        this.m_lockStartTime = -1L;
    }

    public final synchronized Object get() {
        return this.m_sync;
    }

    public int getTimeout() {
        return this.m_lockTimeout;
    }

    public final synchronized long getStartLogTime() {
        return this.m_lockStartTime;
    }

    public final synchronized String getLockByThreadName() {
        return this.m_lockThreadName;
    }

    public final synchronized boolean isUse() {
        return this.m_sync != null;
    }

    protected final synchronized boolean increment() {
        boolean ret;
        String tname = null;
        tname = Thread.currentThread().getName();
        if (this.m_lockThreadName == null || this.m_lockThreadName.equals(tname)) {
            this.m_lockStartTime = System.currentTimeMillis();
            this.m_lockThreadName = tname;
            ++this.m_count;
            ret = true;
        } else {
            ret = false;
        }
        tname = null;
        return ret;
    }

    protected final synchronized boolean decrement() {
        boolean ret = false;
        if (this.m_lockThreadName != null && this.m_lockThreadName.equals(Thread.currentThread().getName())) {
            --this.m_count;
            if (this.m_count <= 0) {
                this.m_lockStartTime = -1L;
                this.m_lockThreadName = null;
                this.m_count = 0;
                ret = true;
            }
        }
        return ret;
    }

    protected final synchronized int lockCount() {
        return this.m_count;
    }
}

