/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.thread;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.thread.ExecutionThread;
import com.JRcServer.commons.thread.ObjectThread;
import com.JRcServer.commons.thread.Synchronized;

public class ThreadPool {
    private static final int DEF_MANLENGTH = 15;
    private static final int MIN_MANLENGTH = 5;
    private static final int MAX_MANLENGTH = 499;
    private int m_seq = 0;
    private ObjectThread[] m_manager = null;
    private final Synchronized m_sync = new Synchronized();

    public ThreadPool() {
        this.create();
    }

    public ThreadPool(int length) throws InputException {
        this.create(length);
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void create() {
        try {
            this.create(15);
        }
        catch (Exception t) {
            this.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void create(int length) throws InputException {
        ObjectThread[] man = null;
        if (length < 5) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        if (length > 499) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.clear();
        this.m_sync.create();
        try {
            try {
                man = new ObjectThread[length];
                int i = 0;
                while (true) {
                    block10: {
                        if (i < length) break block10;
                        Object object = this.m_sync.get();
                        synchronized (object) {
                            this.m_manager = man;
                            break;
                        }
                    }
                    man[i] = new ObjectThread();
                    ++i;
                }
            }
            catch (Exception t) {
                this.clear();
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            man = null;
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        man = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void clear() {
        ObjectThread[] man = null;
        this.m_sync.clear();
        try {
            try {
                man = this.m_manager;
                int len = man.length;
                int i = 0;
                while (i < len) {
                    Object var5_6;
                    try {
                        try {
                            man[i].clear();
                        }
                        catch (Exception exception) {}
                    }
                    catch (Throwable throwable) {
                        var5_6 = null;
                        man[i] = null;
                        throw throwable;
                    }
                    {
                        var5_6 = null;
                        man[i] = null;
                        ++i;
                    }
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.m_manager = null;
            man = null;
            throw throwable;
        }
        {
            Object var7_10 = null;
            this.m_manager = null;
        }
        man = null;
        this.m_seq = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final boolean execThread(ExecutionThread exec, Object value) throws InputException, AccessException {
        ObjectThread[] man = null;
        if (exec == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        boolean ret = false;
        try {
            try {
                Object object;
                block17: {
                    object = this.m_sync.get();
                    // MONITORENTER : object
                    man = this.m_manager;
                    if (this.m_manager != null) break block17;
                    this.clear();
                    // MONITOREXIT : object
                    Object var9_8 = null;
                    man = null;
                    return false;
                }
                int len = man.length;
                // MONITOREXIT : object
                int i = 0;
                ret = false;
                while (i < len) {
                    block18: {
                        object = this.m_sync.get();
                        // MONITORENTER : object
                        int seq = this.m_seq;
                        int n = this.m_seq = man.length <= seq ? 0 : seq + 1;
                        if (man[seq].isExec()) {
                            // MONITOREXIT : object
                            break block18;
                        }
                        if (!man[seq].isCreate()) {
                            man[seq].create();
                        }
                        man[seq].execThread(exec, value);
                        ret = true;
                        // MONITOREXIT : object
                        break;
                    }
                    ++i;
                }
            }
            catch (NullPointerException nul) {
                this.clear();
            }
            catch (Exception t) {
                this.clear();
                throw new AccessException(t);
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            man = null;
            throw throwable;
        }
        man = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getLength() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_manager.length;
            }
        }
        catch (Exception t) {
            ret = 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int getUseLength() {
        int ret;
        ObjectThread[] man = null;
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    man = this.m_manager;
                    int len = man.length;
                    int i = 0;
                    ret = 0;
                    while (true) {
                        block10: {
                            if (i < len) break block10;
                            break;
                        }
                        if (!man[i].isExec()) {
                            ++ret;
                        }
                        ++i;
                    }
                }
            }
            catch (Exception t) {
                ret = 0;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            man = null;
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        man = null;
        return ret;
    }
}

