/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.thread;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.thread.Synchronized;
import com.JRcServer.commons.util.CharTableSync;

public class ThreadState {
    private volatile boolean m_end_flg = false;
    private String m_name = null;
    private volatile int m_id = Integer.MIN_VALUE;
    private volatile int m_before_id = -1;
    private volatile long m_create_time = System.currentTimeMillis();
    private volatile long m_destroy_time = 0L;
    private volatile long m_last_access = System.currentTimeMillis();
    private CharTableSync m_table = null;
    private final Synchronized m_sync = new Synchronized();

    private ThreadState() {
    }

    protected ThreadState(Thread thread) throws InputException {
        if (thread == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.m_sync.create();
        this.m_name = thread.getName();
        this.m_table = new CharTableSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_table.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_sync.clear();
        if (this.m_id != -1) {
            this.m_before_id = this.m_id;
            this.m_id = -1;
        }
        this.m_name = null;
        this.m_end_flg = true;
        this.m_destroy_time = System.currentTimeMillis();
        this.m_last_access = System.currentTimeMillis();
        this.m_table = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void endThread() {
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    this.m_table.clear();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_id != -1) {
                this.m_before_id = this.m_id;
                this.m_id = -1;
            }
            this.m_name = null;
            this.m_end_flg = true;
            this.m_destroy_time = System.currentTimeMillis();
            this.m_last_access = System.currentTimeMillis();
            this.m_table = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setID(int id) {
        if (id < 0) {
            return;
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_id = id;
            }
        }
        catch (Exception t) {
            this.m_id = -1;
        }
    }

    public final void setLastAccessTime() {
        this.m_last_access = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setParameter(String name, Object value) throws InputException {
        if (name == null || value == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_table.add(name, value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final String getName() {
        String ret = null;
        ret = this.m_name;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getID() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_id;
            }
        }
        catch (Exception t) {
            ret = -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getBeforeID() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_before_id;
            }
        }
        catch (Exception t) {
            ret = -1;
        }
        return ret;
    }

    public final long getCreateTime() {
        long ret = this.m_create_time;
        return ret;
    }

    public final long getDestroyTime() {
        long ret = this.m_destroy_time;
        return ret;
    }

    public final long getLastAccessTime() {
        long ret = this.m_last_access;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getParameter(String name) {
        Object ret = null;
        if (name == null || name.length() <= 0) {
            return null;
        }
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_table.get(name);
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getParameterNames() {
        String[] ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_table.getNames();
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEndThread() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_end_flg;
            }
        }
        catch (Exception t) {
            ret = true;
        }
        return ret;
    }
}

