/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.thread;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.ExecutionException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.exception.SettingException;
import com.JRcServer.commons.thread.BaseThread;
import com.JRcServer.commons.thread.ExecutionThread;
import com.JRcServer.commons.thread.ProcessThread;
import com.JRcServer.commons.thread.Synchronized;
import com.JRcServer.commons.thread.ThreadManager;
import com.JRcServer.commons.thread.ThreadState;
import com.JRcServer.commons.util.UtilCom;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimerThread
extends ProcessThread {
    private static final Log LOG;
    private static final String RUN_NAME = "run";
    private static final String END_NAME = "end";
    private static final String STOP_NAME = "stop";
    private static final String TIMER_NAME = "timer";
    private ExecutionThread m_exec = null;
    private final BaseThread m_thread = new BaseThread();
    private ThreadState m_state = null;
    private volatile long m_nowTime = 0L;
    private final Synchronized m_sync = new Synchronized();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.JRcServer.commons.thread.TimerThread");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public TimerThread() {
    }

    public TimerThread(ExecutionThread exec, long time) throws InputException {
        this.create(exec, time);
    }

    public TimerThread(ExecutionThread exec, Object param, long time) throws InputException {
        this.create(exec, param, time);
    }

    public TimerThread(boolean mode, ExecutionThread exec, Object param, long time) throws InputException {
        this.create(mode, exec, param, time);
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void create(ExecutionThread exec, long time) throws InputException {
        this.create(exec, null, time);
    }

    public final void create(ExecutionThread exec, Object param, long time) throws InputException {
        this.create(true, exec, param, time);
    }

    public final void create(boolean mode, ExecutionThread exec, Object param, long time) throws InputException {
        if (exec == null || time <= 0L) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.clear();
        try {
            this.m_sync.create();
            this.m_thread.create(this, param, true);
            if (mode) {
                this.m_thread.setObjectName(exec.getClass().getName());
            } else {
                this.m_thread.setObjectName(null);
            }
            this.m_state = this.initState(time);
            this.m_exec = exec;
        }
        catch (Exception t) {
            this.clear();
        }
    }

    public final void clear() {
        this.m_sync.clear();
        try {
            this.m_thread.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_state.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_exec = null;
        this.m_state = null;
        this.m_nowTime = 0L;
    }

    public final void startThread() throws SettingException {
        if (!this.isExecution()) {
            throw new SettingException("\u8a2d\u5b9a\u60c5\u5831\u304c\u4e0d\u8db3\u3057\u3066\u3044\u308b\u305f\u3081\u3001\u30b9\u30ec\u30c3\u30c9\u3092\u5b9f\u65bd\u3067\u304d\u307e\u305b\u3093");
        }
        this.m_thread.startThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void exitThread() {
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    this.setFlg(END_NAME, true);
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            try {
                this.m_thread.exitThread();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var2_5 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        this.m_thread.exitThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopLoop() {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                boolean flg = !this.getFlg(STOP_NAME);
                this.setFlg(END_NAME, flg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void destroyThread() {
        try {
            try {
                Object object = this.m_sync.get();
                synchronized (object) {
                    this.setFlg(END_NAME, true);
                }
                UtilCom.idleSleep(500L);
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            try {
                this.m_thread.destroyThread();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var2_5 = null;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        this.m_thread.destroyThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPriority(int newPriority) throws InputException {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_thread.setPriority(newPriority);
            }
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getTime() {
        long ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = ((long[])this.m_state.getParameter(TIMER_NAME))[0];
            }
        }
        catch (Exception t) {
            ret = -1L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getState() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_thread.getThreadState();
            }
        }
        catch (Exception t) {
            ret = -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getThreadTime() {
        long ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_nowTime;
            }
        }
        catch (Exception t) {
            ret = 0L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getPriority() {
        int ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_thread.getPriority();
            }
        }
        catch (Exception t) {
            ret = -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ExecutionThread getExecutionThread() {
        ExecutionThread ret = null;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_exec;
            }
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isThread() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.getFlg(RUN_NAME);
            }
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isStop() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.getFlg(STOP_NAME);
            }
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEnd() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.getFlg(END_NAME);
            }
        }
        catch (Exception t) {
            ret = true;
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    protected void processThread(Object in) throws ExecutionException, ThreadDeath {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 8[TRYBLOCK] [12 : 339->343)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void destroyThread(Object in) throws Exception {
        this.m_exec.destroy(in);
    }

    protected void toException(ExecutionException err) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isExecution() {
        boolean ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_exec != null;
            }
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final ThreadState initState(long time) throws AccessException {
        boolean[] flg = null;
        long[] tm = null;
        ThreadState ret = null;
        try {
            try {
                ret = ThreadManager.getInstance().getState(this.m_thread.getName());
                if (ret == null) {
                    LOG.error((Object)("\u30b9\u30ec\u30c3\u30c9\u540d:" + this.m_thread.getName() + "\u306b\u5bfe\u3059\u308b\u30b9\u30ec\u30c3\u30c9\u306f\u5b58\u5728\u3057\u307e\u305b\u3093"));
                }
                flg = new boolean[]{false};
                ret.setParameter(RUN_NAME, flg);
                flg = new boolean[]{true};
                ret.setParameter(END_NAME, flg);
                flg = new boolean[]{false};
                ret.setParameter(STOP_NAME, flg);
                tm = new long[]{time};
                ret.setParameter(TIMER_NAME, tm);
            }
            catch (Exception t) {
                ret = null;
                throw new AccessException(t);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            flg = null;
            tm = null;
            throw throwable;
        }
        {
            Object var7_8 = null;
        }
        flg = null;
        tm = null;
        return ret;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void setFlg(String name, boolean flg) throws NullPointerException {
        boolean[] obj;
        ThreadState state = null;
        try {
            try {
                state = this.m_state;
                obj = (boolean[])state.getParameter(name);
                obj[0] = flg;
            }
            catch (Exception t) {
                throw new NullPointerException("\u30b9\u30c6\u30fc\u30bf\u30b9\u60c5\u5831\u306f\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            state = null;
            obj = null;
            throw throwable;
        }
        {
            Object var6_8 = null;
            state = null;
        }
        obj = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean getFlg(String name) throws NullPointerException {
        boolean ret;
        boolean[] obj;
        ThreadState state = null;
        try {
            try {
                state = this.m_state;
                obj = (boolean[])state.getParameter(name);
                ret = obj[0];
            }
            catch (Exception t) {
                throw new NullPointerException("\u30b9\u30c6\u30fc\u30bf\u30b9\u60c5\u5831\u306f\u65e2\u306b\u30af\u30ea\u30a2\u3055\u308c\u3066\u3044\u307e\u3059");
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            state = null;
            obj = null;
            throw throwable;
        }
        {
            Object var6_8 = null;
            state = null;
        }
        obj = null;
        return ret;
    }
}

