/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.util;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.ExecutionException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.exception.SettingException;
import com.JRcServer.commons.thread.ExecutionThread;
import com.JRcServer.commons.thread.LoopThread;
import com.JRcServer.commons.util.ArrayTable;
import com.JRcServer.commons.util.DataMonitor;
import com.JRcServer.commons.util.UtilCom;

public abstract class DataMonitorBase
extends ExecutionThread
implements DataMonitor {
    public static final long NOT_SET_TIMER = 0L;
    private static final int SLEEP_TIMING = 150;
    private LoopThread m_thread = null;
    private int m_timer = 0;
    private boolean m_isCreate = false;
    protected final ArrayTable m_table = new ArrayTable();
    protected final Object m_sync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void create(int timer) throws InputException, AccessException {
        LoopThread lt = null;
        if (timer <= 0) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        this.clear();
        Object object = this.m_sync;
        // MONITORENTER : object
        try {
            try {
                lt = new LoopThread(this);
                this.m_timer = timer;
                lt.startThread();
                this.m_thread = lt;
                this.m_isCreate = true;
            }
            catch (InputException in) {
                throw in;
            }
            catch (SettingException st) {
                throw new AccessException(st);
            }
            Object var5_8 = null;
            lt = null;
            // MONITOREXIT : object
            return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            lt = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        try {
            this.m_thread.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.m_table.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_thread = null;
        Object object = this.m_sync;
        synchronized (object) {
            this.m_isCreate = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void add(String key, Object obj) throws InputException, ExecutionException {
        DataMonitorPause pause = null;
        Object object = this.m_sync;
        // MONITORENTER : object
        if (!this.m_isCreate) {
            throw new ExecutionException("\u60c5\u5831\u8ffd\u52a0\u51e6\u7406\u3092\u884c\u3046\u3053\u3068\u306f\u4e0d\u53ef\u72b6\u614b\u3067\u3059");
        }
        // MONITOREXIT : object
        if (key == null) throw new InputException("\u5165\u529b\u60c5\u5831\u304c\u4e0d\u6b63\u3067\u3059");
        if (key.length() == 0) throw new InputException("\u5165\u529b\u60c5\u5831\u304c\u4e0d\u6b63\u3067\u3059");
        if (obj == null) {
            throw new InputException("\u5165\u529b\u60c5\u5831\u304c\u4e0d\u6b63\u3067\u3059");
        }
        pause = new DataMonitorPause();
        pause.MONITER_DATA = obj;
        pause.SET_TIME = System.currentTimeMillis();
        object = this.m_sync;
        // MONITORENTER : object
        try {
            this.m_table.add(key, pause);
            Object var6_8 = null;
            pause = null;
            // MONITOREXIT : object
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            pause = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void add(String key, Object obj, long timer) throws InputException, ExecutionException {
        DataMonitorPause pause = null;
        Object object = this.m_sync;
        // MONITORENTER : object
        if (!this.m_isCreate) {
            throw new ExecutionException("\u60c5\u5831\u8ffd\u52a0\u51e6\u7406\u3092\u884c\u3046\u3053\u3068\u306f\u4e0d\u53ef\u72b6\u614b\u3067\u3059");
        }
        // MONITOREXIT : object
        if (key == null) throw new InputException("\u5165\u529b\u60c5\u5831\u304c\u4e0d\u6b63\u3067\u3059");
        if (key.length() == 0) throw new InputException("\u5165\u529b\u60c5\u5831\u304c\u4e0d\u6b63\u3067\u3059");
        if (obj == null) {
            throw new InputException("\u5165\u529b\u60c5\u5831\u304c\u4e0d\u6b63\u3067\u3059");
        }
        pause = new DataMonitorPause();
        pause.MONITER_DATA = obj;
        pause.SET_TIME = timer;
        object = this.m_sync;
        // MONITORENTER : object
        try {
            this.m_table.add(key, pause);
            Object var8_9 = null;
            pause = null;
            // MONITOREXIT : object
            return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            pause = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void remove(String key) throws InputException {
        ArrayTable at = null;
        Object object = this.m_sync;
        // MONITORENTER : object
        try {
            block10: {
                at = this.m_table;
                int len = at.getElements(key);
                if (len == 0) break block10;
                int i = 0;
                while (true) {
                    if (i >= len) {
                        at.remove(key);
                        break;
                    }
                    ((DataMonitorPause)at.get((String)key, (int)i)).SET_TIME = 0L;
                    ++i;
                }
            }
            Object var7_9 = null;
            at = null;
            // MONITOREXIT : object
            return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            at = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(String key, int no) throws InputException {
        Object object = this.m_sync;
        synchronized (object) {
            ((DataMonitorPause)this.m_table.get((String)key, (int)no)).SET_TIME = 0L;
            this.m_table.remove(key, no);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public final Object[] get(String key) throws InputException {
        ArrayTable at = null;
        Object[] ret = null;
        Object object = this.m_sync;
        synchronized (object) {
            Object[] objectArray;
            try {
                at = this.m_table;
                int len = at.getElements(key);
                if (len == 0) {
                    Object[] objectArray2 = null;
                    {
                        Object var8_8 = null;
                        at = null;
                    }
                    return objectArray2;
                }
                ret = new Object[len];
                int i = 0;
                while (i < len) {
                    ret[i] = ((DataMonitorPause)at.get((String)key, (int)i)).MONITER_DATA;
                    ++i;
                }
                objectArray = ret;
            }
            catch (InputException in) {
                try {
                    throw in;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    at = null;
                    throw throwable;
                }
            }
            {
                Object var8_9 = null;
                at = null;
            }
            return objectArray;
        }
    }

    public final Object get(String key, int no) throws InputException {
        Object ret = null;
        Object object = this.m_sync;
        synchronized (object) {
            ret = ((DataMonitorPause)this.m_table.get((String)key, (int)no)).MONITER_DATA;
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPauseToNowTimer(String key, int no, long timer) throws InputException {
        if (key == null || no < 0) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        Object object = this.m_sync;
        synchronized (object) {
            ((DataMonitorPause)this.m_table.get((String)key, (int)no)).SET_TIME = timer;
        }
    }

    public final long getPauseToNowTimer(String key, int no) throws InputException {
        Object object = this.m_sync;
        synchronized (object) {
            long ret = ((DataMonitorPause)this.m_table.get((String)key, (int)no)).SET_TIME;
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getElements(String key) {
        int ret;
        Object object = this.m_sync;
        synchronized (object) {
            try {
                ret = this.m_table.getElements(key);
            }
            catch (Exception t) {
                ret = -1;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getLength() {
        int ret;
        Object object = this.m_sync;
        synchronized (object) {
            try {
                ret = this.m_table.getKeySize();
            }
            catch (Exception t) {
                ret = -1;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getAllSize() {
        int ret;
        Object object = this.m_sync;
        synchronized (object) {
            try {
                ret = this.m_table.size();
            }
            catch (Exception t) {
                ret = -1;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getKeys() {
        String[] ret = null;
        Object object = this.m_sync;
        synchronized (object) {
            try {
                ret = this.m_table.getNames();
            }
            catch (Exception t) {
                ret = null;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getTimer() {
        int ret;
        Object object = this.m_sync;
        synchronized (object) {
            ret = this.m_timer;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isCreate() {
        boolean ret;
        Object object = this.m_sync;
        synchronized (object) {
            ret = this.m_isCreate;
        }
        return ret;
    }

    public abstract void moniter() throws ExecutionException;

    protected final void init(Object obj) throws ExecutionException {
    }

    protected final void exit(Object obj) throws ExecutionException {
    }

    protected final void stop(Object obj) throws ExecutionException {
    }

    protected final void execution(Object obj) throws ExecutionException {
        UtilCom.idleTime();
        UtilCom.sleep(150L);
        this.moniter();
    }

    class DataMonitorPause {
        public long SET_TIME = 0L;
        public Object MONITER_DATA = null;

        DataMonitorPause() {
        }
    }
}

