/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.util;

import com.JRcServer.commons.exception.InputException;

public class DateCalc {
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    private static final int[][] MONTH_TABLE = new int[][]{{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};
    private static final String[] WEEK_JP = new String[]{"?", "\u65e5", "\u6708", "\u706b", "\u6c34", "\u6728", "\u91d1", "\u571f"};
    private static final String[] WEEK_ENG = new String[]{"?", "sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"};

    private DateCalc() {
    }

    public static final boolean checkLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static final int getLeapYearSize(int year) {
        return year / 4 - year / 100 + year / 400;
    }

    public static final int getDaysToWeek(int year, int month, int day) throws InputException {
        DateCalc.checkDays(year, month, day);
        return DateCalc.daysToWeek(year, month, day);
    }

    public static final String getDaysToWeek(boolean lang, int year, int month, int day) throws InputException {
        DateCalc.checkDays(year, month, day);
        return lang ? WEEK_JP[DateCalc.daysToWeek(year, month, day)] : WEEK_ENG[DateCalc.daysToWeek(year, month, day)];
    }

    public static final int getDaysOfMonth(int year, int month) throws InputException {
        int ret;
        try {
            ret = DateCalc.checkLeapYear(year) ? MONTH_TABLE[1][month - 1] : MONTH_TABLE[0][month - 1];
        }
        catch (Exception t) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return ret;
    }

    public static final int getDaysOfAD(int year, int month, int day) throws InputException {
        DateCalc.checkDays(year, month, day);
        if (month <= 2) {
            --year;
            month += 12;
        }
        return year * 365 + year / 4 - year / 100 + year / 400 + (13 * month + 8) / 5 + 28 * month - 34 - 365 + day;
    }

    public static final int getDaysDiff(int srcYear, int srcMonth, int srcDay, int dstYear, int dstMonth, int dstDay) throws InputException {
        int ret = DateCalc.getDaysOfAD(srcYear, srcMonth, srcDay) - DateCalc.getDaysOfAD(dstYear, dstMonth, dstDay);
        return ret;
    }

    public static final void getADToDays(int[] year, int[] month, int[] day, int ad) throws InputException {
        int[] monTbl = null;
        if (ad < 0 || year == null || month == null || day == null) {
            if (ad < 0) {
                throw new InputException("\u30de\u30a4\u30ca\u30b9\u5909\u63db\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int tpYear = 1;
        --ad;
        while (ad < 0 || ad >= (tpYear % 4 == 0 && tpYear % 100 != 0 || tpYear % 400 == 0 ? 366 : 365)) {
            int yt = tpYear + ad / 365 - (ad % 365 < 0 ? 1 : 0);
            int yt2 = yt - 1;
            int tpYear2 = tpYear - 1;
            ad -= (yt - tpYear) * 365 + (yt2 / 4 - yt2 / 100 + yt2 / 400) - (tpYear2 / 4 - tpYear2 / 100 + tpYear2 / 400);
            tpYear = yt;
        }
        monTbl = MONTH_TABLE[tpYear % 4 == 0 && tpYear % 100 != 0 || tpYear % 400 == 0 ? 1 : 0];
        int i = 0;
        while (i < 12) {
            if (ad < monTbl[i]) break;
            ad -= monTbl[i];
            ++i;
        }
        year[0] = tpYear;
        month[0] = i + 1;
        day[0] = ad + 1;
        monTbl = null;
    }

    public static final void getDaysToAdd(int[] year, int[] month, int[] day, int n) throws InputException {
        try {
            DateCalc.getADToDays(year, month, day, n += DateCalc.getDaysOfAD(year[0], month[0], day[0]));
        }
        catch (NullPointerException nul) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        catch (InputException in) {
            throw in;
        }
    }

    private static final int daysToWeek(int year, int month, int day) {
        if (month <= 2) {
            --year;
            month += 12;
        }
        return (year + year / 4 - year / 100 + year / 400 + (13 * month + 8) / 5 + day) % 7;
    }

    private static final void checkDays(int year, int month, int day) throws InputException {
        try {
            if (DateCalc.checkLeapYear(year) ? day <= 0 || day > MONTH_TABLE[1][month - 1] : day <= 0 || day > MONTH_TABLE[0][month - 1]) {
                throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            }
        }
        catch (InputException in) {
            throw in;
        }
        catch (Exception t) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
    }
}

