/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.util;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.serialize.SerializeUtil;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateTime
implements Serializable {
    private static final long serialVersionUID;
    public static final String WEEK_JP_SUNDAY = "\u65e5";
    public static final String WEEK_ENG_SUNDAY = "SUN";
    public static final String WEEK_JP_MONDAY = "\u6708";
    public static final String WEEK_ENG_MONDAY = "MON";
    public static final String WEEK_JP_TUESDAY = "\u706b";
    public static final String WEEK_ENG_TUESDAY = "TUE";
    public static final String WEEK_JP_WEDNESDAY = "\u6c34";
    public static final String WEEK_ENG_WEDNESDAY = "WED";
    public static final String WEEK_JP_THURSDAY = "\u6728";
    public static final String WEEK_ENG_THURSDAY = "THU";
    public static final String WEEK_JP_FRIDAY = "\u91d1";
    public static final String WEEK_ENG_FRIDAY = "FRI";
    public static final String WEEK_JP_SATURDAY = "\u571f";
    public static final String WEEK_ENG_SATURDAY = "SAT";
    public static final String EAR_AD = "A.D";
    public static final String EAR_BC = "B.C";
    public static final String ETC_CODE = "?";
    private Calendar m_cal = null;
    private Locale m_locale = null;
    private TimeZone m_timezone = null;
    private String m_ear = "?";
    private String m_weekJp = "?";
    private String m_weekEng = "?";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.JRcServer.commons.util.DateTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        serialVersionUID = SerializeUtil.serialVersionUID(clazz.getName());
    }

    public DateTime() {
        this.m_locale = null;
        this.m_timezone = null;
        this.clear();
    }

    public DateTime(Locale locale) {
        this.m_locale = locale;
        this.m_timezone = null;
        this.clear();
    }

    public DateTime(TimeZone timezone) {
        this.m_locale = null;
        this.m_timezone = timezone;
        this.clear();
    }

    public DateTime(Locale locale, TimeZone timezone) {
        this.m_locale = locale;
        this.m_timezone = timezone;
        this.clear();
    }

    public final void clear() {
        this.m_cal = null;
        this.m_ear = ETC_CODE;
        this.m_weekJp = ETC_CODE;
        this.m_weekEng = ETC_CODE;
        this.m_cal = this.m_locale != null ? (this.m_timezone != null ? new GregorianCalendar(this.m_timezone, this.m_locale) : new GregorianCalendar(this.m_locale)) : (this.m_timezone != null ? new GregorianCalendar(this.m_timezone) : new GregorianCalendar());
        this.m_cal.clear();
    }

    public final void setGregorioMode(boolean mode) {
        if (mode) {
            this.m_cal.set(0, 1);
            this.m_ear = EAR_AD;
        } else {
            this.m_cal.set(0, 0);
            this.m_ear = EAR_BC;
        }
    }

    public final boolean getGregorioMode() {
        return this.m_cal.get(0) == 1;
    }

    public final void setYear(int year) {
        this.m_cal.set(1, year);
    }

    public final int getYear() {
        return this.m_cal.get(1);
    }

    public final void setMonth(int month) {
        this.m_cal.set(2, month - 1);
    }

    public final int getMonth() {
        return this.m_cal.get(2) + 1;
    }

    public final void setDay(int day) {
        this.m_cal.set(5, day);
    }

    public final int getDay() {
        return this.m_cal.get(5);
    }

    public final void setHour(int hour) {
        this.m_cal.set(11, hour);
    }

    public final int getHour() {
        return this.m_cal.get(11);
    }

    public final void setMinutes(int minutes) {
        this.m_cal.set(12, minutes);
    }

    public final int getMinutes() {
        return this.m_cal.get(12);
    }

    public final void setSecond(int second) {
        this.m_cal.set(13, second);
    }

    public final int getSecond() {
        return this.m_cal.get(13);
    }

    public final void setMilliSecond(int milliSecond) {
        this.m_cal.set(14, milliSecond);
    }

    public final int getMilliSecond() {
        return this.m_cal.get(14);
    }

    public final String getWeek(boolean mode) {
        this.getWeekCode(this.m_cal);
        return mode ? this.m_weekJp : this.m_weekEng;
    }

    public final String getGregorio() {
        this.setEarCode(this.m_cal);
        return this.m_ear;
    }

    public final void setTime(long time) {
        this.m_cal.clear();
        this.m_cal.setTime(new Date(time));
    }

    public final long getTime() {
        return this.m_cal.getTime().getTime();
    }

    public final void setCalendarObject(Calendar date) throws InputException {
        if (date == null) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        DateTime.setCalendarInfo(date, this.m_cal);
    }

    public final Calendar getCalendarObject() {
        return this.getCalendarInfo();
    }

    public final void setDateObject(Date date) throws InputException {
        if (date == null) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        this.setTime(date.getTime());
    }

    public final Date getDateObject() {
        return new Date(this.getTime());
    }

    public final void setTimeObject(Time time) throws InputException {
        if (time == null) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        this.setTime(time.getTime());
    }

    public final Time getTimeObject() {
        return new Time(this.getTime());
    }

    public final void setTimestampObject(Timestamp time) throws InputException {
        if (time == null) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        this.setTime(time.getTime());
    }

    public final Timestamp getTimestampObject() {
        return new Timestamp(this.getTime());
    }

    public final void nowTimestamp() {
        this.setTime(System.currentTimeMillis());
    }

    public final String toString() {
        String ret = null;
        StringBuffer buf = null;
        Calendar cal = null;
        buf = new StringBuffer();
        cal = this.m_cal;
        buf.append("[");
        buf.append(this.getGregorio());
        buf.append("]");
        buf.append(cal.get(1));
        buf.append("/");
        buf.append(cal.get(2) + 1);
        buf.append("/");
        buf.append(cal.get(5));
        buf.append(" ");
        buf.append(cal.get(11));
        buf.append(":");
        buf.append(cal.get(12));
        buf.append(":");
        buf.append(cal.get(13));
        buf.append(".");
        buf.append(cal.get(14));
        buf.append("(");
        buf.append(this.getWeek(true));
        buf.append(")");
        ret = buf.toString().trim();
        buf = null;
        cal = null;
        return ret;
    }

    private static final void setCalendarInfo(Calendar src, Calendar dest) {
        dest.clear();
        dest.set(1, src.get(1));
        dest.set(2, src.get(2));
        dest.set(5, src.get(5));
        dest.set(11, src.get(11));
        dest.set(12, src.get(12));
        dest.set(13, src.get(13));
        dest.set(14, src.get(14));
        dest.set(0, src.get(0));
    }

    private final Calendar getCalendarInfo() {
        GregorianCalendar ret = null;
        ret = new GregorianCalendar();
        DateTime.setCalendarInfo(this.m_cal, ret);
        return ret;
    }

    private final void getWeekCode(Calendar date) {
        switch (date.get(7)) {
            case 1: {
                this.m_weekJp = WEEK_JP_SUNDAY;
                this.m_weekEng = WEEK_ENG_SUNDAY;
                break;
            }
            case 2: {
                this.m_weekJp = WEEK_JP_MONDAY;
                this.m_weekEng = WEEK_ENG_MONDAY;
                break;
            }
            case 3: {
                this.m_weekJp = WEEK_JP_TUESDAY;
                this.m_weekEng = WEEK_ENG_TUESDAY;
                break;
            }
            case 4: {
                this.m_weekJp = WEEK_JP_WEDNESDAY;
                this.m_weekEng = WEEK_ENG_WEDNESDAY;
                break;
            }
            case 5: {
                this.m_weekJp = WEEK_JP_THURSDAY;
                this.m_weekEng = WEEK_ENG_THURSDAY;
                break;
            }
            case 6: {
                this.m_weekJp = WEEK_JP_FRIDAY;
                this.m_weekEng = WEEK_ENG_FRIDAY;
                break;
            }
            case 7: {
                this.m_weekJp = WEEK_JP_SATURDAY;
                this.m_weekEng = WEEK_ENG_SATURDAY;
                break;
            }
            default: {
                this.m_weekJp = ETC_CODE;
                this.m_weekEng = ETC_CODE;
            }
        }
    }

    private final void setEarCode(Calendar date) {
        switch (date.get(0)) {
            case 1: {
                this.m_ear = EAR_AD;
                break;
            }
            case 0: {
                this.m_ear = EAR_BC;
                break;
            }
            default: {
                this.m_ear = ETC_CODE;
            }
        }
    }
}

