/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.util;

import com.JRcServer.commons.serialize.InitSerialize;
import com.JRcServer.commons.serialize.SerializeUtil;
import com.JRcServer.commons.thread.Synchronized;
import com.JRcServer.commons.util.SearchLong;
import com.JRcServer.commons.util.UtilCom;

public class IdManagerEx
implements InitSerialize {
    private static final long serialVersionUID;
    public static final long NOT_ID = -1L;
    public static final int SEARCH_LENGTH = 1000000;
    private final SearchLong m_num = new SearchLong();
    private long m_maxID = 0L;
    private long m_startID = 0L;
    private long m_id = 0L;
    private volatile boolean m_tblFlg = false;
    private final Synchronized m_sync = new Synchronized();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.JRcServer.commons.util.IdManagerEx");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        serialVersionUID = SerializeUtil.serialVersionUID(clazz.getName());
    }

    public IdManagerEx() {
        this.create(0L, Long.MAX_VALUE);
    }

    public IdManagerEx(long start, long max) {
        this.create(start, max);
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initSerializable() {
        this.m_sync.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void create(long start, long max) {
        if (start < 0L || max < 1L || start >= max || max > Long.MAX_VALUE) {
            start = 0L;
            max = Long.MAX_VALUE;
        }
        this.clear();
        this.m_sync.create();
        try {
            Synchronized synchronized_ = this.m_sync;
            synchronized (synchronized_) {
                this.m_num.create();
                this.m_maxID = max;
                this.m_startID = start;
                this.m_id = 0L;
                this.setTblOn();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        this.m_sync.clear();
        this.m_sync.create();
        this.setTblOff();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_num.clear();
                this.m_id = this.m_startID;
            }
        }
        catch (NullPointerException nul) {
            this.m_num.clear();
            this.m_id = this.m_startID;
        }
        this.m_tblFlg = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addUseID(long id) {
        this.renewTable();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                if (this.m_startID <= id && this.m_maxID >= id && !this.m_num.isData(id)) {
                    this.m_num.add(id);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long getID() {
        long maxID;
        long startID;
        Object object;
        SearchLong tbl = null;
        this.renewTable();
        long ret = -1L;
        int len = 1000000;
        boolean okFlg = false;
        try {
            object = this.m_sync.get();
            synchronized (object) {
                tbl = this.m_num;
                startID = this.m_startID;
                maxID = this.m_maxID;
                if (maxID - startID <= (long)tbl.size()) {
                    return -1L;
                }
            }
        }
        catch (NullPointerException nul) {
            return -1L;
        }
        while (true) {
            int i = 0;
            while (i < len) {
                object = this.m_sync.get();
                synchronized (object) {
                    ret = this.m_id;
                    long l = this.m_id = ret >= maxID ? startID : ret + 1L;
                    if (!tbl.isData(ret)) {
                        tbl.add(ret);
                        okFlg = true;
                        break;
                    }
                }
                ++i;
            }
            if (okFlg) {
                return ret;
            }
            UtilCom.cpuCreate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeID(long id) {
        this.renewTable();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_num.remove(id);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getStartID() {
        long ret;
        this.renewTable();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_startID;
            }
        }
        catch (NullPointerException nul) {
            ret = -1L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getMaxID() {
        long ret;
        this.renewTable();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_maxID;
            }
        }
        catch (NullPointerException nul) {
            ret = -1L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getUseIDSize() {
        int ret;
        this.renewTable();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_num.size();
            }
        }
        catch (NullPointerException nul) {
            ret = 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long[] getUseIDs() {
        long[] ret = null;
        this.renewTable();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_num.getAll();
            }
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isUseID(long id) {
        boolean ret;
        this.renewTable();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_num.isData(id);
            }
        }
        catch (NullPointerException nul) {
            ret = false;
        }
        return ret;
    }

    private final synchronized void renewTable() {
        if (!this.m_tblFlg) {
            this.m_num.create();
            this.m_tblFlg = true;
        }
    }

    private final synchronized void setTblOn() {
        this.m_tblFlg = true;
    }

    private final synchronized void setTblOff() {
        this.m_tblFlg = false;
    }
}

