/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.util;

import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.thread.Synchronized;
import com.JRcServer.commons.util.ReadIndex;
import com.JRcServer.commons.util.array.ObjectArray;

public class MemoryIndex
implements ReadIndex {
    private final ObjectArray m_array = new ObjectArray();
    private final Synchronized m_sync = new Synchronized();

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void clear() {
        this.m_sync.clear();
        this.m_array.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addIndex(String value) throws InputException {
        if (value == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.createSync();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_array.add(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getIndex(int no) throws InputException, AccessException {
        Object ret = null;
        this.createSync();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_array.get(no);
            }
            if (ret == null) {
                throw new AccessException("\u5bfe\u8c61\u306e\u9805\u756a(" + no + ")\u306b\u5bfe\u3057\u3066\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
        }
        catch (AccessException ac) {
            throw ac;
        }
        catch (Exception t) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int size() {
        int ret;
        this.createSync();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_array.size();
            }
            ret = ret == 0 ? -1 : ret;
        }
        catch (Exception t) {
            ret = -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isIndex() {
        boolean ret;
        this.createSync();
        try {
            int len;
            Object object = this.m_sync.get();
            synchronized (object) {
                len = this.m_array.size();
            }
            ret = len != 0;
        }
        catch (Exception t) {
            ret = false;
        }
        return ret;
    }

    private final void createSync() {
        if (!this.m_sync.isUse()) {
            this.m_sync.create();
        }
    }
}

