/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.util;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.serialize.SerializeUtil;
import com.JRcServer.commons.util.SearchInt;
import com.JRcServer.commons.util.array.IntArray;
import java.io.Serializable;

public class NumberSearchArray
implements Serializable {
    private static final long serialVersionUID;
    private static final int DEF_SEARCH = 4;
    private final IntArray m_array = new IntArray();
    private final SearchInt m_search = new SearchInt();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.JRcServer.commons.util.NumberSearchArray");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        serialVersionUID = SerializeUtil.serialVersionUID(clazz.getName());
    }

    public NumberSearchArray() {
        try {
            this.m_search.create();
        }
        catch (Exception e) {
            this.clear();
        }
    }

    protected final void finalize() throws Exception {
        try {
            this.m_array.clear();
            this.m_search.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void clear() {
        this.m_array.clear();
        this.m_search.clear();
        try {
            this.m_search.create();
        }
        catch (Exception e) {
            this.m_search.clear();
        }
    }

    public final void add(int num) throws InputException {
        if (this.m_search.isData(num)) {
            throw new InputException("\u5bfe\u8c61\u306e\u6570\u5024(" + num + ")\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059");
        }
        this.m_array.add(num);
        this.m_search.add(num);
    }

    public final void removeByNumber(int num) {
        IntArray ary = null;
        if (this.m_search.isData(num)) {
            ary = this.m_array;
            int len = ary.size();
            int i = 0;
            while (i < len) {
                if (ary.get(i) == num) {
                    ary.remove(i);
                    break;
                }
                ++i;
            }
            this.m_search.remove(num);
        }
    }

    public final void removeByArray(int no) {
        if (no >= 0 || no < this.m_array.size()) {
            int num = this.m_array.get(no);
            this.m_search.remove(num);
        }
    }

    public final int get(int cnt) {
        return this.m_array.get(cnt);
    }

    public final boolean isData(int num) {
        return this.m_search.isData(num);
    }

    public final int size() {
        return this.m_array.size();
    }

    public final int[] getNumbers() {
        int[] ret = null;
        int len = this.m_array.size();
        if (len > 0) {
            ret = new int[len];
            System.arraycopy(this.m_array.getObjects(), 0, ret, 0, len);
        }
        return ret;
    }
}

