/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.util;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.util.Roll;

public class RollObject
implements Roll {
    private static final int DEF_SIZE = 32;
    private Object[] m_roll = null;
    private int m_max = 0;
    private int m_now = 0;
    private int m_nowLen = 0;
    private int m_addResCnt = 0;

    private RollObject() {
    }

    public RollObject(int max) throws InputException {
        Object[] roll = null;
        max = max <= 32 ? 32 : max;
        roll = new Object[max];
        int i = 0;
        while (i < max) {
            roll[i] = null;
            ++i;
        }
        this.m_roll = roll;
        this.m_max = max;
        this.m_now = 0;
        this.m_nowLen = 0;
    }

    protected final void finalize() throws Exception {
        this.destroy();
    }

    public final void destroy() {
        Object[] roll = null;
        int len = this.m_max;
        if (len > 0) {
            roll = this.m_roll;
            int i = 0;
            while (i < len) {
                roll[i] = null;
                ++i;
            }
        }
        this.m_roll = null;
        this.m_max = 0;
        this.m_now = 0;
        this.m_nowLen = 0;
        this.m_addResCnt = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addReservationByON() {
        RollObject rollObject = this;
        synchronized (rollObject) {
            ++this.m_addResCnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addReservationByOFF() {
        RollObject rollObject = this;
        synchronized (rollObject) {
            this.m_addResCnt = this.m_addResCnt <= 0 ? 0 : this.m_addResCnt - 1;
        }
    }

    public final boolean add(Object value) throws InputException {
        return this.addTo(false, value);
    }

    public final boolean addHead(Object value) throws InputException {
        return this.addTo(true, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object get() {
        Object ret = null;
        RollObject rollObject = this;
        synchronized (rollObject) {
            if (this.m_nowLen <= 0) {
                ret = null;
            } else {
                int pnt = this.m_now - this.m_nowLen;
                if (pnt < 0) {
                    pnt = this.m_max + pnt;
                }
                ret = this.m_roll[pnt];
                this.m_roll[pnt] = null;
                --this.m_nowLen;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getMax() {
        int ret;
        RollObject rollObject = this;
        synchronized (rollObject) {
            ret = this.m_max;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getSize() {
        int ret;
        RollObject rollObject = this;
        synchronized (rollObject) {
            ret = this.m_nowLen;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAdd() {
        boolean ret;
        RollObject rollObject = this;
        synchronized (rollObject) {
            if (this.m_nowLen + this.m_addResCnt >= this.m_max) {
                boolean bl = false;
            }
            ret = true;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAddReservation() {
        boolean ret;
        RollObject rollObject = this;
        synchronized (rollObject) {
            ret = this.m_addResCnt > 0;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean addTo(boolean hlMode, Object value) throws InputException {
        boolean ret = false;
        if (value == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        RollObject rollObject = this;
        synchronized (rollObject) {
            if (this.m_nowLen + this.m_addResCnt >= this.m_max) {
                ret = false;
            } else {
                int next = this.getAddPoint(hlMode);
                this.m_roll[next] = null;
                this.m_roll[next] = value;
                ret = true;
            }
        }
        return ret;
    }

    private final int getAddPoint(boolean hlMode) {
        int ret = this.m_now;
        if (hlMode) {
            if (this.m_nowLen > 0) {
                ret = this.m_now - this.m_nowLen;
                if (ret < 0) {
                    ret = this.m_max + ret;
                }
                if (--ret < 0) {
                    ret = this.m_max - 1;
                }
            } else {
                if (ret >= this.m_max) {
                    ret = 0;
                }
                this.m_now = ret + 1;
            }
            ++this.m_nowLen;
        } else {
            if (ret >= this.m_max) {
                ret = 0;
            }
            ++this.m_nowLen;
            this.m_now = ret + 1;
        }
        return ret;
    }
}

