/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.util;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.serialize.InitSerialize;
import com.JRcServer.commons.serialize.SerializeUtil;
import com.JRcServer.commons.thread.Synchronized;

public class SequenceIDEx
implements InitSerialize {
    private static final long serialVersionUID;
    public static final long NOT_ID = Long.MIN_VALUE;
    private long m_maxID = 0L;
    private long m_startID = 0L;
    private long m_id = 0L;
    private long m_returnTimeout = 0L;
    private final Synchronized m_sync = new Synchronized();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.JRcServer.commons.util.SequenceIDEx");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        serialVersionUID = SerializeUtil.serialVersionUID(clazz.getName());
    }

    public SequenceIDEx() {
        this.create();
    }

    public SequenceIDEx(long start, long max) {
        try {
            this.create(start, max);
        }
        catch (InputException inputException) {
            // empty catch block
        }
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initSerializable() {
        this.m_sync.create();
    }

    public void create() {
        try {
            this.create(0L, Long.MAX_VALUE);
        }
        catch (InputException inputException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void create(long start, long max) throws InputException {
        if (start < 0L || max <= 1L || start >= max - 1L || max > Long.MAX_VALUE) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.clear();
        this.m_sync.create();
        try {
            Synchronized synchronized_ = this.m_sync;
            synchronized (synchronized_) {
                this.m_maxID = max;
                this.m_startID = start;
                this.m_id = start;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        this.m_sync.clear();
        this.m_sync.create();
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_id = this.m_startID;
                this.m_returnTimeout = System.currentTimeMillis();
            }
        }
        catch (NullPointerException nul) {
            this.m_id = this.m_startID;
            this.m_returnTimeout = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getID() {
        long ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_id;
                if (ret >= this.m_maxID) {
                    this.m_returnTimeout = System.currentTimeMillis();
                    this.m_id = this.m_startID;
                } else {
                    this.m_id = ret + 1L;
                }
            }
        }
        catch (NullPointerException nul) {
            ret = Long.MIN_VALUE;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setNextID(long id) {
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                this.m_id = id <= this.m_startID || id >= this.m_maxID ? (id <= this.m_startID ? this.m_startID : this.m_maxID) : id;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getStartID() {
        long ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_startID;
            }
        }
        catch (NullPointerException nul) {
            ret = Long.MIN_VALUE;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getMaxID() {
        long ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_maxID;
            }
        }
        catch (NullPointerException nul) {
            ret = Long.MIN_VALUE;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getReturnIDByTime() {
        long ret;
        try {
            Object object = this.m_sync.get();
            synchronized (object) {
                ret = this.m_returnTimeout;
            }
        }
        catch (NullPointerException nul) {
            ret = 0L;
        }
        return ret;
    }
}

