/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.util;

import com.JRcServer.commons.def.BaseDef;
import com.JRcServer.commons.exception.AccessException;
import com.JRcServer.commons.exception.ExecutionException;
import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.exception.ReadException;
import com.JRcServer.commons.exception.UnsupportException;
import com.JRcServer.commons.resource.BinResource;
import com.JRcServer.commons.resource.Resource;
import com.JRcServer.commons.thread.ThreadManager;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Random;

public class UtilCom {
    public static final int TIMESTAMP_STRING_LENGTH = 9;
    public static final int YEAR = 0;
    public static final int MONTH = 1;
    public static final int DAY = 2;
    public static final int HOUR = 3;
    public static final int MINUTE = 4;
    public static final int SECOND = 5;
    public static final int MILLISECOND = 6;
    public static final int WEEK_JP = 7;
    public static final int WEEK_ENG = 8;
    private static final int RAND_STRING_TO_NUMBER = 0;
    private static final int RAND_STRING_TO_HALF_ASC = 1;
    private static final int RAND_STRING_TO_FULL_ASC = 2;
    private static final int RAND_STRING_TO_NUBER_BY_LENGTH = 9;
    private static final int RAND_STRING_TO_HALF_BY_LENGTH = 25;
    private static final int RAND_STRING_TO_FULL_BY_LENGTH = 25;
    protected static final char[] convert10To16 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String CHECK_SJIS_CHARSET = "Shift_JIS";
    private static final String ADD_REM_CODE = " ";
    private static final Random RAND = new Random(System.currentTimeMillis());
    private static final char SNGLCOTE = "'".charAt(0);
    private static final char DBLLCOTE = "\"".charAt(0);
    public static final long CPU_CREATE = 15L;

    private UtilCom() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void randomize() {
        Random random = RAND;
        synchronized (random) {
            RAND.setSeed(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int random(int max) {
        int ret;
        Random random = RAND;
        synchronized (random) {
            ret = RAND.nextInt(max);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void randomBinary(byte[] out) throws InputException {
        if (out == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        Random random = RAND;
        synchronized (random) {
            RAND.nextBytes(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] randomBinary(int length) throws InputException {
        byte[] ret = null;
        if (length <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ret = new byte[length];
        Random random = RAND;
        synchronized (random) {
            RAND.nextBytes(ret);
        }
        return ret;
    }

    public static final String randomString(int size, boolean number, boolean half, boolean full) {
        int rnd = 0;
        int randSize = 0;
        int[] check = null;
        String ret = null;
        StringBuffer buf = null;
        if (size <= 0 || !number && !half && !full) {
            if (!(number || half || full)) {
                number = true;
            } else {
                return null;
            }
        }
        check = new int[3];
        if (number) {
            check[randSize] = 0;
            ++randSize;
        }
        if (half) {
            check[randSize] = 1;
            ++randSize;
        }
        if (full) {
            check[randSize] = 1;
            ++randSize;
        }
        buf = new StringBuffer(size);
        int i = 0;
        while (i < size) {
            rnd = UtilCom.random(randSize);
            switch (check[rnd]) {
                case 0: {
                    buf.append((char)(48 + (byte)UtilCom.random(9)));
                    break;
                }
                case 1: {
                    buf.append((char)(97 + (byte)UtilCom.random(25)));
                    break;
                }
                case 2: {
                    buf.append((char)(65 + (byte)UtilCom.random(25)));
                    break;
                }
                default: {
                    buf.append((char)(48 + (byte)UtilCom.random(9)));
                }
            }
            ++i;
        }
        ret = buf.toString();
        buf = null;
        check = null;
        return ret;
    }

    public static final String getArgument(String[] argument, String check) {
        boolean flg = true;
        String tmp = null;
        String ret = null;
        if (argument == null || check == null || argument.length == 0 || check.length() == 0) {
            return null;
        }
        int len = argument.length;
        check = check.toLowerCase();
        int i = 0;
        while (i < len) {
            tmp = argument[i].trim().toLowerCase();
            if (tmp.indexOf(check) != -1) {
                ret = new String(argument[i].substring(check.length()));
                if (ret != null && ret.length() > 0) break;
                ret = "";
                break;
            }
            ++i;
        }
        return ret;
    }

    public static final void cpuCreate() {
        try {
            Thread.sleep(15L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void idleTime() throws ExecutionException {
        try {
            ThreadManager.isExit();
            Thread.sleep(15L);
        }
        catch (InterruptedException ie) {
            throw new ExecutionException(ie, 254);
        }
        catch (ExecutionException ex) {
            throw ex;
        }
    }

    public static final void sleep(long min) {
        long delay = System.currentTimeMillis() + min;
        do {
            UtilCom.cpuCreate();
        } while (delay > System.currentTimeMillis());
    }

    public static final void idleSleep(long min) throws ExecutionException {
        long delay = System.currentTimeMillis() + min;
        do {
            UtilCom.idleTime();
        } while (delay > System.currentTimeMillis());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String[] getClassPathByStrings() {
        ArrayList lst = null;
        String[] ret = null;
        try {
            try {
                int len;
                lst = UtilCom.getClassPath();
                if (lst != null && (len = lst.size()) > 0) {
                    ret = new String[len];
                    int i = 0;
                    while (i < len) {
                        ret[i] = (String)lst.get(i);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                ret = null;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (lst != null) {
                lst.clear();
            }
            lst = null;
            throw throwable;
        }
        {
            Object var5_7 = null;
            if (lst != null) {
                lst.clear();
            }
            lst = null;
            return ret;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final ArrayList getClassPath() {
        String check = null;
        String pathCode = null;
        pathCode = System.getProperty("java.class.path");
        try {
            try {
                check = System.getProperty("path.separator");
                return UtilCom.pauseString(pathCode, check);
            }
            catch (InputException in) {
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            check = null;
            pathCode = null;
            throw throwable;
        }
    }

    public static final int[] getZenToHanString(String code) throws InputException {
        int len;
        int[] ret = null;
        if (code == null || (len = code.length()) <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ret = new int[len];
        int i = 0;
        while (i < len) {
            char one = code.charAt(i);
            ret[i] = one <= '\u00ff' ? 1 : 2;
            ++i;
        }
        return ret;
    }

    public static final String getPlusName(String name) throws InputException {
        String ret = null;
        if (name == null || name.length() <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int pnt = 0;
        int bef = -1;
        while ((pnt = name.indexOf(".", pnt)) != -1) {
            bef = pnt++;
        }
        if (bef != -1) {
            ret = name.substring(bef + 1);
        }
        return ret != null && ret.length() > 0 ? ret.trim().toLowerCase() : null;
    }

    public static final boolean equalString(String org, String src) {
        if (org != null && src != null) {
            return org.equalsIgnoreCase(src);
        }
        return false;
    }

    public static final String convertChar(String code, String src, String dest) throws InputException {
        StringBuffer buf = null;
        if (code == null || src == null || dest == null) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        char srcChr = src.charAt(0);
        char destChr = dest.charAt(0);
        int len = code.length();
        buf = new StringBuffer();
        int i = 0;
        while (i < len) {
            char info = code.charAt(i);
            info = info == srcChr ? destChr : info;
            buf.append(info);
            ++i;
        }
        String ret = buf.toString();
        buf = null;
        return ret;
    }

    public static final boolean checkFront(String info, String check) throws InputException {
        int chkLen;
        int len;
        if (info == null || check == null || (len = info.length()) <= 0 || (chkLen = check.length()) <= 0) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        char spaceChr = ADD_REM_CODE.charAt(0);
        char space2Chr = "\u3000".charAt(0);
        char tabChr = "\t".charAt(0);
        --chkLen;
        int i = 0;
        int j = 0;
        boolean ret = false;
        while (i < len) {
            char infoChr = info.charAt(i);
            if (infoChr == check.charAt(j)) {
                if (j >= chkLen) {
                    ret = true;
                    break;
                }
                ++j;
            } else if (infoChr != spaceChr && infoChr != space2Chr && infoChr != tabChr || j != 0) {
                ret = false;
                break;
            }
            ++i;
        }
        return ret;
    }

    public static final int checkCountByStirng(String str, String check) {
        int len;
        if (str == null || str.length() <= 0 || check == null || (len = check.length()) <= 0) {
            return 0;
        }
        int ret = 0;
        int pnt = 0;
        while ((pnt = str.indexOf(check, pnt)) > -1) {
            pnt += len;
            ++ret;
        }
        return ret;
    }

    public static final ArrayList pauseString(String str, String check) throws InputException {
        ArrayList ret = null;
        ret = new ArrayList();
        UtilCom.pauseString(ret, str, check);
        return ret;
    }

    public static final void pauseString(ArrayList out, String str, String check) throws InputException {
        int len;
        int s = -1;
        char[] checkCode = null;
        String tmp = null;
        if (out == null || str == null || (len = str.length()) <= 0 || check == null || check.length() <= 0) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        out.clear();
        int lenJ = check.length();
        checkCode = new char[lenJ];
        check.getChars(0, lenJ, checkCode, 0);
        if (lenJ == 1) {
            int i = 0;
            s = -1;
            while (i < len) {
                char strCode = str.charAt(i);
                int n = s = s == -1 ? i : s;
                if (strCode == checkCode[0]) {
                    if (s < i) {
                        tmp = str.substring(s, i);
                        out.add(tmp);
                        tmp = null;
                        s = -1;
                    } else {
                        s = -1;
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            s = -1;
            while (i < len) {
                char strCode = str.charAt(i);
                s = s == -1 ? i : s;
                int j = 0;
                while (j < lenJ) {
                    if (strCode == checkCode[j]) {
                        if (s < i) {
                            tmp = str.substring(s, i);
                            out.add(tmp);
                            tmp = null;
                            s = -1;
                            break;
                        }
                        s = -1;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (s != -1) {
            tmp = str.substring(s, len);
            out.add(tmp);
            tmp = null;
        }
        checkCode = null;
        tmp = null;
    }

    public static final ArrayList pauseString(boolean cote, String str, String check) throws InputException {
        ArrayList ret = null;
        ret = new ArrayList();
        UtilCom.pauseString(ret, cote, false, str, check);
        return ret;
    }

    public static final void pauseString(ArrayList out, boolean cote, String str, String check) throws InputException {
        UtilCom.pauseString(out, cote, false, str, check);
    }

    public static final ArrayList pauseString(boolean cote, boolean mode, String str, String check) throws InputException {
        ArrayList ret = null;
        ret = new ArrayList();
        UtilCom.pauseString(ret, cote, mode, str, check);
        return ret;
    }

    public static final void pauseString(ArrayList out, boolean cote, boolean coteFlg, String str, String check) throws InputException {
        int s = -1;
        char[] checkCode = null;
        String tmp = null;
        if (!cote) {
            UtilCom.pauseString(out, str, check);
        } else {
            char coteChr;
            int len;
            if (out == null || str == null || (len = str.length()) <= 0 || check == null || check.length() <= 0) {
                throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
            }
            out.clear();
            int lenJ = check.length();
            checkCode = new char[lenJ];
            check.getChars(0, lenJ, checkCode, 0);
            if (lenJ == 1) {
                int i = 0;
                s = -1;
                coteChr = '\u0000';
                while (i < len) {
                    char strCode;
                    char nowChr = strCode = str.charAt(i);
                    int n = s = s == -1 ? i : s;
                    if (coteChr == '\u0000') {
                        if (nowChr == SNGLCOTE || nowChr == DBLLCOTE) {
                            coteChr = nowChr;
                            if (s < i) {
                                tmp = str.substring(s, i);
                                out.add(tmp);
                                tmp = null;
                                s = -1;
                            } else {
                                s = -1;
                            }
                        } else if (strCode == checkCode[0]) {
                            if (s < i) {
                                tmp = str.substring(s, i);
                                out.add(tmp);
                                tmp = null;
                                s = -1;
                            } else {
                                s = -1;
                            }
                        }
                    } else if (coteChr == nowChr) {
                        coteChr = '\u0000';
                        if (s == i && coteFlg) {
                            out.add("" + strCode + strCode);
                            s = -1;
                        } else if (s < i) {
                            tmp = coteFlg ? str.substring(s - 1, i + 1) : str.substring(s, i);
                            out.add(tmp);
                            tmp = null;
                            s = -1;
                        } else {
                            s = -1;
                        }
                    }
                    ++i;
                }
            } else {
                int i = 0;
                s = -1;
                coteChr = '\u0000';
                while (i < len) {
                    char strCode;
                    char nowChr = strCode = str.charAt(i);
                    int n = s = s == -1 ? i : s;
                    if (coteChr == '\u0000') {
                        if (nowChr == SNGLCOTE || nowChr == DBLLCOTE) {
                            coteChr = nowChr;
                            if (s < i) {
                                tmp = str.substring(s, i);
                                out.add(tmp);
                                tmp = null;
                                s = -1;
                            } else {
                                s = -1;
                            }
                        } else {
                            int j = 0;
                            while (j < lenJ) {
                                if (strCode == checkCode[j]) {
                                    if (s < i) {
                                        tmp = str.substring(s, i);
                                        out.add(tmp);
                                        tmp = null;
                                        s = -1;
                                    } else {
                                        s = -1;
                                    }
                                    break;
                                }
                                ++j;
                            }
                        }
                    } else if (coteChr == nowChr) {
                        coteChr = '\u0000';
                        if (s == i && coteFlg) {
                            out.add("" + strCode + strCode);
                            s = -1;
                        } else if (s < i) {
                            tmp = coteFlg ? str.substring(s - 1, i + 1) : str.substring(s, i);
                            out.add(tmp);
                            tmp = null;
                            s = -1;
                        } else {
                            s = -1;
                        }
                    }
                    ++i;
                }
            }
            if (s != -1) {
                tmp = coteChr != '\u0000' && coteFlg ? String.valueOf(str.substring(s - 1, len)) + coteChr : str.substring(s, len);
                out.add(tmp);
                tmp = null;
            }
            checkCode = null;
            tmp = null;
        }
    }

    public static final ArrayList pauseBinary(byte[] str, byte[] check) throws InputException {
        int chkLen;
        int len;
        byte[] tmp = null;
        ArrayList<byte[]> ret = null;
        if (str == null || (len = str.length) <= 0 || check == null || (chkLen = check.length) <= 0) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        ret = new ArrayList<byte[]>();
        if (len <= chkLen) {
            tmp = new byte[len];
            System.arraycopy(str, 0, tmp, 0, len);
            ret.add(tmp);
        } else {
            int tmpLen;
            int i = 0;
            int j = 0;
            int s = -1;
            while (i < len) {
                if (s == -1) {
                    s = i;
                }
                if (str[i] == check[j]) {
                    if (j >= chkLen) {
                        tmpLen = i - s - chkLen;
                        tmp = new byte[tmpLen];
                        System.arraycopy(str, s, tmp, 0, tmpLen);
                        ret.add(tmp);
                        tmp = null;
                        s = -1;
                        j = 0;
                    } else {
                        ++j;
                    }
                } else {
                    j = 0;
                }
                ++i;
            }
            if (s != -1) {
                tmpLen = len - 1 - s + 1;
                tmp = new byte[tmpLen];
                System.arraycopy(str, s, tmp, 0, tmpLen);
                ret.add(tmp);
                tmp = null;
            }
        }
        return ret;
    }

    public static final int indexOfBinary(byte[] src, byte[] code, int offset) {
        int lenJ;
        int len;
        if (src == null || (len = src.length) <= 0 || code == null || (lenJ = code.length) <= 0 || offset < 0 || offset > len) {
            return -1;
        }
        int i = offset;
        int ret = -1;
        int j = 0;
        while (i < len) {
            if (src[i] == code[j]) {
                if (++j >= lenJ) {
                    ret = i - lenJ;
                    break;
                }
            } else {
                j = 0;
            }
            ++i;
        }
        return ret;
    }

    public static final ArrayList pauseEnter(String str) throws InputException {
        int len;
        String enter = null;
        String tmp = null;
        ArrayList<String> ret = null;
        if (str == null || (len = str.length()) <= 0) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        ret = new ArrayList<String>();
        enter = BaseDef.ENTER_SEPARATOR;
        int enterLen = enter.length();
        if (enterLen == 1) {
            char enterCode0 = enter.charAt(0);
            int i = 0;
            int s = -1;
            while (i < len) {
                int n = s = s == -1 ? i : s;
                if (str.charAt(i) == enterCode0) {
                    tmp = str.substring(s, i);
                    ret.add(tmp);
                    tmp = null;
                    s = -1;
                }
                ++i;
            }
            if (s != -1) {
                tmp = str.substring(s, len);
                ret.add(tmp);
                tmp = null;
            }
            enter = null;
            return ret;
        }
        if (enterLen == 2) {
            char enterCode0 = enter.charAt(0);
            char enterCode1 = enter.charAt(1);
            int i = 0;
            int s = -1;
            while (i < len) {
                int n = s = s == -1 ? i : s;
                if (str.charAt(i) == enterCode0 && i < len && str.charAt(i + 1) == enterCode1) {
                    tmp = str.substring(s, i);
                    ret.add(tmp);
                    tmp = null;
                    s = -1;
                    ++i;
                }
                ++i;
            }
            if (s != -1) {
                tmp = str.substring(s, len);
                ret.add(tmp);
                tmp = null;
            }
            enter = null;
            return ret;
        }
        enter = null;
        throw new InputException("\u5bfe\u8c61\u306e\u6539\u884c\u60c5\u5831\u306f\u3001\u30b5\u30dd\u30fc\u30c8\u5916\u3067\u3059[" + enterLen + "]-enter.length");
    }

    public static final ArrayList pauseYen(String str) throws InputException {
        int len;
        int s = -1;
        String tmp = null;
        ArrayList<String> ret = null;
        if (str == null || (len = str.length()) <= 0) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        ret = new ArrayList<String>();
        char yenCode = "\\".charAt(0);
        int i = 0;
        s = -1;
        while (i < len) {
            int n = s = s == -1 ? i : s;
            if (str.charAt(i) == yenCode) {
                tmp = str.substring(s, i);
                ret.add(tmp);
                tmp = null;
                s = -1;
            }
            ++i;
        }
        if (s != -1) {
            tmp = str.substring(s, len);
            ret.add(tmp);
            tmp = null;
        }
        return ret;
    }

    public static final ArrayList pauseSlash(String str) throws InputException {
        int len;
        int s = -1;
        String tmp = null;
        if (str == null || (len = str.length()) <= 0) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        ArrayList<String> ret = new ArrayList<String>();
        char slashCode = "/".charAt(0);
        int i = 0;
        s = -1;
        while (i < len) {
            int n = s = s == -1 ? i : s;
            if (str.charAt(i) == slashCode) {
                tmp = str.substring(s, i);
                ret.add(tmp);
                tmp = null;
                s = -1;
            }
            ++i;
        }
        if (s != -1) {
            tmp = str.substring(s, len);
            ret.add(tmp);
            tmp = null;
        }
        return ret;
    }

    public static final ArrayList pauseCoat(String str) throws InputException {
        int len;
        int s = -1;
        boolean flg = false;
        String tmp = null;
        ArrayList<String> ret = null;
        if (str == null || (len = str.length()) <= 0) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        ret = new ArrayList<String>();
        char singleCoat = "'".charAt(0);
        char doubleCoat = "\"".charAt(0);
        int i = 0;
        s = -1;
        while (i < len) {
            if ((str.charAt(i) == singleCoat || str.charAt(i) == doubleCoat) && s == -1) {
                flg = str.charAt(i) != singleCoat;
                s = i + 1;
            } else if (s != -1 && (str.charAt(i) == singleCoat && !flg || str.charAt(i) == doubleCoat && flg)) {
                if (i - s == 0) {
                    ret.add(new String(""));
                    s = -1;
                } else {
                    tmp = str.substring(s, i);
                    ret.add(tmp);
                    tmp = null;
                    s = -1;
                }
            }
            ++i;
        }
        return ret;
    }

    public static final String trimPlus(String str) throws InputException {
        char now;
        int len;
        String ret = null;
        if (str == null || (len = str.length()) <= 0) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        char spaceCode = ADD_REM_CODE.charAt(0);
        char tabCode = "\t".charAt(0);
        char space2Code = "\u3000".charAt(0);
        int i = 0;
        int s = -1;
        while (i < len) {
            now = str.charAt(i);
            if (now != spaceCode && now != tabCode && now != space2Code && now != '\u0000') {
                s = i;
                break;
            }
            ++i;
        }
        i = len - 1;
        int e = -1;
        while (i >= 0) {
            now = str.charAt(i);
            if (now != spaceCode && now != tabCode && now != space2Code && now != '\u0000') {
                e = i;
                break;
            }
            --i;
        }
        if (s == -1 && e == -1) {
            if (s == -1 && e == -1) {
                return "";
            }
            return null;
        }
        s = s == -1 ? 0 : s;
        e = e == -1 ? len - 1 : e;
        ret = str.substring(s, e + 1);
        return ret;
    }

    public static final String catString(String message, int size) throws InputException {
        StringBuffer buf = null;
        String ret = null;
        if (message == null || size <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int msgLen = message.length();
        int len = msgLen / size;
        int etcLen = msgLen % size;
        buf = new StringBuffer(msgLen + len * 2);
        int i = 0;
        int st = 0;
        int ed = size;
        while (i < len) {
            buf.append(message.substring(st, ed));
            buf.append(BaseDef.ENTER_SEPARATOR);
            st = ed;
            ed += size;
            ++i;
        }
        if (etcLen != 0) {
            buf.append(message.substring(msgLen - etcLen, msgLen));
        }
        ret = buf.toString();
        buf = null;
        return ret;
    }

    public static final int checkString(String str, String chk) throws InputException {
        int chkLen;
        int len;
        if (str == null || chk == null || (len = str.length()) <= 0 || (chkLen = chk.length()) <= 0) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        int i = 0;
        int j = 0;
        int s = -1;
        int ret = 0;
        while (i < len) {
            int n = s = s == -1 ? i : s;
            if (str.charAt(i) == chk.charAt(j)) {
                if (j >= chkLen - 1) {
                    int e = i - chkLen;
                    if (e <= 0) {
                        ++ret;
                        s = -1;
                        j = 0;
                    } else {
                        s = -1;
                        j = 0;
                        ++ret;
                    }
                } else {
                    ++j;
                }
            } else {
                j = 0;
            }
            ++i;
        }
        return ret;
    }

    public static final String changeStringByOneDest(String str, String src, char dest) throws InputException {
        int len;
        char[] chrs = null;
        ArrayList<Integer> lst = null;
        String ret = null;
        if (str == null || str.length() <= 0 || src == null || (len = src.length()) <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        lst = new ArrayList<Integer>();
        int i = 0;
        int pnt = 0;
        while (i < len) {
            char chk = src.charAt(i);
            pnt = 0;
            while ((pnt = str.indexOf(chk, pnt)) != -1) {
                lst.add(new Integer(pnt));
                ++pnt;
            }
            ++i;
        }
        len = lst.size();
        if (len > 0) {
            chrs = str.toCharArray();
            i = 0;
            while (i < len) {
                chrs[((Integer)lst.get((int)i)).intValue()] = dest;
                ++i;
            }
            ret = new String(chrs);
        } else {
            ret = str;
        }
        if (lst != null) {
            lst.clear();
        }
        return ret;
    }

    public static final String changeString(String str, String src, String dest) throws InputException {
        int end;
        int destLen;
        int srcLen;
        StringBuffer buf = null;
        if (str == null || str.length() <= 0 || src == null || (srcLen = src.length()) <= 0 || dest == null || (destLen = dest.length()) <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        buf = new StringBuffer();
        int pnt = str.indexOf(src);
        if (pnt == -1) {
            return str;
        }
        if (pnt == 0) {
            buf.append(dest);
            end = srcLen;
        } else {
            buf.append(str.substring(0, pnt));
            buf.append(dest);
            end = pnt + srcLen;
        }
        pnt += srcLen;
        while (true) {
            if ((pnt = str.indexOf(src, pnt)) == -1) break;
            if (pnt == end) {
                buf.append(dest);
            } else {
                buf.append(str.substring(end, pnt));
                buf.append(dest);
            }
            end = pnt + srcLen;
            pnt += srcLen;
        }
        buf.append(str.substring(end));
        return buf.toString();
    }

    public static final String getCodes(String code, int size) throws InputException {
        StringBuffer buf = null;
        String ret = null;
        if (code == null || code.length() <= 0 || size <= 0) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        buf = new StringBuffer();
        char addCode = code.charAt(0);
        int i = 0;
        while (i < size) {
            buf.append(addCode);
            ++i;
        }
        ret = buf.toString();
        buf = null;
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String setLengthToFilledBinary(boolean mode, String info, String param, int size) throws InputException, ReadException {
        String string;
        int[] codeLen = null;
        StringBuffer buf = null;
        String ret = null;
        if (info == null) throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        int strLen = info.length();
        if (strLen < 0) throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        if (param == null) throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        if (param.length() <= 0) throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        if (size <= 0) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        try {
            try {
                block24: {
                    int byteLen;
                    block26: {
                        buf = new StringBuffer();
                        byteLen = info.getBytes(CHECK_SJIS_CHARSET).length;
                        if (byteLen < size) break block26;
                        codeLen = UtilCom.getZenToHanString(info);
                        int len = codeLen.length;
                        if (mode) {
                            int i = len - 1;
                            int cnt = 0;
                            while (i >= 0) {
                                if ((cnt += codeLen[i]) >= size) {
                                    int rem = cnt - size;
                                    if (rem == 1) {
                                        buf.append(ADD_REM_CODE);
                                        buf.append(info.substring(i + 1));
                                        break block24;
                                    } else {
                                        buf.append(info.substring(i));
                                    }
                                    break block24;
                                }
                                --i;
                            }
                            break block24;
                        } else {
                            int i = 0;
                            int cnt = 0;
                            while (i < len) {
                                if ((cnt += codeLen[i]) >= size) {
                                    int rem = cnt - size;
                                    if (rem == 1) {
                                        buf.append(info.substring(0, i));
                                        buf.append(ADD_REM_CODE);
                                        break block24;
                                    } else {
                                        buf.append(info.substring(0, i + 1));
                                    }
                                    break block24;
                                }
                                ++i;
                            }
                        }
                        break block24;
                    }
                    int addLen = size - byteLen;
                    codeLen = UtilCom.getZenToHanString(param);
                    if (addLen % codeLen[0] != 0) {
                        addLen /= codeLen[0];
                        if (mode) {
                            buf.append(ADD_REM_CODE);
                            if (addLen != 0) {
                                buf.append(UtilCom.getCodes(param, addLen));
                            }
                            buf.append(info);
                        } else {
                            buf.append(info);
                            if (addLen != 0) {
                                buf.append(UtilCom.getCodes(param, addLen));
                            }
                            buf.append(ADD_REM_CODE);
                        }
                    } else {
                        addLen /= codeLen[0];
                        if (mode) {
                            buf.append(UtilCom.getCodes(param, addLen));
                            buf.append(info);
                        } else {
                            buf.append(info);
                            buf.append(UtilCom.getCodes(param, addLen));
                        }
                    }
                }
                string = ret = buf.toString();
                Object var13_20 = null;
                buf = null;
            }
            catch (UnsupportedEncodingException ue) {
                throw new ReadException(ue);
            }
            catch (InputException in) {
                throw in;
            }
        }
        catch (Throwable throwable) {
            Object var13_21 = null;
            buf = null;
            codeLen = null;
            throw throwable;
        }
        codeLen = null;
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String setLengthToFilledString(boolean mode, String info, String param, int size) throws InputException {
        StringBuffer buf = null;
        String ret = null;
        if (info == null) throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        int strLen = info.length();
        if (strLen < 0) throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        if (param == null) throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        if (param.length() <= 0) throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        if (size <= 0) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        try {
            buf = new StringBuffer();
            if (strLen >= size) {
                if (mode) {
                    buf.append(info.substring(strLen - size));
                    ret = buf.toString();
                    return ret;
                } else {
                    buf.append(info.substring(0, size));
                }
                ret = buf.toString();
                return ret;
            }
            if (mode) {
                buf.append(UtilCom.getCodes(param, size - strLen));
                buf.append(info);
                ret = buf.toString();
                return ret;
            } else {
                buf.append(info);
                buf.append(UtilCom.getCodes(param, size - strLen));
            }
            ret = buf.toString();
            return ret;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            buf = null;
            throw throwable;
        }
    }

    public static final int searchString(String info, String search, int offset) throws InputException {
        int searchLen;
        int len;
        if (info == null || search == null || (len = info.length()) <= 0 || (searchLen = search.length()) <= 0 || offset < 0 || offset + searchLen >= len) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        char searchChr = search.charAt(0);
        int i = offset;
        int j = -1;
        int ret = -1;
        while (i < len) {
            char chkChr = info.charAt(i);
            if (j == -1 && chkChr == searchChr) {
                ret = i--;
                j = 0;
            } else if (j != -1 && chkChr == search.charAt(j)) {
                if (++j >= searchLen) {
                    break;
                }
            } else {
                j = -1;
                ret = -1;
            }
            ++i;
        }
        return ret;
    }

    public static final ArrayList sawCSV(String info) throws InputException {
        int len;
        int count = 0;
        int getCount = 0;
        int startPoint = -1;
        int endPoint = -1;
        char pauseCode = '\u0000';
        ArrayList<String> ret = null;
        pauseCode = ",".charAt(0);
        if (info == null || (len = info.length()) <= 0) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        ret = new ArrayList<String>();
        int i = 0;
        count = 0;
        while (i < info.length()) {
            count += pauseCode == info.charAt(i) ? 1 : 0;
            ++i;
        }
        if (count == 0) {
            ret.add(new String(info));
            return ret;
        }
        getCount = count + 1;
        i = 0;
        count = 0;
        startPoint = 0;
        while (i < info.length()) {
            if (pauseCode == info.charAt(i)) {
                endPoint = i + 1 - 1;
                if (endPoint == startPoint) {
                    ret.add(new String(""));
                } else {
                    ret.add(new String(info.substring(startPoint, endPoint)));
                }
                startPoint = endPoint + 1;
                ++count;
            }
            ++i;
        }
        endPoint = info.length() - 1 + 1 - 1 + 1;
        if (endPoint == startPoint) {
            ret.add(new String(""));
        } else {
            ret.add(new String(info.substring(startPoint, endPoint)));
        }
        return ret;
    }

    public static final ArrayList getNowTimestamp() {
        ArrayList<String> ret = null;
        String[] data = null;
        data = UtilCom.getNowTimestampByString();
        ret = new ArrayList<String>();
        ret.add(data[0]);
        ret.add(data[1]);
        ret.add(data[2]);
        ret.add(data[3]);
        ret.add(data[4]);
        ret.add(data[5]);
        ret.add(data[6]);
        ret.add(data[7]);
        ret.add(data[8]);
        data[0] = null;
        data[1] = null;
        data[2] = null;
        data[3] = null;
        data[4] = null;
        data[5] = null;
        data[6] = null;
        data[7] = null;
        data[8] = null;
        data = null;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int getTimeByInteger() {
        Calendar now;
        Calendar calendar = now = Calendar.getInstance();
        synchronized (calendar) {
            int y = now.get(1);
            int m = now.get(2);
            int d = now.get(5);
            int th = now.get(11);
            int tm = now.get(12);
            return y & 0xFFF | (m & 0xF) << 12 | (d & 0x1F) << 16 | (th & 0x1F) << 21 | (tm & 0x3F) << 26;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Calendar getIntByCalendar(int time) {
        Calendar ret;
        Calendar calendar = ret = Calendar.getInstance();
        synchronized (calendar) {
            ret.clear();
            ret.set(1, time & 0xFFF);
            ret.set(2, (time & 0xF000) >> 12 & 0xF);
            ret.set(5, (time & 0x1F0000) >> 16 & 0x1F);
            ret.set(11, (time & 0x3E00000) >> 21 & 0x1F);
            ret.set(12, (time & 0xFC000000) >> 26 & 0x3F);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final java.util.Date getIntByDate(int time) {
        Calendar cl = null;
        java.util.Date ret = null;
        Calendar calendar = cl = UtilCom.getIntByCalendar(time);
        synchronized (cl) {
            if (cl != null) {
                ret = cl.getTime();
                cl = null;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return ret;
        }
    }

    public static final String[] getNowTimestampByString() {
        String[] ret = null;
        ret = new String[9];
        UtilCom.getNowTimestampByString(ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void getNowTimestampByString(String[] out) {
        Calendar now = null;
        if (out == null || out.length != 9) {
            return;
        }
        Calendar calendar = now = Calendar.getInstance();
        synchronized (calendar) {
            out[0] = String.valueOf(now.get(1));
            out[1] = String.valueOf(now.get(2) + 1);
            out[2] = String.valueOf(now.get(5));
            out[3] = String.valueOf(now.get(11));
            out[4] = String.valueOf(now.get(12));
            out[5] = String.valueOf(now.get(13));
            out[6] = String.valueOf(now.get(14));
            switch (now.get(7)) {
                case 1: {
                    out[7] = "\u65e5";
                    out[8] = "SUN";
                    break;
                }
                case 2: {
                    out[7] = "\u6708";
                    out[8] = "MON";
                    break;
                }
                case 3: {
                    out[7] = "\u706b";
                    out[8] = "TUE";
                    break;
                }
                case 4: {
                    out[7] = "\u6c34";
                    out[8] = "WED";
                    break;
                }
                case 5: {
                    out[7] = "\u6728";
                    out[8] = "THU";
                    break;
                }
                case 6: {
                    out[7] = "\u91d1";
                    out[8] = "FRI";
                    break;
                }
                case 7: {
                    out[7] = "\u571f";
                    out[8] = "SAT";
                    break;
                }
                default: {
                    out[7] = "?";
                    out[8] = "?";
                }
            }
        }
    }

    public static final ArrayList getTimestamp(Calendar code) {
        ArrayList<String> ret = null;
        String[] data = null;
        data = UtilCom.getTimestampByString(code);
        ret = new ArrayList<String>();
        ret.add(data[0]);
        ret.add(data[1]);
        ret.add(data[2]);
        ret.add(data[3]);
        ret.add(data[4]);
        ret.add(data[5]);
        ret.add(data[6]);
        ret.add(data[7]);
        ret.add(data[8]);
        data[0] = null;
        data[1] = null;
        data[2] = null;
        data[3] = null;
        data[4] = null;
        data[5] = null;
        data[6] = null;
        data[7] = null;
        data[8] = null;
        data = null;
        return ret;
    }

    public static final String[] getTimestampByString(Calendar code) {
        String[] ret = null;
        ret = new String[9];
        UtilCom.getTimestampByString(code, ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void getTimestampByString(Calendar code, String[] out) {
        if (out == null || out.length != 9) {
            return;
        }
        Calendar calendar = code;
        synchronized (calendar) {
            out[0] = String.valueOf(code.get(1));
            out[1] = String.valueOf(code.get(2) + 1);
            out[2] = String.valueOf(code.get(5));
            out[3] = String.valueOf(code.get(11));
            out[4] = String.valueOf(code.get(12));
            out[5] = String.valueOf(code.get(13));
            out[6] = String.valueOf(code.get(14));
            switch (code.get(7)) {
                case 1: {
                    out[7] = "\u65e5";
                    out[8] = "SUN";
                    break;
                }
                case 2: {
                    out[7] = "\u6708";
                    out[8] = "MON";
                    break;
                }
                case 3: {
                    out[7] = "\u706b";
                    out[8] = "TUE";
                    break;
                }
                case 4: {
                    out[7] = "\u6c34";
                    out[8] = "WED";
                    break;
                }
                case 5: {
                    out[7] = "\u6728";
                    out[8] = "THU";
                    break;
                }
                case 6: {
                    out[7] = "\u91d1";
                    out[8] = "FRI";
                    break;
                }
                case 7: {
                    out[7] = "\u571f";
                    out[8] = "SAT";
                    break;
                }
                default: {
                    out[7] = "?";
                    out[8] = "?";
                }
            }
        }
    }

    public static final Date getNowDateToSql() {
        Date ret = null;
        ret = new Date(System.currentTimeMillis());
        return ret;
    }

    public static final Time getNowTimeToSql() {
        Time ret = null;
        ret = new Time(System.currentTimeMillis());
        return ret;
    }

    public static final Timestamp getNowTimestampToSql() {
        Timestamp ret = null;
        ret = new Timestamp(System.currentTimeMillis());
        return ret;
    }

    public static final boolean checkStringByNumber(String info) throws InputException {
        int len;
        if (info == null || (len = info.length()) <= 0) {
            throw new InputException("\u5f15\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        int i = 0;
        boolean ret = true;
        while (i < len) {
            char chk = info.charAt(i);
            if ((chk < '0' || chk > '9') && chk != '.') {
                ret = false;
                break;
            }
            ++i;
        }
        return ret;
    }

    public static final String convertBinaryTo16String(byte[] binary) {
        if (binary == null || binary.length <= 0) {
            return ADD_REM_CODE;
        }
        return UtilCom.convertBinaryTo16String(binary, 0, binary.length);
    }

    public static final String convertBinaryTo16String(byte[] binary, int offset, int length) {
        if (binary == null || binary.length <= 0) {
            return ADD_REM_CODE;
        }
        return UtilCom.convertBinaryTo16String(Resource.createBinResource(null, binary), offset, length);
    }

    /*
     * Exception decompiling
     */
    public static final String convertBinaryTo16String(BinResource resource, int offset, int length) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 123->126)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final String convertBinaryTo16String(byte[] binary, char rem, int offset, int length) {
        if (binary == null || binary.length <= 0) {
            return ADD_REM_CODE;
        }
        return UtilCom.convertBinaryTo16String(Resource.createBinResource(null, binary), rem, 0, binary.length);
    }

    /*
     * Exception decompiling
     */
    public static final String convertBinaryTo16String(BinResource resource, char rem, int offset, int length) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 139->142)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static final byte[] convert16StringToBinary(boolean remFlg, String string) throws InputException {
        String tmp = null;
        byte[] ret = null;
        StringBuffer buf = null;
        try {
            try {
                int i;
                int len = string.length();
                if (remFlg) {
                    buf = new StringBuffer(len);
                    i = 0;
                    while (i < len) {
                        if (i % 3 != 2) {
                            char code = string.charAt(i);
                            buf.append(code);
                        }
                        ++i;
                    }
                    tmp = buf.toString();
                } else {
                    tmp = string;
                }
                len = tmp.length();
                int lenJ = len / 2;
                ret = new byte[lenJ];
                i = 0;
                int j = 0;
                while (j < lenJ) {
                    int codeA = tmp.charAt(i) - 48;
                    int codeB = tmp.charAt(i + 1) - 48;
                    if (codeA < 0 || codeA > 9 || codeB < 0 || codeB > 9) {
                        throw new InputException("\u5bfe\u8c61\u30c7\u30fc\u30bf\u306e\u5909\u63db(" + i + ")\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                    }
                    ret[j] = (byte)((codeA & 0xF) << 4 | codeB & 0xF);
                    i += 2;
                    ++j;
                }
                byte[] byArray = ret;
                Object var13_13 = null;
                tmp = null;
                buf = null;
                return byArray;
            }
            catch (Exception t) {
                throw new InputException(t);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            tmp = null;
            buf = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final byte[] convertString16ToBinary(String code) throws InputException, UnsupportException {
        char[] cnv = null;
        byte[] ret = null;
        int[] tmp = null;
        try {
            try {
                int len = code.length();
                if (len % 2 == 1) {
                    throw new InputException("\u6307\u5b9a\u6587\u5b57\u9577\u306f\u3001\u5947\u6570\u3067\u306f\u5bfe\u5fdc\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
                }
                code.toUpperCase();
                ret = new byte[len /= 2];
                cnv = new char[2];
                tmp = new int[2];
                int i = 0;
                int j = 0;
                while (i < len) {
                    cnv[0] = code.charAt(j);
                    cnv[1] = code.charAt(j + 1);
                    int n = cnv[0] >= '0' && cnv[0] <= '9' ? cnv[0] - 48 : (cnv[0] >= 'A' && cnv[0] <= 'F' ? cnv[0] - 65 + 10 : (tmp[0] = cnv[0] >= 'a' && cnv[0] <= 'f' ? cnv[0] - 97 + 10 : -1));
                    tmp[1] = cnv[1] >= '0' && cnv[1] <= '9' ? cnv[1] - 48 : (cnv[1] >= 'A' && cnv[1] <= 'F' ? cnv[1] - 65 + 10 : (cnv[1] >= 'a' && cnv[1] <= 'f' ? cnv[1] - 97 + 10 : -1));
                    if (tmp[0] == -1) throw new UnsupportException("\u6307\u5b9a\u5f15\u6570\u306f\u3001\u6570\u5024(16\u9032\u6570)\u4ee5\u5916\u306e\u60c5\u5831\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059");
                    if (tmp[1] == -1) {
                        throw new UnsupportException("\u6307\u5b9a\u5f15\u6570\u306f\u3001\u6570\u5024(16\u9032\u6570)\u4ee5\u5916\u306e\u60c5\u5831\u304c\u542b\u307e\u308c\u3066\u3044\u307e\u3059");
                    }
                    ret[i] = (byte)(tmp[1] & 0xF | (tmp[0] & 0xF) << 4);
                    ++i;
                    j += 2;
                }
            }
            catch (NullPointerException nul) {
                throw new InputException(nul);
            }
            catch (UnsupportException ue) {
                throw ue;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            cnv = null;
            tmp = null;
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        cnv = null;
        tmp = null;
        return ret;
    }

    /*
     * Exception decompiling
     */
    public static final Object createObject(String name, ClassLoader loader) throws InputException, AccessException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [7 : 165->168)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void putSerialize(String name, Serializable obj) throws InputException, AccessException {
        o = null;
        if (name == null) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        if (name.length() <= 0) throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        if (obj == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            try {
                o = new ObjectOutputStream(new FileOutputStream(name));
                o.writeObject(obj);
            }
            catch (Exception e) {
                throw new AccessException(e);
            }
        }
        catch (Throwable var5_4) {
            var4_5 = null;
            try {
                o.close();
            }
            catch (Exception var6_7) {
                // empty catch block
            }
            o = null;
            throw var5_4;
        }
        {
            var4_6 = null;
        }
        ** try [egrp 2[TRYBLOCK] [3 : 71->78)] { 
lbl26:
        // 1 sources

        o.close();
        return;
lbl28:
        // 1 sources

        catch (Exception var6_8) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Serializable getSerialize(String name) {
        block10: {
            in = null;
            ret = null;
            if (name == null) return ret;
            if (name.length() <= 0) {
                return ret;
            }
            try {
                try {
                    in = new ObjectInputStream(new FileInputStream(name));
                    ret = (Serializable)in.readObject();
                }
                catch (Exception e) {
                    ret = null;
                }
            }
            catch (Throwable var5_4) {
                var4_5 = null;
                try {
                    in.close();
                }
                catch (Exception var6_7) {
                    // empty catch block
                }
                in = null;
                throw var5_4;
            }
            {
                var4_6 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 60->67)] { 
lbl27:
            // 1 sources

            in.close();
            break block10;
lbl29:
            // 1 sources

            catch (Exception var6_8) {
                // empty catch block
            }
        }
        in = null;
        return ret;
    }

    /*
     * Exception decompiling
     */
    public static Serializable copyObject(Serializable obj) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 175->178)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static final byte[] convertObjectByBinary(Serializable obj) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 84->87)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static final Serializable convertBinaryByObject(byte[] bin) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 93->96)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final InputStream getClassToFile(String name) throws AccessException {
        InputStream ret = null;
        try {
            ret = new UtilCom().getClasspathToFileObject(name);
        }
        catch (Exception e) {
            throw new AccessException(e);
        }
        return ret;
    }

    public static final Object convertObject(String value) {
        Object ret = null;
        ret = UtilCom.convertNumber(value);
        if (ret == null && (ret = UtilCom.convertFloat(value)) == null && (ret = UtilCom.convertBoolean(value)) == null) {
            ret = value;
        }
        return ret;
    }

    public static final String createSpace(int len) {
        StringBuffer buf = null;
        if (len <= 0) {
            return "";
        }
        buf = new StringBuffer();
        int i = 0;
        while (i < len) {
            buf.append(ADD_REM_CODE);
            ++i;
        }
        return buf.toString();
    }

    public static final String catCote(String str) {
        if (str == null || str.length() <= 0) {
            if (str == null) {
                return null;
            }
            return "";
        }
        return (str = str.trim()).startsWith("'") && str.endsWith("'") || str.startsWith("\"") && str.endsWith("\"") ? str.substring(1, str.length() - 1) : str;
    }

    public static final void checkBinary(byte[] src, byte[] dest) throws AccessException {
        if (src == null || dest == null) {
            if (src == null) {
                throw new AccessException("\u6bd4\u8f03\u5143[src]\u306e\u30d0\u30a4\u30ca\u30ea\u306f\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            throw new AccessException("\u6bd4\u8f03\u5148[dest]\u306e\u30d0\u30a4\u30ca\u30ea\u306f\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        int len = src.length;
        if (len != dest.length) {
            throw new AccessException("\u6bd4\u8f03\u5143[src:length(" + len + ")]\u3068\u6bd4\u8f03\u5148[dest:length(" + dest.length + ")]\u306f\u9577\u3055\u304c\u9055\u3044\u307e\u3059");
        }
        int i = 0;
        while (i < len) {
            if (src[i] != dest[i]) {
                throw new AccessException("\u6bd4\u8f03\u5143[src:data(" + (src[i] & 0xFF) + ")]\u3068\u6bd4\u8f03\u5148[dest:data(" + (dest[i] & 0xFF) + ")]\u306f\u5185\u5bb9\u304c\u9055\u3044\u307e\u3059(point:" + i + ")");
            }
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    private static final Long convertNumber(String value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 509->512)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final Double convertFloat(String value) {
        Double ret = null;
        try {
            ret = new Double(value);
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    private static final Boolean convertBoolean(String value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 101->104)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final InputStream getClasspathToFileObject(String name) throws Exception {
        return this.getClass().getClassLoader().getResourceAsStream(name);
    }
}

