/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.util.array;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.serialize.SerializeUtil;
import java.io.Serializable;

public class BooleanArray
implements Serializable {
    private static final long serialVersionUID;
    private boolean[] m_array = null;
    private int m_startLength = 16;
    private int m_length = 16;
    private int m_nowSize = 0;
    private long m_timer = 0L;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.JRcServer.commons.util.array.BooleanArray");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        serialVersionUID = SerializeUtil.serialVersionUID(clazz.getName());
    }

    public BooleanArray() {
    }

    public BooleanArray(int length) {
        this.m_startLength = length < 2 || length > 9999 ? 16 : length;
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void clear() {
        this.m_array = null;
        this.m_length = 16;
        this.m_nowSize = 0;
    }

    public final void add(Boolean value) throws InputException {
        if (value == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.add((boolean)value);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void add(boolean value) {
        boolean[] info = null;
        boolean[] tmp = null;
        info = this.m_array;
        int length = this.m_length;
        int nowSize = this.m_nowSize;
        try {
            try {
                info[nowSize] = value;
            }
            catch (NullPointerException nul) {
                info = new boolean[length];
                info[nowSize] = value;
                this.m_array = info;
            }
            catch (IndexOutOfBoundsException io) {
                tmp = info;
                info = new boolean[length *= 2];
                System.arraycopy(tmp, 0, info, 0, nowSize);
                info[nowSize] = value;
                this.m_length = length;
                this.m_array = info;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            tmp = null;
            info = null;
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        tmp = null;
        info = null;
        ++this.m_nowSize;
    }

    public final void set(int no, Boolean value) throws InputException {
        if (value == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.set(no, (boolean)value);
    }

    public final void set(int no, boolean value) throws InputException {
        int nowLen = this.m_nowSize;
        if (no < 0 || no >= nowLen) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.m_array[no] = value;
    }

    public final boolean remove(int no) {
        boolean[] info = null;
        boolean[] tmp = null;
        boolean ret = false;
        int nowSize = this.m_nowSize;
        int length = this.m_length;
        if (no < 0 || no >= nowSize || nowSize == 0) {
            return false;
        }
        info = this.m_array;
        ret = info[no];
        info[no] = false;
        if (no == 0) {
            tmp = info;
            System.arraycopy(tmp, 1, info, 0, nowSize - 1);
            info[nowSize - 1] = false;
        } else if (nowSize - no != 1) {
            tmp = info;
            System.arraycopy(tmp, 0, info, 0, no);
            System.arraycopy(tmp, no + 1, info, no, nowSize - (no + 1));
            info[nowSize - 1] = false;
        }
        if (--nowSize != 0 && (double)length * 0.375 >= (double)nowSize) {
            int newLength = length / 2;
            tmp = new boolean[newLength];
            System.arraycopy(info, 0, tmp, 0, newLength);
            info = null;
            info = tmp;
            this.m_length = newLength;
        } else if (nowSize == 0) {
            info = null;
        }
        this.m_array = info;
        this.m_nowSize = nowSize;
        info = null;
        tmp = null;
        return ret;
    }

    public final boolean get(int no) {
        if (no < 0 || no >= this.m_nowSize) {
            return false;
        }
        return this.m_array[no];
    }

    public final boolean[] getObjects() {
        return this.m_array;
    }

    public final long getTimer() {
        return this.m_timer;
    }

    public final int size() {
        return this.m_nowSize;
    }

    private final void createTimer() {
        this.m_timer = System.currentTimeMillis();
    }
}

