/*
 * Decompiled with CFR 0.152.
 */
package com.JRcServer.commons.util.array;

import com.JRcServer.commons.exception.InputException;
import com.JRcServer.commons.serialize.SerializeUtil;
import java.io.Serializable;
import java.util.Arrays;

public class CharArray
implements Serializable {
    private static final long serialVersionUID;
    private char[] m_array = null;
    private int m_startLength = 16;
    private int m_length = 16;
    private int m_nowSize = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.JRcServer.commons.util.array.CharArray");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        serialVersionUID = SerializeUtil.serialVersionUID(clazz.getName());
    }

    public CharArray() {
    }

    public CharArray(int length) {
        this.m_startLength = length < 2 || length > 9999 ? 16 : length;
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void clear() {
        this.m_array = null;
        this.m_length = 16;
        this.m_nowSize = 0;
    }

    public final void add(Character value) throws InputException {
        if (value == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.add(value.charValue());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void add(char value) {
        char[] info = null;
        char[] tmp = null;
        info = this.m_array;
        int length = this.m_length;
        int nowSize = this.m_nowSize;
        try {
            try {
                info[nowSize] = value;
            }
            catch (NullPointerException nul) {
                info = new char[length];
                info[nowSize] = value;
                this.m_array = info;
            }
            catch (IndexOutOfBoundsException io) {
                tmp = info;
                info = new char[length *= 2];
                System.arraycopy(tmp, 0, info, 0, nowSize);
                info[nowSize] = value;
                this.m_length = length;
                this.m_array = info;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            tmp = null;
            info = null;
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        tmp = null;
        info = null;
        ++this.m_nowSize;
    }

    public final void add(char[] value) throws InputException {
        this.add(0, -1, value);
    }

    public final void add(int off, char[] value) throws InputException {
        this.add(off, -1, value);
    }

    public final void add(char[] value, int length) throws InputException {
        this.add(0, length, value);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void add(int off, int length, char[] value) throws InputException {
        info = null;
        tmp = null;
        if (value == null || (valueLen = value.length) <= 0) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (off < 0 || off >= valueLen) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        length = length <= 0 || length + off > valueLen ? valueLen - off : length;
        info = this.m_array;
        arrayLen = this.m_length;
        nowSize = this.m_nowSize;
        try {
            try {
                System.arraycopy(info, nowSize, value, off, length);
                ** GOTO lbl-1000
            }
            catch (NullPointerException nul) {}
            while (true) {
                block10: {
                    if (arrayLen <= length) break block10;
                    info = new char[arrayLen];
                    System.arraycopy(info, nowSize, value, off, length);
                    this.m_length = arrayLen;
                    this.m_array = info;
                    ** GOTO lbl-1000
                }
                arrayLen *= 2;
            }
            catch (IndexOutOfBoundsException io) {
                createLen = length + nowSize;
            }
            while (true) {
                block11: {
                    if (arrayLen <= createLen) break block11;
                    tmp = info;
                    info = new char[arrayLen];
                    System.arraycopy(tmp, 0, info, 0, nowSize);
                    System.arraycopy(info, nowSize, value, off, length);
                    this.m_length = arrayLen;
                    this.m_array = info;
                    break;
                }
                arrayLen *= 2;
            }
        }
        catch (Throwable var12_12) {
            var11_13 = null;
            tmp = null;
            info = null;
            throw var12_12;
        }
lbl-1000:
        // 3 sources

        {
            var11_14 = null;
        }
        tmp = null;
        info = null;
        this.m_nowSize += length;
    }

    public final void set(int no, Character value) throws InputException {
        if (value == null) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.set(no, value.charValue());
    }

    public final void set(int no, char value) throws InputException {
        int nowLen = this.m_nowSize;
        if (no < 0 || no >= nowLen) {
            throw new InputException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.m_array[no] = value;
    }

    public final char remove(int no) {
        char[] info = null;
        char[] tmp = null;
        char ret = '\uffff';
        int nowSize = this.m_nowSize;
        int length = this.m_length;
        if (no < 0 || no >= nowSize || nowSize == 0) {
            return '\uffff';
        }
        info = this.m_array;
        ret = info[no];
        info[no] = '\u0000';
        if (no == 0) {
            tmp = info;
            System.arraycopy(tmp, 1, info, 0, nowSize - 1);
            info[nowSize - 1] = '\u0000';
        } else if (nowSize - no != 1) {
            tmp = info;
            System.arraycopy(tmp, 0, info, 0, no);
            System.arraycopy(tmp, no + 1, info, no, nowSize - (no + 1));
            info[nowSize - 1] = '\u0000';
        }
        if (--nowSize != 0 && (double)length * 0.375 >= (double)nowSize) {
            int newLength = length / 2;
            tmp = new char[newLength];
            System.arraycopy(info, 0, tmp, 0, newLength);
            info = null;
            info = tmp;
            this.m_length = newLength;
        } else if (nowSize == 0) {
            info = null;
        }
        this.m_array = info;
        this.m_nowSize = nowSize;
        info = null;
        tmp = null;
        return ret;
    }

    public final char[] remove(int no, int length) {
        char[] info = null;
        char[] tmp = null;
        char[] ret = null;
        int nowSize = this.m_nowSize;
        int arrayLen = this.m_length;
        if (no < 0 || no >= nowSize || nowSize == 0) {
            return null;
        }
        length = length <= 0 || length + no <= nowSize ? nowSize - no : length;
        info = this.m_array;
        ret = new char[length];
        System.arraycopy(info, no, ret, 0, length);
        Arrays.fill(info, nowSize - length, nowSize, '\u0000');
        if (no == 0) {
            tmp = info;
            System.arraycopy(tmp, no, info, 0, nowSize - length);
        } else if (nowSize - no != length) {
            tmp = info;
            System.arraycopy(tmp, 0, info, 0, no);
            System.arraycopy(tmp, no + length, info, no, nowSize - (no + length));
        }
        if ((nowSize -= length) != 0 && (double)arrayLen * 0.375 >= (double)nowSize) {
            int createLen = (int)((double)arrayLen * 0.375);
            while (arrayLen <= createLen) {
                arrayLen /= 2;
            }
            tmp = new char[arrayLen *= 2];
            System.arraycopy(info, 0, tmp, 0, arrayLen);
            info = null;
            info = tmp;
            this.m_length = arrayLen;
        } else if (nowSize == 0) {
            info = null;
        }
        this.m_array = info;
        this.m_nowSize = nowSize;
        info = null;
        tmp = null;
        return ret;
    }

    public final char get(int no) {
        if (no < 0 || no >= this.m_nowSize) {
            return '\uffff';
        }
        return this.m_array[no];
    }

    public final char[] get(int no, int length) {
        char[] ret = null;
        int nowSize = this.m_nowSize;
        if (no < 0 || no >= nowSize) {
            return null;
        }
        length = length <= 0 || length + no <= nowSize ? nowSize - no : length;
        ret = new char[length];
        System.arraycopy(this.m_array, no, ret, 0, length);
        return ret;
    }

    public final int get(char[] out, int no) {
        int nowSize = this.m_nowSize;
        if (out == null || no < 0 || no >= nowSize) {
            return 0;
        }
        int ret = out.length;
        ret = ret <= 0 || ret + no <= nowSize ? nowSize - no : ret;
        System.arraycopy(this.m_array, no, out, 0, ret);
        return ret;
    }

    public final void sort() {
        if (this.m_nowSize != 0) {
            Arrays.sort(this.m_array, 0, this.m_nowSize);
        }
    }

    public final int indexOf(char key) {
        return this.indexOf(key, 0);
    }

    public final int indexOf(char key, int index) {
        int ret;
        char[] tmp = null;
        if (this.m_nowSize != 0) {
            int len = this.m_nowSize - index;
            tmp = new char[len];
            System.arraycopy(this.m_array, index, tmp, 0, len);
            Arrays.sort(tmp);
            ret = Arrays.binarySearch(tmp, key);
            tmp = null;
            ret = ret < 0 || ret >= this.m_nowSize ? -1 : ret;
        } else {
            ret = -1;
        }
        return ret;
    }

    public final char[] getObjects() {
        return this.m_array;
    }

    public final int size() {
        return this.m_nowSize;
    }
}

